/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.io;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.DocumentSequence;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.HttpUtils;
import com.xmlcalabash.util.JSONtoXML;
import com.xmlcalabash.util.TreeWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Logger;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.json.JSONTokener;

public class ReadableData
implements ReadablePipe {
    protected String contentType = null;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    public static final QName _contentType = new QName("", "content-type");
    public static final QName c_contentType = new QName("c", "http://www.w3.org/ns/xproc-step", "content-type");
    public static final QName _encoding = new QName("", "encoding");
    public static final QName c_encoding = new QName("c", "http://www.w3.org/ns/xproc-step", "encoding");
    private int pos = 0;
    private QName wrapper = null;
    private String uri = null;
    private InputStream inputStream = null;
    private String serverContentType = "content/unknown";
    private XProcRuntime runtime = null;
    private DocumentSequence documents = null;
    private Step reader = null;

    public ReadableData(XProcRuntime xProcRuntime, QName qName, String string, String string2) {
        this(xProcRuntime, qName, string, null, string2);
    }

    public ReadableData(XProcRuntime xProcRuntime, QName qName, InputStream inputStream, String string) {
        this(xProcRuntime, qName, null, inputStream, string);
    }

    private ReadableData(XProcRuntime xProcRuntime, QName qName, String string, InputStream inputStream, String string2) {
        this.runtime = xProcRuntime;
        this.uri = string;
        this.inputStream = inputStream;
        this.wrapper = qName;
        this.contentType = string2;
    }

    private DocumentSequence ensureDocuments() {
        if (this.documents != null) {
            return this.documents;
        }
        this.documents = new DocumentSequence(this.runtime);
        if (this.uri == null && this.inputStream == null) {
            return this.documents;
        }
        String string = this.parseContentType(this.contentType);
        String string2 = this.parseCharset(this.contentType);
        URI uRI = this.uri == null ? null : this.getDataUri(this.uri);
        TreeWriter treeWriter = new TreeWriter(this.runtime);
        treeWriter.startDocument(uRI);
        try {
            InputStream inputStream = this.uri == null ? this.inputStream : ("-".equals(this.uri) ? System.in : this.getStream(uRI));
            String string3 = this.getContentType();
            if (this.contentType != null && "content/unknown".equals(string3)) {
                string3 = this.contentType;
            }
            String string4 = this.parseContentType(string3);
            String string5 = this.parseCharset(string3);
            if (string5 != null) {
                string3 = string4 + "; charset=\"" + string5 + "\"";
            }
            String string6 = string5;
            if (this.uri != null && ("-".equals(this.uri) || "file".equals(uRI.getScheme())) && string5 == null && string4.equals(string)) {
                string6 = string2;
            }
            if (this.runtime.transparentJSON() && HttpUtils.jsonContentType(this.contentType)) {
                if (string6 == null) {
                    string6 = "UTF-8";
                }
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string6);
                JSONTokener jSONTokener = new JSONTokener(inputStreamReader);
                XdmNode xdmNode = JSONtoXML.convert(this.runtime.getProcessor(), jSONTokener, this.runtime.jsonFlavor());
                treeWriter.addSubtree(xdmNode);
            } else {
                treeWriter.addStartElement(this.wrapper);
                if (XProcConstants.c_data.equals((Object)this.wrapper)) {
                    if ("content/unknown".equals(string3)) {
                        treeWriter.addAttribute(_contentType, "application/octet-stream");
                    } else {
                        treeWriter.addAttribute(_contentType, string3);
                    }
                    if (!this.isText(string3, string6)) {
                        treeWriter.addAttribute(_encoding, "base64");
                    }
                } else {
                    if ("content/unknown".equals(string3)) {
                        treeWriter.addAttribute(c_contentType, "application/octet-stream");
                    } else {
                        treeWriter.addAttribute(c_contentType, string3);
                    }
                    if (!this.isText(string3, string6)) {
                        treeWriter.addAttribute(c_encoding, "base64");
                    }
                }
                treeWriter.startContent();
                if (this.isText(string3, string6)) {
                    if (string6 == null) {
                        string6 = "UTF-8";
                    }
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string6));
                    int n = 12288;
                    char[] cArray = new char[n];
                    int n2 = bufferedReader.read(cArray, 0, n);
                    while (n2 >= 0) {
                        if (n2 > 0) {
                            String string7 = new String(cArray, 0, n2);
                            treeWriter.addText(string7);
                        }
                        n2 = bufferedReader.read(cArray, 0, n);
                    }
                    bufferedReader.close();
                } else {
                    int n = 12288;
                    byte[] byArray = new byte[n];
                    int n3 = 0;
                    int n4 = n;
                    boolean bl = false;
                    while (!bl) {
                        int n5 = inputStream.read(byArray, n3, n4);
                        if (n5 >= 0) {
                            n3 += n5;
                            n4 -= n5;
                        } else {
                            bl = true;
                        }
                        if (n4 != 0 && !bl) continue;
                        String string8 = Base64.encodeBytes(byArray, 0, n3);
                        treeWriter.addText(string8 + "\n");
                        n3 = 0;
                        n4 = n;
                    }
                    inputStream.close();
                }
                treeWriter.addEndElement();
            }
        }
        catch (IOException iOException) {
            throw new XProcException(XProcConstants.dynamicError(29), (Throwable)iOException);
        }
        treeWriter.endDocument();
        this.documents.add(treeWriter.getResult());
        return this.documents;
    }

    @Override
    public void canReadSequence(boolean bl) {
    }

    @Override
    public boolean readSequence() {
        return false;
    }

    @Override
    public void resetReader() {
        this.pos = 0;
    }

    @Override
    public void setReader(Step step) {
        this.reader = step;
    }

    @Override
    public boolean moreDocuments() {
        DocumentSequence documentSequence = this.ensureDocuments();
        return this.pos < documentSequence.size();
    }

    @Override
    public boolean closed() {
        return true;
    }

    @Override
    public int documentCount() {
        DocumentSequence documentSequence = this.ensureDocuments();
        return documentSequence.size();
    }

    @Override
    public DocumentSequence documents() {
        return this.ensureDocuments();
    }

    @Override
    public XdmNode read() throws SaxonApiException {
        DocumentSequence documentSequence = this.ensureDocuments();
        XdmNode xdmNode = documentSequence.get(this.pos++);
        if (this.reader != null) {
            this.runtime.finest(null, this.reader.getNode(), this.reader.getName() + " read '" + (xdmNode == null ? "null" : xdmNode.getBaseURI()) + "' from " + this);
        }
        return xdmNode;
    }

    protected URI getDataUri(String string) {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new XProcException(uRISyntaxException);
        }
    }

    protected InputStream getStream(URI uRI) {
        try {
            URL uRL = uRI.toURL();
            URLConnection uRLConnection = uRL.openConnection();
            this.serverContentType = uRLConnection.getContentType();
            this.serverContentType = this.serverContentType == null ? "content/unknown" : this.serverContentType;
            return uRLConnection.getInputStream();
        }
        catch (IOException iOException) {
            throw new XProcException(XProcConstants.dynamicError(29), (Throwable)iOException);
        }
    }

    protected String getContentType() {
        return this.serverContentType;
    }

    private boolean isText(String string, String string2) {
        return "application/xml".equals(string) || string.endsWith("+xml") || string.startsWith("text/") || "utf-8".equals(string2);
    }

    private String parseContentType(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(";");
        if (n > 0) {
            String string2 = string.substring(0, n).trim();
            return string2;
        }
        return string;
    }

    private String parseCharset(String string) {
        String string2 = HttpUtils.getCharset(string);
        if (string2 != null) {
            return string2.toLowerCase();
        }
        return null;
    }
}

