/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.io;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.DocumentSequence;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.util.JSONtoXML;
import com.xmlcalabash.util.XPointer;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.json.JSONTokener;

public class ReadableDocument
implements ReadablePipe {
    protected DocumentSequence documents = null;
    protected String uri = null;
    protected XProcRuntime runtime = null;
    private int pos = 0;
    private String base = null;
    private XdmNode node = null;
    private boolean readDoc = false;
    private Step reader = null;
    private Pattern pattern = null;

    public ReadableDocument(XProcRuntime xProcRuntime) {
        this.runtime = xProcRuntime;
        this.documents = new DocumentSequence(xProcRuntime);
    }

    public ReadableDocument(XProcRuntime xProcRuntime, XdmNode xdmNode, String string, String string2, String string3) {
        this.runtime = xProcRuntime;
        this.node = xdmNode;
        this.uri = string;
        this.base = string2;
        if (string3 != null) {
            this.pattern = Pattern.compile(string3);
        }
        this.documents = new DocumentSequence(xProcRuntime);
    }

    @Override
    public void canReadSequence(boolean bl) {
    }

    @Override
    public boolean readSequence() {
        return false;
    }

    @Override
    public void resetReader() {
        this.pos = 0;
    }

    @Override
    public void setReader(Step step) {
        this.reader = step;
    }

    @Override
    public boolean moreDocuments() {
        if (!this.readDoc) {
            this.readDoc();
        }
        return this.pos < this.documents.size();
    }

    @Override
    public boolean closed() {
        return true;
    }

    @Override
    public int documentCount() {
        return this.documents.size();
    }

    @Override
    public DocumentSequence documents() {
        return this.documents;
    }

    @Override
    public XdmNode read() throws SaxonApiException {
        if (!this.readDoc) {
            this.readDoc();
        }
        XdmNode xdmNode = this.documents.get(this.pos++);
        if (this.reader != null) {
            this.runtime.finest(null, this.reader.getNode(), this.reader.getName() + " select read '" + (xdmNode == null ? "null" : xdmNode.getBaseURI()) + "' from " + this);
        }
        return xdmNode;
    }

    protected void readDoc() {
        block17: {
            this.readDoc = true;
            if (this.uri != null) {
                try {
                    File file;
                    String string = this.uri;
                    if (string.startsWith("file:") && (string = string.substring(5)).startsWith("///")) {
                        string = string.substring(2);
                    }
                    if ((file = new File(string)).isDirectory()) {
                        if (this.pattern == null) {
                            this.pattern = Pattern.compile("^.*\\.xml$");
                        }
                        for (File file2 : file.listFiles(new RegexFileFilter(this.pattern))) {
                            XdmNode xdmNode = this.runtime.parse(file2.getCanonicalPath(), this.base);
                            this.documents.add(xdmNode);
                        }
                        break block17;
                    }
                    XdmNode xdmNode = null;
                    try {
                        xdmNode = this.runtime.parse(this.uri, this.base);
                    }
                    catch (XProcException xProcException) {
                        if (this.runtime.transparentJSON()) {
                            try {
                                URI uRI = new URI(this.base);
                                URL uRL = uRI.resolve(this.uri).toURL();
                                URLConnection uRLConnection = uRL.openConnection();
                                InputStreamReader inputStreamReader = new InputStreamReader(uRLConnection.getInputStream());
                                JSONTokener jSONTokener = new JSONTokener(inputStreamReader);
                                xdmNode = JSONtoXML.convert(this.runtime.getProcessor(), jSONTokener, this.runtime.jsonFlavor());
                                this.documents.add(xdmNode);
                                return;
                            }
                            catch (Exception exception) {
                                throw xProcException;
                            }
                        }
                        throw xProcException;
                    }
                    if (string.contains("#")) {
                        XPointer xPointer;
                        Vector<XdmNode> vector;
                        int n = string.indexOf("#");
                        String string2 = string.substring(n + 1);
                        if (string2.matches("^[\\w]+$")) {
                            string2 = "element(" + string2 + ")";
                        }
                        if ((vector = (xPointer = new XPointer(string2)).selectNodes(this.runtime, xdmNode)).size() == 1) {
                            xdmNode = vector.get(0);
                        } else if (vector.size() != 0) {
                            throw new XProcException(this.node, "XPointer matches more than one node!?");
                        }
                    }
                    this.documents.add(xdmNode);
                }
                catch (Exception exception) {
                    throw XProcException.dynamicError(11, this.node, exception, "Could not read: " + this.uri);
                }
            }
        }
    }

    private class RegexFileFilter
    implements FileFilter {
        Pattern pattern = null;

        public RegexFileFilter(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean accept(File file) {
            Matcher matcher = this.pattern.matcher(file.getName());
            return matcher.matches();
        }
    }
}

