/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.io;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.DocumentSequence;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.util.S9apiUtils;
import java.net.URI;
import java.util.HashSet;
import java.util.Vector;
import java.util.logging.Logger;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmValue;

public class ReadableInline
implements ReadablePipe {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private XProcRuntime runtime = null;
    private DocumentSequence documents = null;
    private boolean readSeqOk = false;
    private int pos = 0;
    private Step reader = null;

    public ReadableInline(XProcRuntime xProcRuntime, Vector<XdmValue> vector, HashSet<String> hashSet) {
        this.runtime = xProcRuntime;
        this.documents = new DocumentSequence(xProcRuntime);
        XdmDestination xdmDestination = new XdmDestination();
        XdmNode xdmNode = null;
        if (vector.size() > 0) {
            xdmNode = ((XdmNode)vector.get(this.pos)).getParent();
        }
        XdmNode xdmNode2 = null;
        for (int i = 0; i < vector.size() && xdmNode2 == null; ++i) {
            if (((XdmNode)vector.get(i)).getNodeKind() != XdmNodeKind.ELEMENT) continue;
            xdmNode2 = (XdmNode)vector.get(i);
        }
        if (xdmNode2 == null) {
            throw XProcException.dynamicError(1, xdmNode, "Invalid inline content");
        }
        URI uRI = null;
        uRI = xdmNode2.getAttributeValue(XProcConstants.xml_base) == null ? xdmNode2.getBaseURI() : xdmNode2.getParent().getBaseURI();
        try {
            S9apiUtils.writeXdmValue(xProcRuntime, vector, (Destination)xdmDestination, uRI);
            XdmNode xdmNode3 = xdmDestination.getXdmNode();
            xdmNode3 = S9apiUtils.removeNamespaces(xProcRuntime, xdmNode3, hashSet, true);
            xProcRuntime.finest(null, null, "Instantiate a ReadableInline");
            this.documents.add(xdmNode3);
        }
        catch (SaxonApiException saxonApiException) {
            throw new XProcException(saxonApiException);
        }
    }

    @Override
    public void canReadSequence(boolean bl) {
        this.readSeqOk = bl;
    }

    @Override
    public boolean readSequence() {
        return this.readSeqOk;
    }

    @Override
    public void resetReader() {
        this.pos = 0;
    }

    @Override
    public boolean moreDocuments() {
        return this.pos < this.documents.size();
    }

    @Override
    public boolean closed() {
        return true;
    }

    @Override
    public int documentCount() {
        return this.documents.size();
    }

    @Override
    public DocumentSequence documents() {
        return this.documents;
    }

    @Override
    public void setReader(Step step) {
        this.reader = step;
    }

    @Override
    public XdmNode read() throws SaxonApiException {
        XdmNode xdmNode = this.documents.get(this.pos++);
        if (this.reader != null) {
            this.runtime.finest(null, this.reader.getNode(), this.reader.getName() + " read '" + (xdmNode == null ? "null" : xdmNode.getBaseURI()) + "' from " + this);
        }
        return xdmNode;
    }

    public String toString() {
        return "readableinline " + this.documents;
    }
}

