/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.io;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.DocumentSequence;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.model.NamespaceBinding;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.util.S9apiUtils;
import java.util.logging.Logger;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;

public class Select
implements ReadablePipe {
    private ReadablePipe source = null;
    private String select = null;
    private XdmNode context = null;
    private DocumentSequence documents = null;
    private XPathSelector selector = null;
    private XProcRuntime runtime = null;
    private boolean initialized = false;
    private int docindex = 0;
    private Step reader = null;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public Select(XProcRuntime xProcRuntime, ReadablePipe readablePipe, String string, XdmNode xdmNode) {
        this.source = readablePipe;
        this.select = string;
        this.context = xdmNode;
        this.runtime = xProcRuntime;
        this.documents = new DocumentSequence(xProcRuntime);
    }

    @Override
    public void canReadSequence(boolean bl) {
    }

    @Override
    public boolean readSequence() {
        return true;
    }

    private void readSource() {
        NamespaceBinding namespaceBinding;
        this.initialized = true;
        try {
            namespaceBinding = new NamespaceBinding(this.runtime, this.context);
            XPathCompiler xPathCompiler = this.runtime.getProcessor().newXPathCompiler();
            xPathCompiler.setBaseURI(this.context.getBaseURI());
            for (String string : namespaceBinding.getNamespaceBindings().keySet()) {
                xPathCompiler.declareNamespace(string, namespaceBinding.getNamespaceBindings().get(string));
            }
            XPathExecutable xPathExecutable = xPathCompiler.compile(this.select);
            this.selector = xPathExecutable.load();
        }
        catch (SaxonApiException saxonApiException) {
            throw new XProcException(saxonApiException);
        }
        while (this.source.moreDocuments()) {
            try {
                namespaceBinding = this.source.read();
                if (this.reader != null) {
                    this.runtime.finest(null, this.reader.getNode(), this.reader.getName() + " select read '" + (namespaceBinding == null ? "null" : namespaceBinding.getBaseURI()) + "' from " + this.source);
                }
                this.selector.setContextItem((XdmItem)namespaceBinding);
                for (XPathExecutable xPathExecutable : this.selector) {
                    String string;
                    string = null;
                    try {
                        string = (XdmNode)xPathExecutable;
                    }
                    catch (ClassCastException classCastException) {
                        throw new XProcException(this.context, "Select matched non-node!?");
                    }
                    XdmDestination xdmDestination = new XdmDestination();
                    S9apiUtils.writeXdmValue(this.runtime, (XdmItem)string, (Destination)xdmDestination, string.getBaseURI());
                    XdmNode xdmNode = xdmDestination.getXdmNode();
                    if (this.reader != null) {
                        this.runtime.finest(null, this.reader.getNode(), this.reader.getName() + " select wrote '" + (xdmNode == null ? "null" : xdmNode.getBaseURI()) + "' to " + this.documents);
                    }
                    this.documents.add(xdmNode);
                }
            }
            catch (SaxonApiException saxonApiException) {
                throw new XProcException(saxonApiException);
            }
        }
    }

    @Override
    public void resetReader() {
        this.docindex = 0;
    }

    @Override
    public boolean moreDocuments() {
        if (!this.initialized) {
            this.readSource();
        }
        return this.docindex < this.documents.size();
    }

    @Override
    public boolean closed() {
        return true;
    }

    @Override
    public int documentCount() {
        if (!this.initialized) {
            this.readSource();
        }
        return this.documents.size();
    }

    @Override
    public DocumentSequence documents() {
        return this.documents;
    }

    @Override
    public void setReader(Step step) {
        this.reader = step;
    }

    @Override
    public XdmNode read() throws SaxonApiException {
        if (!this.initialized) {
            this.readSource();
        }
        XdmNode xdmNode = null;
        if (this.moreDocuments()) {
            xdmNode = this.documents.get(this.docindex++);
        }
        if (this.reader != null) {
            this.runtime.finest(null, this.reader.getNode(), this.reader.getName() + " read '" + (xdmNode == null ? "null" : xdmNode.getBaseURI()) + "' from " + this);
        }
        return xdmNode;
    }
}

