/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.HttpUtils;
import com.xmlcalabash.util.JSONtoXML;
import com.xmlcalabash.util.MIMEReader;
import com.xmlcalabash.util.RelevantNodes;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.XMLtoJSON;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Vector;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.json.JSONTokener;
import org.xml.sax.InputSource;

public class HttpRequest
extends DefaultStep {
    private static final QName c_request = new QName("c", "http://www.w3.org/ns/xproc-step", "request");
    private static final QName cx_timeout = new QName("cx", "http://xmlcalabash.com/ns/extensions", "timeout");
    private static final QName cx_cookies = new QName("cx", "http://xmlcalabash.com/ns/extensions", "cookies");
    private static final QName cx_save_cookies = new QName("cx", "http://xmlcalabash.com/ns/extensions", "save-cookies");
    private static final QName cx_use_cookies = new QName("cx", "http://xmlcalabash.com/ns/extensions", "use-cookies");
    private static final QName cx_send_binary = new QName("cx", "http://xmlcalabash.com/ns/extensions", "send-binary");
    public static final QName _href = new QName("", "href");
    public static final QName _detailed = new QName("", "detailed");
    public static final QName _status_only = new QName("", "status-only");
    public static final QName _username = new QName("", "username");
    public static final QName _password = new QName("", "password");
    public static final QName _auth_method = new QName("", "auth-method");
    public static final QName _send_authorization = new QName("", "send-authorization");
    public static final QName _override_content_type = new QName("", "override-content-type");
    public static final QName _content_type = new QName("", "content-type");
    public static final QName _name = new QName("", "name");
    public static final QName _value = new QName("", "value");
    public static final QName _id = new QName("", "id");
    public static final QName _description = new QName("", "description");
    public static final QName _disposition = new QName("", "disposition");
    public static final QName _status = new QName("", "status");
    public static final QName _boundary = new QName("", "boundary");
    public static final QName _charset = new QName("", "charset");
    private static final int bufSize = 7296;
    private boolean statusOnly = false;
    private boolean detailed = false;
    private String method = null;
    private URI requestURI = null;
    private Vector<Header> headers = new Vector();
    private String contentType = null;
    private String overrideContentType = null;
    private String headerContentType = null;
    private boolean encodeBinary = false;
    private ReadablePipe source = null;
    private WritablePipe result = null;

    public HttpRequest(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        this.source = readablePipe;
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        HttpClient httpClient;
        Object object;
        block50: {
            BasicCredentialsProvider basicCredentialsProvider;
            UsernamePasswordCredentials usernamePasswordCredentials;
            HttpResponse httpResponse;
            String string;
            Object object2;
            Object object32;
            Object object4;
            QName qName;
            Object object5;
            super.run();
            XdmNode xdmNode = this.source.read();
            XdmNode xdmNode2 = S9apiUtils.getDocumentElement(xdmNode);
            if (!c_request.equals((Object)xdmNode2.getNodeName())) {
                throw XProcException.stepError(40);
            }
            XdmSequenceIterator xdmSequenceIterator = xdmNode2.axisIterator(Axis.ATTRIBUTE);
            boolean bl = true;
            while (xdmSequenceIterator.hasNext()) {
                object5 = (XdmNode)xdmSequenceIterator.next();
                qName = object5.getNodeName();
                if (_method.equals((Object)qName) || _href.equals((Object)qName) || _detailed.equals((Object)qName) || _status_only.equals((Object)qName) || _username.equals((Object)qName) || _password.equals((Object)qName) || _auth_method.equals((Object)qName) || _send_authorization.equals((Object)qName) || _override_content_type.equals((Object)qName) || !"".equals(qName.getNamespaceURI())) continue;
                throw new XProcException(this.step.getNode(), "Unsupported attribute on c:request for p:http-request: " + qName);
            }
            object5 = this.step.getExtensionAttribute(cx_send_binary);
            this.encodeBinary = !"true".equals(object5);
            this.method = xdmNode2.getAttributeValue(_method);
            this.statusOnly = "true".equals(xdmNode2.getAttributeValue(_status_only));
            this.detailed = "true".equals(xdmNode2.getAttributeValue(_detailed));
            this.overrideContentType = xdmNode2.getAttributeValue(_override_content_type);
            if (this.method == null) {
                throw XProcException.stepError(6);
            }
            if (this.statusOnly && !this.detailed) {
                throw XProcException.stepError(4);
            }
            if (xdmNode2.getAttributeValue(_href) == null) {
                throw new XProcException(this.step.getNode(), "The 'href' attribute must be specified on c:request for p:http-request");
            }
            this.requestURI = xdmNode2.getBaseURI().resolve(xdmNode2.getAttributeValue(_href));
            if ("file".equals(this.requestURI.getScheme())) {
                this.doFile();
                return;
            }
            qName = new BasicHttpParams();
            BasicHttpContext basicHttpContext = new BasicHttpContext();
            qName.setBooleanParameter("http.protocol.handle-redirects", true);
            String string2 = this.step.getExtensionAttribute(cx_save_cookies);
            String string3 = this.step.getExtensionAttribute(cx_use_cookies);
            String string4 = this.step.getExtensionAttribute(cx_cookies);
            if (string2 == null) {
                string2 = string4;
            }
            if (string3 == null) {
                string3 = string4;
            }
            BasicCookieStore basicCookieStore = new BasicCookieStore();
            if (string3 != null && string3.equals(string2)) {
                basicCookieStore = this.runtime.getCookieStore(string3);
            } else if (string3 != null) {
                object4 = this.runtime.getCookieStore(string3);
                for (Object object32 : object4.getCookies()) {
                    basicCookieStore.addCookie(object32);
                }
            }
            basicHttpContext.setAttribute("http.cookie-store", (Object)basicCookieStore);
            qName.setParameter("http.protocol.cookie-policy", (Object)"compatibility");
            object4 = this.step.getExtensionAttribute(cx_timeout);
            if (object4 != null) {
                qName.setIntParameter("http.socket.timeout", Integer.parseInt((String)object4));
            }
            if (xdmNode2.getAttributeValue(_username) != null) {
                object2 = xdmNode2.getAttributeValue(_username);
                object32 = xdmNode2.getAttributeValue(_password);
                string = xdmNode2.getAttributeValue(_auth_method);
                if ("basic".equalsIgnoreCase(string)) {
                    httpResponse = Collections.singletonList("Basic");
                } else if ("digest".equalsIgnoreCase(string)) {
                    httpResponse = Collections.singletonList("Digest");
                } else {
                    throw XProcException.stepError(3, "Unsupported auth-method: " + string);
                }
                object = this.requestURI.getHost();
                int n = this.requestURI.getPort();
                AuthScope authScope = new AuthScope((String)object, n);
                usernamePasswordCredentials = new UsernamePasswordCredentials((String)object2, (String)object32);
                basicCredentialsProvider = new BasicCredentialsProvider();
                basicCredentialsProvider.setCredentials(authScope, (Credentials)usernamePasswordCredentials);
                basicHttpContext.setAttribute("http.auth.credentials-provider", (Object)basicCredentialsProvider);
                qName.setBooleanParameter("http.protocol.handle-authentication", true);
                qName.setParameter("http.auth.target-scheme-pref", (Object)httpResponse);
            }
            xdmSequenceIterator = xdmNode2.axisIterator(Axis.CHILD);
            object2 = null;
            while (xdmSequenceIterator.hasNext()) {
                object32 = (XdmNode)xdmSequenceIterator.next();
                if (object32.getNodeKind() != XdmNodeKind.ELEMENT) continue;
                if (object2 != null) {
                    throw new UnsupportedOperationException("Elements follow c:multipart or c:body");
                }
                if (XProcConstants.c_header.equals((Object)object32.getNodeName())) {
                    string = object32.getAttributeValue(_name);
                    if (string == null) continue;
                    if (string.toLowerCase().equals("content-type")) {
                        this.headerContentType = object32.getAttributeValue(_value).toLowerCase();
                        continue;
                    }
                    this.headers.add((Header)new BasicHeader(object32.getAttributeValue(_name), object32.getAttributeValue(_value)));
                    continue;
                }
                if (XProcConstants.c_multipart.equals((Object)object32.getNodeName()) || XProcConstants.c_body.equals((Object)object32.getNodeName())) {
                    object2 = object32;
                    continue;
                }
                throw new UnsupportedOperationException("Unexpected request element: " + object32.getNodeName());
            }
            object32 = this.method.toLowerCase();
            if (object2 != null && !"put".equals(object32) && !"post".equals(object32)) {
                throw XProcException.stepError(5);
            }
            httpResponse = null;
            if ("get".equals(object32)) {
                string = this.doGet();
            } else if ("post".equals(object32)) {
                string = this.doPost((XdmNode)object2);
            } else if ("put".equals(object32)) {
                string = this.doPut((XdmNode)object2);
            } else if ("head".equals(object32)) {
                string = this.doHead();
            } else if ("delete".equals(object32)) {
                string = this.doDelete();
            } else {
                throw new UnsupportedOperationException("Unrecognized http method: " + this.method);
            }
            object = new TreeWriter(this.runtime);
            try {
                httpClient = this.runtime.getHttpClient();
                if (httpClient == null) {
                    throw new XProcException("HTTP requests have been disabled");
                }
                string.setParams((HttpParams)qName);
                httpResponse = httpClient.execute((HttpUriRequest)string, (HttpContext)basicHttpContext);
                int n = httpResponse.getStatusLine().getStatusCode();
                usernamePasswordCredentials = (HttpHost)basicHttpContext.getAttribute("http.target_host");
                basicCredentialsProvider = (HttpUriRequest)basicHttpContext.getAttribute("http.request");
                URI uRI = new URI(usernamePasswordCredentials.getSchemeName(), null, usernamePasswordCredentials.getHostName(), usernamePasswordCredentials.getPort(), "/", null, null);
                ((TreeWriter)object).startDocument(uRI.resolve(basicCredentialsProvider.getURI()));
                if (string2 != null) {
                    this.runtime.setCookieStore(string2, (CookieStore)basicCookieStore);
                }
                String string5 = this.getContentType(httpResponse);
                if (this.overrideContentType != null) {
                    if (this.xmlContentType(string5) && this.overrideContentType.startsWith("image/") || string5.startsWith("text/") && this.overrideContentType.startsWith("image/") || string5.startsWith("image/") && this.xmlContentType(this.overrideContentType) || string5.startsWith("image/") && this.overrideContentType.startsWith("text/") || string5.startsWith("multipart/") && !this.overrideContentType.startsWith("multipart/") || !string5.startsWith("multipart/") && this.overrideContentType.startsWith("multipart/")) {
                        throw XProcException.stepError(30);
                    }
                    string5 = this.overrideContentType;
                }
                if (this.detailed) {
                    ((TreeWriter)object).addStartElement(XProcConstants.c_response);
                    ((TreeWriter)object).addAttribute(_status, "" + n);
                    ((TreeWriter)object).startContent();
                    Object object6 = httpResponse.getAllHeaders();
                    int n2 = ((Header[])object6).length;
                    for (int i = 0; i < n2; ++i) {
                        Header header = object6[i];
                        String string6 = header.toString();
                        int n3 = string6.indexOf(":");
                        String string7 = header.getName();
                        String string8 = string6.substring(n3 + 1).trim();
                        ((TreeWriter)object).addStartElement(XProcConstants.c_header);
                        ((TreeWriter)object).addAttribute(_name, string7);
                        ((TreeWriter)object).addAttribute(_value, string8);
                        ((TreeWriter)object).startContent();
                        ((TreeWriter)object).addEndElement();
                    }
                    if (!this.statusOnly && httpResponse.getEntity() != null && (object6 = httpResponse.getEntity().getContent()) != null) {
                        this.readBodyContent((TreeWriter)object, (InputStream)object6, httpResponse);
                    }
                    ((TreeWriter)object).addEndElement();
                    break block50;
                }
                if (this.statusOnly) {
                    break block50;
                }
                if (httpResponse.getEntity() != null) {
                    InputStream inputStream = httpResponse.getEntity().getContent();
                    this.readBodyContent((TreeWriter)object, inputStream, httpResponse);
                    break block50;
                }
                throw XProcException.dynamicError(6);
            }
            catch (XProcException xProcException) {
                throw xProcException;
            }
            catch (Exception exception) {
                throw new XProcException(exception);
            }
            finally {
                if (httpResponse != null) {
                    EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
                }
            }
        }
        ((TreeWriter)object).endDocument();
        httpClient = ((TreeWriter)object).getResult();
        this.result.write((XdmNode)httpClient);
    }

    private HttpGet doGet() {
        HttpGet httpGet = new HttpGet(this.requestURI);
        for (Header header : this.headers) {
            httpGet.addHeader(header);
        }
        return httpGet;
    }

    private HttpHead doHead() {
        HttpHead httpHead = new HttpHead(this.requestURI);
        for (Header header : this.headers) {
            httpHead.addHeader(header);
        }
        return httpHead;
    }

    private HttpDelete doDelete() {
        HttpDelete httpDelete = new HttpDelete(this.requestURI);
        for (Header header : this.headers) {
            httpDelete.addHeader(header);
        }
        return httpDelete;
    }

    private HttpPut doPut(XdmNode xdmNode) {
        HttpPut httpPut = new HttpPut(this.requestURI);
        this.doPutOrPost((HttpEntityEnclosingRequest)httpPut, xdmNode);
        return httpPut;
    }

    private HttpPost doPost(XdmNode xdmNode) {
        HttpPost httpPost = new HttpPost(this.requestURI);
        this.doPutOrPost((HttpEntityEnclosingRequest)httpPost, xdmNode);
        return httpPost;
    }

    private void doPutOrPost(HttpEntityEnclosingRequest httpEntityEnclosingRequest, XdmNode xdmNode) {
        if (XProcConstants.c_multipart.equals((Object)xdmNode.getNodeName())) {
            this.doPutOrPostMultipart(httpEntityEnclosingRequest, xdmNode);
        } else {
            this.doPutOrPostSinglepart(httpEntityEnclosingRequest, xdmNode);
        }
    }

    private void doPutOrPostSinglepart(HttpEntityEnclosingRequest httpEntityEnclosingRequest, XdmNode xdmNode) {
        Object object;
        Object object22;
        this.contentType = xdmNode.getAttributeValue(_content_type);
        if (this.contentType == null) {
            throw new XProcException(this.step.getNode(), "Content-type on c:body is required.");
        }
        String string = xdmNode.getAttributeValue(_id);
        String string2 = xdmNode.getAttributeValue(_description);
        String string3 = xdmNode.getAttributeValue(_disposition);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (string2 != null) {
            for (Object object22 : this.headers) {
                if (!object22.getName().toLowerCase().equals("content-description")) continue;
                object = object22.getValue();
                bl = true;
                if (string2.equals(object)) continue;
                throw XProcException.stepError(20);
            }
            if (!bl) {
                this.headers.add((Header)new BasicHeader("Content-Description", string2));
            }
        }
        if (string != null) {
            for (Object object22 : this.headers) {
                if (!object22.getName().toLowerCase().equals("content-id")) continue;
                object = object22.getValue();
                bl2 = true;
                if (string.equals(object)) continue;
                throw XProcException.stepError(20);
            }
            if (!bl2) {
                this.headers.add((Header)new BasicHeader("Content-Id", string));
            }
        }
        if (string3 != null) {
            for (Object object22 : this.headers) {
                if (!object22.getName().toLowerCase().equals("content-disposition")) continue;
                object = object22.getValue();
                bl3 = true;
                if (string3.equals(object)) continue;
                throw XProcException.stepError(20);
            }
            if (!bl3) {
                this.headers.add((Header)new BasicHeader("Content-Disposition", string3));
            }
        }
        if (this.headerContentType != null && !this.headerContentType.equals(this.contentType.toLowerCase())) {
            throw XProcException.stepError(20);
        }
        for (Object object22 : this.headers) {
            httpEntityEnclosingRequest.addHeader(object22);
        }
        Object object3 = null;
        object22 = xdmNode.getAttributeValue(_encoding);
        if (object22 != null && !"base64".equals(object22)) {
            throw XProcException.stepError(52);
        }
        try {
            if ("base64".equals(object22)) {
                Object object4;
                object = xdmNode.getAttributeValue(_charset);
                if (object == null) {
                    object = "utf-8";
                }
                XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.CHILD);
                while (xdmSequenceIterator.hasNext()) {
                    object4 = (XdmNode)xdmSequenceIterator.next();
                    if (object4.getNodeKind() == XdmNodeKind.TEXT) continue;
                    throw XProcException.stepError(28);
                }
                object4 = this.decodeBase64(xdmNode, (String)object);
                StringWriter stringWriter = new StringWriter();
                stringWriter.write((String)object4);
                stringWriter.close();
                object3 = stringWriter.toString();
            } else if (this.jsonContentType(this.contentType)) {
                object3 = XMLtoJSON.convert(xdmNode);
            } else if (this.xmlContentType(this.contentType)) {
                Object object5;
                object = this.makeSerializer();
                try {
                    S9apiUtils.assertDocumentContent(xdmNode.axisIterator(Axis.CHILD));
                }
                catch (XProcException xProcException) {
                    throw XProcException.stepError(22);
                }
                Vector<XdmNode> vector = new Vector<XdmNode>();
                XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.CHILD);
                while (xdmSequenceIterator.hasNext()) {
                    object5 = (XdmNode)xdmSequenceIterator.next();
                    vector.add((XdmNode)object5);
                }
                object5 = new StringWriter();
                object.setOutputWriter((Writer)object5);
                S9apiUtils.serialize(this.runtime, vector, (Serializer)object);
                ((StringWriter)object5).close();
                object3 = ((StringWriter)object5).toString();
            } else {
                object = new StringWriter();
                XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.CHILD);
                while (xdmSequenceIterator.hasNext()) {
                    XdmNode xdmNode2 = (XdmNode)xdmSequenceIterator.next();
                    if (xdmNode2.getNodeKind() != XdmNodeKind.TEXT) {
                        throw XProcException.stepError(28);
                    }
                    ((StringWriter)object).write(xdmNode2.getStringValue());
                }
                ((StringWriter)object).close();
                object3 = ((StringWriter)object).toString();
            }
            object = new StringEntity((String)object3, ContentType.create((String)this.contentType, (String)"UTF-8"));
            httpEntityEnclosingRequest.setEntity((HttpEntity)object);
        }
        catch (IOException iOException) {
            throw new XProcException(iOException);
        }
        catch (SaxonApiException saxonApiException) {
            throw new XProcException(saxonApiException);
        }
    }

    private void doPutOrPostMultipart(HttpEntityEnclosingRequest httpEntityEnclosingRequest, XdmNode xdmNode) {
        Object object2;
        this.contentType = xdmNode.getAttributeValue(_content_type);
        if (this.contentType == null) {
            this.contentType = "multipart/mixed";
        }
        if (this.headerContentType != null && !this.headerContentType.equals(this.contentType.toLowerCase())) {
            throw XProcException.stepError(20);
        }
        if (!this.contentType.startsWith("multipart/")) {
            throw new UnsupportedOperationException("Multipart content-type must be multipart/...");
        }
        for (Object object2 : this.headers) {
            httpEntityEnclosingRequest.addHeader(object2);
        }
        String string = xdmNode.getAttributeValue(_boundary);
        if (string == null) {
            throw new XProcException(this.step.getNode(), "A boundary value must be specified on c:multipart");
        }
        if (string.startsWith("--")) {
            throw XProcException.stepError(2);
        }
        object2 = "\"";
        if (string.contains((CharSequence)object2)) {
            object2 = "'";
        }
        if (string.contains((CharSequence)object2)) {
            object2 = "";
        }
        String string2 = this.contentType + "; boundary=" + (String)object2 + (String)string + (String)object2;
        MessageBytes messageBytes = new MessageBytes();
        messageBytes.append("This is a multipart message.\r\n");
        for (XdmNode xdmNode2 : new RelevantNodes(this.runtime, xdmNode, Axis.CHILD)) {
            String string3;
            if (!XProcConstants.c_body.equals((Object)xdmNode2.getNodeName())) {
                throw new XProcException(this.step.getNode(), "A c:multipart may only contain c:body elements.");
            }
            String string4 = xdmNode2.getAttributeValue(_content_type);
            if (string4 == null) {
                throw new XProcException(this.step.getNode(), "Content-type on c:body is required.");
            }
            String string5 = xdmNode2.getAttributeValue(_id);
            String string6 = xdmNode2.getAttributeValue(_description);
            String string7 = xdmNode2.getAttributeValue(_disposition);
            String string8 = HttpUtils.getCharset(string4);
            if (string4.contains(";")) {
                int n = string4.indexOf(";");
                string4 = string4.substring(0, n);
            }
            if ((string3 = xdmNode2.getAttributeValue(_encoding)) != null && !"base64".equals(string3)) {
                throw new UnsupportedOperationException("The '" + string3 + "' encoding is not supported");
            }
            string4 = string8 != null ? string4 + "; charset=" + string8 : string4 + "; charset=utf-8";
            messageBytes.append("--" + (String)string + "\r\n");
            messageBytes.append("Content-Type: " + string4 + "\r\n");
            if (string6 != null) {
                messageBytes.append("Content-Description: " + string6 + "\r\n");
            }
            if (string5 != null) {
                messageBytes.append("Content-ID: " + string5 + "\r\n");
            }
            if (string7 != null) {
                messageBytes.append("Content-Disposition: " + string7 + "\r\n");
            }
            if (string3 != null && this.encodeBinary) {
                messageBytes.append("Content-Transfer-Encoding: " + string3 + "\r\n");
            }
            messageBytes.append("\r\n");
            try {
                XdmSequenceIterator xdmSequenceIterator;
                XdmSequenceIterator xdmSequenceIterator2;
                Object object3;
                if (this.xmlContentType(string4)) {
                    Object object4;
                    object3 = this.makeSerializer();
                    xdmSequenceIterator2 = new Vector();
                    xdmSequenceIterator = xdmNode2.axisIterator(Axis.CHILD);
                    while (xdmSequenceIterator.hasNext()) {
                        object4 = (XdmNode)xdmSequenceIterator.next();
                        xdmSequenceIterator2.add(object4);
                    }
                    object4 = new StringWriter();
                    object3.setOutputWriter((Writer)object4);
                    S9apiUtils.serialize(this.runtime, (Vector<XdmNode>)xdmSequenceIterator2, (Serializer)object3);
                    ((StringWriter)object4).close();
                    messageBytes.append(((StringWriter)object4).toString());
                } else if (this.jsonContentType(this.contentType)) {
                    messageBytes.append(XMLtoJSON.convert(xdmNode2));
                } else if (!this.encodeBinary && "base64".equals(string3)) {
                    object3 = Base64.decode(xdmNode2.getStringValue());
                    messageBytes.append((byte[])object3, ((Serializer)object3).length);
                } else {
                    object3 = new StringWriter();
                    xdmSequenceIterator2 = xdmNode2.axisIterator(Axis.CHILD);
                    while (xdmSequenceIterator2.hasNext()) {
                        xdmSequenceIterator = (XdmNode)xdmSequenceIterator2.next();
                        if (xdmSequenceIterator.getNodeKind() != XdmNodeKind.TEXT) {
                            throw XProcException.stepError(28);
                        }
                        ((StringWriter)object3).write(xdmSequenceIterator.getStringValue());
                    }
                    ((StringWriter)object3).close();
                    messageBytes.append(((StringWriter)object3).toString());
                }
                messageBytes.append("\r\n");
            }
            catch (IOException iOException) {
                throw new XProcException(iOException);
            }
            catch (SaxonApiException saxonApiException) {
                throw new XProcException(saxonApiException);
            }
        }
        messageBytes.append("--" + (String)string + "--\r\n");
        ByteArrayEntity byteArrayEntity = new ByteArrayEntity(messageBytes.content(), ContentType.create((String)string2));
        httpEntityEnclosingRequest.setEntity((HttpEntity)byteArrayEntity);
    }

    private String getFullContentType(HttpResponse httpResponse) {
        Header header = httpResponse.getLastHeader("Content-Type");
        return this.getFullContentType(header);
    }

    private String getFullContentType(Header header) {
        if (header == null) {
            return "application/octet-stream";
        }
        HeaderElement[] headerElementArray = header.getElements();
        if (headerElementArray == null || headerElementArray.length == 0) {
            return null;
        }
        String string = headerElementArray[0].getName();
        NameValuePair[] nameValuePairArray = headerElementArray[0].getParameters();
        if (nameValuePairArray != null) {
            for (NameValuePair nameValuePair : nameValuePairArray) {
                string = string + "; " + nameValuePair.getName() + "=\"" + nameValuePair.getValue() + "\"";
            }
        }
        return string;
    }

    private String getHeaderValue(Header header) {
        if (header == null) {
            return null;
        }
        HeaderElement[] headerElementArray = header.getElements();
        if (headerElementArray == null || headerElementArray.length == 0) {
            return null;
        }
        return headerElementArray[0].getName();
    }

    private String getContentType(HttpResponse httpResponse) {
        Header header = httpResponse.getLastHeader("Content-Type");
        String string = this.getContentType(header);
        if (string == null) {
            return "application/octet-stream";
        }
        return string;
    }

    private String getContentType(Header header) {
        return this.getHeaderValue(header);
    }

    private String getContentBoundary(HttpResponse httpResponse) {
        Header header = httpResponse.getLastHeader("Content-Type");
        return this.getContentBoundary(header);
    }

    private String getContentBoundary(Header header) {
        if (header == null) {
            return null;
        }
        HeaderElement[] headerElementArray = header.getElements();
        if (headerElementArray == null || headerElementArray.length == 0) {
            return null;
        }
        NameValuePair nameValuePair = headerElementArray[0].getParameterByName("boundary");
        return nameValuePair == null ? null : nameValuePair.getValue();
    }

    private String getContentCharset(Header header) {
        if (header == null) {
            return null;
        }
        HeaderElement[] headerElementArray = header.getElements();
        if (headerElementArray == null || headerElementArray.length == 0) {
            return null;
        }
        NameValuePair nameValuePair = headerElementArray[0].getParameterByName("charset");
        if (nameValuePair == null) {
            return "US-ASCII";
        }
        return nameValuePair.getValue();
    }

    private boolean xmlContentType(String string) {
        return HttpUtils.xmlContentType(string);
    }

    private boolean jsonContentType(String string) {
        return this.runtime.transparentJSON() && HttpUtils.jsonContentType(string);
    }

    private boolean textContentType(String string) {
        return HttpUtils.textContentType(string);
    }

    private void readBodyContent(TreeWriter treeWriter, InputStream inputStream, HttpResponse httpResponse) throws SaxonApiException, IOException {
        String string = this.getFullContentType(httpResponse);
        Charset charset = ContentType.getOrDefault((HttpEntity)httpResponse.getEntity()).getCharset();
        String string2 = charset == null ? Consts.ISO_8859_1.name() : charset.name();
        String string3 = this.getContentBoundary(httpResponse);
        if (this.overrideContentType != null) {
            string = this.overrideContentType;
        }
        if (string.startsWith("multipart/")) {
            treeWriter.addStartElement(XProcConstants.c_multipart);
            treeWriter.addAttribute(_content_type, string);
            treeWriter.addAttribute(_boundary, string3);
            treeWriter.startContent();
            this.readMultipartContent(treeWriter, inputStream, string3);
            treeWriter.addEndElement();
        } else if (!this.detailed && (this.xmlContentType(string) || this.jsonContentType(string))) {
            this.readBodyContentPart(treeWriter, inputStream, string, string2);
        } else {
            treeWriter.addStartElement(XProcConstants.c_body);
            treeWriter.addAttribute(_content_type, string);
            if (!(this.xmlContentType(string) || this.textContentType(string) || this.jsonContentType(string))) {
                treeWriter.addAttribute(_encoding, "base64");
            }
            treeWriter.startContent();
            this.readBodyContentPart(treeWriter, inputStream, string, string2);
            treeWriter.addEndElement();
        }
    }

    private void readMultipartContent(TreeWriter treeWriter, InputStream inputStream, String string) throws IOException, SaxonApiException {
        MIMEReader mIMEReader = new MIMEReader(inputStream, string);
        boolean bl = false;
        while (mIMEReader.readHeaders()) {
            int n;
            Object object;
            Header header = mIMEReader.getHeader("Content-Type");
            Header header2 = mIMEReader.getHeader("Content-Length");
            this.contentType = this.getHeaderValue(header);
            String string2 = this.getContentCharset(header);
            String string3 = this.getHeaderValue(header);
            InputStream inputStream2 = null;
            if (header2 != null) {
                int n2 = Integer.parseInt(this.getHeaderValue(header2));
                inputStream2 = mIMEReader.readBodyPart(n2);
            } else {
                inputStream2 = mIMEReader.readBodyPart();
            }
            treeWriter.addStartElement(XProcConstants.c_body);
            treeWriter.addAttribute(_content_type, this.contentType);
            if (!this.xmlContentType(this.contentType) && !this.textContentType(this.contentType)) {
                treeWriter.addAttribute(_encoding, "base64");
            }
            treeWriter.startContent();
            if (this.xmlContentType(string3)) {
                object = new BufferedReader(new InputStreamReader(inputStream2, string2));
                treeWriter.addSubtree(this.runtime.parse(new InputSource((Reader)object)));
            } else if (this.textContentType(string3)) {
                object = new BufferedReader(new InputStreamReader(inputStream2, string2));
                char[] cArray = new char[7296];
                n = ((BufferedReader)object).read(cArray, 0, 7296);
                while (n >= 0) {
                    char[] cArray2 = new char[7296];
                    int n3 = 0;
                    for (int i = 0; i < n; ++i) {
                        if (cArray[i] == '\r') {
                            if (i + 1 == n || cArray[i + 1] == '\n') continue;
                            int n4 = n3;
                            n3 = (char)(n3 + 1);
                            cArray2[n4] = 10;
                            continue;
                        }
                        int n5 = n3;
                        n3 = (char)(n3 + 1);
                        cArray2[n5] = cArray[i];
                    }
                    treeWriter.addText(new String(cArray2, 0, n3));
                    n = ((BufferedReader)object).read(cArray, 0, 7296);
                }
            } else {
                object = new byte[7296];
                int n6 = 0;
                n = 7296;
                int n7 = inputStream2.read((byte[])object, 0, 7296);
                while (n7 >= 0) {
                    n6 += n7;
                    if ((n -= n7) == 0) {
                        treeWriter.addText(Base64.encodeBytes((byte[])object));
                        n6 = 0;
                        n = 7296;
                    }
                    n7 = inputStream2.read((byte[])object, n6, n);
                }
                if (n6 > 0) {
                    byte[] byArray = new byte[n6];
                    System.arraycopy(object, 0, byArray, 0, n6);
                    treeWriter.addText(Base64.encodeBytes(byArray));
                }
                treeWriter.addText("\n");
            }
            treeWriter.addEndElement();
        }
    }

    public void readBodyContentPart(TreeWriter treeWriter, InputStream inputStream, String string, String string2) throws SaxonApiException, IOException {
        if (this.xmlContentType(string)) {
            treeWriter.addSubtree(this.runtime.parse(new InputSource(inputStream)));
        } else if (this.textContentType(string)) {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string2);
            char[] cArray = new char[7296];
            int n = inputStreamReader.read(cArray, 0, 7296);
            while (n >= 0) {
                String string3 = new String(cArray, 0, n);
                treeWriter.addText(string3);
                n = inputStreamReader.read(cArray, 0, 7296);
            }
        } else if (this.jsonContentType(string)) {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            JSONTokener jSONTokener = new JSONTokener(inputStreamReader);
            XdmNode xdmNode = JSONtoXML.convert(this.runtime.getProcessor(), jSONTokener, this.runtime.jsonFlavor());
            treeWriter.addSubtree(xdmNode);
        } else {
            Object object;
            byte[] byArray = new byte[7296];
            int n = 0;
            int n2 = 7296;
            int n3 = inputStream.read(byArray, 0, 7296);
            while (n3 >= 0) {
                n += n3;
                if ((n2 -= n3) == 0) {
                    object = Base64.encodeBytes(byArray);
                    treeWriter.addText((String)object);
                    n = 0;
                    n2 = 7296;
                }
                n3 = inputStream.read(byArray, n, n2);
            }
            if (n > 0) {
                object = new byte[n];
                System.arraycopy(byArray, 0, object, 0, n);
                treeWriter.addText(Base64.encodeBytes(object));
            }
            treeWriter.addText("\n");
        }
    }

    private String extractText(XdmNode xdmNode) {
        String string = "";
        XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.CHILD);
        while (xdmSequenceIterator.hasNext()) {
            XdmNode xdmNode2 = (XdmNode)xdmSequenceIterator.next();
            if (xdmNode2.getNodeKind() != XdmNodeKind.ELEMENT && xdmNode2.getNodeKind() != XdmNodeKind.TEXT) continue;
            string = string + xdmNode2.getStringValue();
        }
        return string;
    }

    private String decodeBase64(XdmNode xdmNode, String string) {
        String string2 = this.extractText(xdmNode);
        byte[] byArray = Base64.decode(string2);
        try {
            return new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw XProcException.stepError(10, unsupportedEncodingException);
        }
    }

    private void doFile() {
        String string = this.overrideContentType;
        if (string == null) {
            string = "application/octet-stream";
        }
        String string2 = HttpUtils.getCharset(string, "ISO-8859-1");
        TreeWriter treeWriter = new TreeWriter(this.runtime);
        treeWriter.startDocument(this.requestURI);
        try {
            File file = new File(this.requestURI.getPath());
            FileInputStream fileInputStream = null;
            fileInputStream = new FileInputStream(file);
            if (this.xmlContentType(string)) {
                this.readBodyContentPart(treeWriter, fileInputStream, string, string2);
            } else {
                treeWriter.addStartElement(XProcConstants.c_body);
                treeWriter.addAttribute(_content_type, string);
                if (!this.xmlContentType(string) && !this.textContentType(string)) {
                    treeWriter.addAttribute(_encoding, "base64");
                }
                treeWriter.startContent();
                this.readBodyContentPart(treeWriter, fileInputStream, string, string2);
                treeWriter.addEndElement();
            }
            treeWriter.endDocument();
            XdmNode xdmNode = treeWriter.getResult();
            this.result.write(xdmNode);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new XProcException(fileNotFoundException);
        }
        catch (SaxonApiException saxonApiException) {
            throw new XProcException(saxonApiException);
        }
        catch (IOException iOException) {
            throw new XProcException(iOException);
        }
    }

    private class MessageBytes {
        int chunkSize = 8192;
        byte[] byteContent = new byte[this.chunkSize];
        int pos = 0;

        public void append(String string) {
            try {
                byte[] byArray = string.getBytes("US-ASCII");
                this.append(byArray, byArray.length);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new XProcException(unsupportedEncodingException);
            }
        }

        public void append(byte[] byArray, int n) {
            if (this.pos + byArray.length > this.byteContent.length) {
                byte[] byArray2 = new byte[this.byteContent.length + byArray.length + this.chunkSize];
                System.arraycopy(this.byteContent, 0, byArray2, 0, this.byteContent.length);
                this.byteContent = byArray2;
            }
            System.arraycopy(byArray, 0, this.byteContent, this.pos, byArray.length);
            this.pos += byArray.length;
        }

        public byte[] content() {
            byte[] byArray = new byte[this.pos];
            System.arraycopy(this.byteContent, 0, byArray, 0, this.pos);
            return byArray;
        }
    }
}

