/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import java.util.Iterator;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;

public class LabelElements
extends DefaultStep
implements ProcessMatchingNodes {
    private static final QName _attribute = new QName("attribute");
    private static final QName _attribute_prefix = new QName("attribute-prefix");
    private static final QName _attribute_namespace = new QName("attribute-namespace");
    private static final QName _match = new QName("match");
    private static final QName _label = new QName("label");
    private static final QName _replace = new QName("replace");
    private static final QName p_index = new QName("p", "http://www.w3.org/ns/xproc", "index");
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private ProcessMatch matcher = null;
    private QName attribute = null;
    private RuntimeValue label = null;
    private boolean replace = true;
    private int count = 1;

    public LabelElements(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        this.source = readablePipe;
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        RuntimeValue runtimeValue = this.getOption(_attribute);
        String string = runtimeValue.getString();
        String string2 = this.getOption(_attribute_prefix, (String)null);
        String string3 = this.getOption(_attribute_namespace, (String)null);
        if (string2 != null && string3 == null) {
            throw XProcException.dynamicError(34, "You can't specify a prefix without a namespace");
        }
        if (string3 != null && string.contains(":")) {
            throw XProcException.dynamicError(34, "You can't specify a namespace if the attribute name contains a colon");
        }
        if (string.contains(":")) {
            this.attribute = new QName(string, runtimeValue.getNode());
        } else {
            if (string2 == null && string3 != null) {
                string2 = "_1";
            }
            this.attribute = new QName(string2 == null ? "" : string2, string3, string);
        }
        this.label = this.getOption(_label);
        this.replace = this.getOption(_replace).getBoolean();
        this.matcher = new ProcessMatch(this.runtime, this);
        this.matcher.match(this.source.read(), this.getOption(_match));
        this.result.write(this.matcher.getResult());
    }

    @Override
    public boolean processStartDocument(XdmNode xdmNode) throws SaxonApiException {
        throw XProcException.stepError(24);
    }

    @Override
    public void processEndDocument(XdmNode xdmNode) throws SaxonApiException {
        throw XProcException.stepError(24);
    }

    @Override
    public boolean processStartElement(XdmNode xdmNode) throws SaxonApiException {
        this.matcher.addStartElement(xdmNode);
        boolean bl = false;
        XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.ATTRIBUTE);
        while (xdmSequenceIterator.hasNext()) {
            XdmNode xdmNode2 = (XdmNode)xdmSequenceIterator.next();
            if (this.attribute.equals((Object)xdmNode2.getNodeName())) {
                bl = true;
                if (this.replace) {
                    this.matcher.addAttribute(xdmNode2, this.computedLabel(xdmNode));
                    continue;
                }
                this.matcher.addAttribute(xdmNode2);
                continue;
            }
            this.matcher.addAttribute(xdmNode2);
        }
        if (!bl) {
            this.matcher.addAttribute(this.attribute, this.computedLabel(xdmNode));
        }
        return true;
    }

    @Override
    public void processEndElement(XdmNode xdmNode) throws SaxonApiException {
        this.matcher.addEndElement();
    }

    @Override
    public void processText(XdmNode xdmNode) throws SaxonApiException {
        throw XProcException.stepError(23);
    }

    @Override
    public void processComment(XdmNode xdmNode) throws SaxonApiException {
        throw XProcException.stepError(23);
    }

    @Override
    public void processPI(XdmNode xdmNode) throws SaxonApiException {
        throw XProcException.stepError(23);
    }

    @Override
    public void processAttribute(XdmNode xdmNode) throws SaxonApiException {
        throw XProcException.stepError(23);
    }

    private String computedLabel(XdmNode xdmNode) throws SaxonApiException {
        String string2;
        XPathCompiler xPathCompiler = this.runtime.getProcessor().newXPathCompiler();
        xPathCompiler.setBaseURI(this.step.getNode().getBaseURI());
        for (String string2 : this.label.getNamespaceBindings().keySet()) {
            xPathCompiler.declareNamespace(string2, this.label.getNamespaceBindings().get(string2));
        }
        xPathCompiler.declareVariable(p_index);
        XPathExecutable xPathExecutable = xPathCompiler.compile(this.label.getString());
        string2 = xPathExecutable.load();
        string2.setVariable(p_index, (XdmValue)new XdmAtomicValue((long)this.count++));
        string2.setContextItem((XdmItem)xdmNode);
        Iterator iterator = string2.iterator();
        XdmItem xdmItem = (XdmItem)iterator.next();
        return xdmItem.getStringValue();
    }
}

