/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.XMLtoJSON;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URLConnection;
import java.util.zip.GZIPOutputStream;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;

public class Store
extends DefaultStep {
    private static final QName _href = new QName("href");
    private static final QName _encoding = new QName("encoding");
    private static final QName _content_type = new QName("content-type");
    private static final QName c_encoding = new QName("c", "http://www.w3.org/ns/xproc-step", "encoding");
    private static final QName c_body = new QName("c", "http://www.w3.org/ns/xproc-step", "body");
    private static final QName c_json = new QName("c", "http://www.w3.org/ns/xproc-step", "json");
    private static final QName cx_decode = new QName("cx", "http://xmlcalabash.com/ns/extensions", "decode");
    private ReadablePipe source = null;
    private WritablePipe result = null;
    protected CompressionMethod method = CompressionMethod.NONE;
    private URI href = null;

    public Store(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        this.source = readablePipe;
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        if (this.runtime.getSafeMode()) {
            throw XProcException.dynamicError(21);
        }
        RuntimeValue runtimeValue = this.getOption(_href);
        XdmNode xdmNode = this.source.read();
        if (xdmNode == null || this.source.moreDocuments()) {
            throw XProcException.dynamicError(6);
        }
        if (runtimeValue != null) {
            this.href = runtimeValue.getBaseURI().resolve(runtimeValue.getString());
        }
        if (this.method == CompressionMethod.GZIP) {
            this.finer(runtimeValue == null ? null : runtimeValue.getNode(), "Gzipping" + (this.href == null ? "" : " to \"" + this.href + "\"."));
        } else {
            this.finer(runtimeValue.getNode(), "Storing to \"" + this.href + "\".");
        }
        String string = this.step.getExtensionAttribute(cx_decode);
        XdmNode xdmNode2 = S9apiUtils.getDocumentElement(xdmNode);
        if (("true".equals(string) || "1".equals(string) || this.method != CompressionMethod.NONE) && ("http://www.w3.org/ns/xproc-step".equals(xdmNode2.getNodeName().getNamespaceURI()) && "base64".equals(xdmNode2.getAttributeValue(_encoding)) || "".equals(xdmNode2.getNodeName().getNamespaceURI()) && "base64".equals(xdmNode2.getAttributeValue(c_encoding)))) {
            this.storeBinary(xdmNode, this.href);
        } else if (this.runtime.transparentJSON() && (c_body.equals((Object)xdmNode2.getNodeName()) && ("application/json".equals(xdmNode2.getAttributeValue(_content_type)) || "text/json".equals(xdmNode2.getAttributeValue(_content_type))) || c_json.equals((Object)xdmNode2.getNodeName()) || "http://www.ibm.com/xmlns/prod/2009/jsonx".equals(xdmNode2.getNodeName().getNamespaceURI()) || "http://www.xmlsh.org/jxml".equals(xdmNode2.getNodeName().getNamespaceURI()) || "http://marklogic.com/json".equals(xdmNode2.getNodeName().getNamespaceURI()))) {
            this.storeJSON(xdmNode, this.href);
        } else {
            this.storeXML(xdmNode, this.href);
        }
        if (this.href != null) {
            TreeWriter treeWriter = new TreeWriter(this.runtime);
            treeWriter.startDocument(this.step.getNode().getBaseURI());
            treeWriter.addStartElement(XProcConstants.c_result);
            treeWriter.startContent();
            treeWriter.addText(this.href.toString());
            treeWriter.addEndElement();
            treeWriter.endDocument();
            this.result.write(treeWriter.getResult());
        }
    }

    private void storeXML(XdmNode xdmNode, URI uRI) throws SaxonApiException {
        Serializer serializer = this.makeSerializer();
        try {
            Object object;
            Object object2 = null;
            ByteArrayOutputStream byteArrayOutputStream = null;
            if (uRI == null) {
                byteArrayOutputStream = new ByteArrayOutputStream();
                object2 = byteArrayOutputStream;
            } else if (uRI.getScheme().equals("file")) {
                object = new File(uRI);
                File file = new File(((File)object).getParent());
                if (!file.isDirectory() && !file.mkdirs()) {
                    throw XProcException.stepError(50);
                }
                object2 = new FileOutputStream((File)object);
            } else {
                object = uRI.toURL().openConnection();
                ((URLConnection)object).setDoOutput(true);
                object2 = ((URLConnection)object).getOutputStream();
            }
            if (this.method == CompressionMethod.GZIP) {
                object2 = object = new GZIPOutputStream((OutputStream)object2);
            }
            serializer.setOutputStream((OutputStream)object2);
            S9apiUtils.serialize(this.runtime, xdmNode, serializer);
            ((OutputStream)object2).close();
            if (uRI == null) {
                this.returnData(byteArrayOutputStream);
            }
        }
        catch (IOException iOException) {
            throw XProcException.stepError(50, iOException);
        }
    }

    private void storeBinary(XdmNode xdmNode, URI uRI) {
        try {
            Object object;
            byte[] byArray = Base64.decode(xdmNode.getStringValue());
            Object object2 = null;
            ByteArrayOutputStream byteArrayOutputStream = null;
            if (uRI == null) {
                byteArrayOutputStream = new ByteArrayOutputStream();
                object2 = byteArrayOutputStream;
            } else {
                object = new File(uRI);
                File file = new File(((File)object).getParent());
                if (!file.isDirectory() && !file.mkdirs()) {
                    throw XProcException.stepError(50);
                }
                object2 = new FileOutputStream((File)object);
            }
            if (this.method == CompressionMethod.GZIP) {
                object2 = object = new GZIPOutputStream((OutputStream)object2);
            }
            ((OutputStream)object2).write(byArray);
            ((OutputStream)object2).close();
            if (uRI == null) {
                this.returnData(byteArrayOutputStream);
            }
        }
        catch (IOException iOException) {
            throw new XProcException(iOException);
        }
    }

    private void storeJSON(XdmNode xdmNode, URI uRI) throws SaxonApiException {
        try {
            Object object;
            Object object2;
            Object object3 = null;
            ByteArrayOutputStream byteArrayOutputStream = null;
            if (uRI == null) {
                byteArrayOutputStream = new ByteArrayOutputStream();
                object3 = byteArrayOutputStream;
            } else if (uRI.getScheme().equals("file")) {
                object2 = new File(uRI);
                object = new File(((File)object2).getParent());
                if (!((File)object).isDirectory() && !((File)object).mkdirs()) {
                    throw XProcException.stepError(50);
                }
                object3 = new FileOutputStream((File)object2);
            } else {
                object2 = uRI.toURL().openConnection();
                ((URLConnection)object2).setDoOutput(true);
                object3 = ((URLConnection)object2).getOutputStream();
            }
            if (this.method == CompressionMethod.GZIP) {
                object3 = object2 = new GZIPOutputStream((OutputStream)object3);
            }
            object2 = new PrintWriter((OutputStream)object3);
            object = XMLtoJSON.convert(xdmNode);
            ((PrintWriter)object2).print((String)object);
            ((PrintWriter)object2).close();
            ((OutputStream)object3).close();
            if (uRI == null) {
                this.returnData(byteArrayOutputStream);
            }
        }
        catch (IOException iOException) {
            throw XProcException.stepError(50, iOException);
        }
    }

    public void returnData(ByteArrayOutputStream byteArrayOutputStream) {
        TreeWriter treeWriter = new TreeWriter(this.runtime);
        treeWriter.startDocument(this.step.getNode().getBaseURI());
        treeWriter.addStartElement(XProcConstants.c_data);
        treeWriter.addAttribute(_encoding, "base64");
        treeWriter.addAttribute(_content_type, "application/x-gzip");
        treeWriter.startContent();
        treeWriter.addText(Base64.encodeBytes(byteArrayOutputStream.toByteArray()));
        treeWriter.addEndElement();
        treeWriter.endDocument();
        this.result.write(treeWriter.getResult());
    }

    protected static enum CompressionMethod {
        NONE,
        GZIP;

    }
}

