/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.HttpUtils;
import com.xmlcalabash.util.JSONtoXML;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.tree.util.NamespaceIterator;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.dom.HtmlDocumentBuilder;
import org.ccil.cowan.tagsoup.Parser;
import org.json.JSONTokener;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class UnescapeMarkup
extends DefaultStep {
    private static final QName _namespace = new QName("namespace");
    private static final QName _content_type = new QName("content-type");
    private static final QName _encoding = new QName("encoding");
    private static final QName _charset = new QName("charset");
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private String namespace = null;

    public UnescapeMarkup(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        this.source = readablePipe;
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        String string = this.getOption(_content_type, "application/xml");
        String string2 = HttpUtils.getCharset(string);
        string = HttpUtils.baseContentType(string);
        if (this.getOption(_namespace) != null) {
            this.namespace = this.getOption(_namespace).getString();
        }
        String string3 = null;
        if (this.getOption(_encoding) != null) {
            string3 = this.getOption(_encoding).getString();
        }
        String string4 = null;
        string4 = this.getOption(_charset) == null ? string2 : this.getOption(_charset).getString();
        XdmNode xdmNode = this.source.read();
        String string5 = null;
        if ("base64".equals(string3)) {
            if (string4 == null) {
                throw XProcException.stepError(10);
            }
            string5 = this.decodeBase64(xdmNode, string4);
        } else {
            if (string3 != null) {
                throw new XProcException(this.step.getNode(), "Unexpected encoding: " + string3);
            }
            string5 = this.extractText(xdmNode);
        }
        TreeWriter treeWriter = new TreeWriter(this.runtime);
        treeWriter.startDocument(xdmNode.getBaseURI());
        XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.CHILD);
        XdmNode xdmNode2 = (XdmNode)xdmSequenceIterator.next();
        while (xdmNode2.getNodeKind() != XdmNodeKind.ELEMENT) {
            treeWriter.addSubtree(xdmNode2);
            xdmNode2 = (XdmNode)xdmSequenceIterator.next();
        }
        treeWriter.addStartElement(xdmNode2);
        treeWriter.addAttributes(xdmNode2);
        treeWriter.startContent();
        if ("text/html".equals(string)) {
            XdmNode xdmNode3 = null;
            xdmNode3 = "tagsoup".equals(this.runtime.htmlParser()) ? this.tagSoup(string5) : this.parseHTML(string5);
            if (this.namespace == null) {
                treeWriter.addSubtree(xdmNode3);
            } else {
                this.remapDefaultNamespace(treeWriter, xdmNode3);
            }
        } else if ("application/json".equals(string) || "text/json".equals(string)) {
            JSONTokener jSONTokener = new JSONTokener(string5);
            XdmNode xdmNode4 = JSONtoXML.convert(this.runtime.getProcessor(), jSONTokener, this.runtime.jsonFlavor());
            treeWriter.addSubtree(xdmNode4);
        } else {
            if (!"application/xml".equals(string)) {
                throw XProcException.stepError(51);
            }
            string5 = "<wrapper>" + string5 + "</wrapper>";
            StringReader stringReader = new StringReader(string5);
            InputSource inputSource = new InputSource(stringReader);
            inputSource.setSystemId(xdmNode.getBaseURI().toASCIIString());
            XdmNode xdmNode5 = this.runtime.parse(inputSource);
            XdmNode xdmNode6 = S9apiUtils.getDocumentElement(xdmNode5);
            XdmSequenceIterator xdmSequenceIterator2 = xdmNode6.axisIterator(Axis.CHILD);
            while (xdmSequenceIterator2.hasNext()) {
                xdmNode5 = (XdmNode)xdmSequenceIterator2.next();
                if (this.namespace == null) {
                    treeWriter.addSubtree(xdmNode5);
                    continue;
                }
                this.remapDefaultNamespace(treeWriter, xdmNode5);
            }
        }
        treeWriter.addEndElement();
        treeWriter.endDocument();
        this.result.write(treeWriter.getResult());
    }

    private void remapDefaultNamespace(TreeWriter treeWriter, XdmNode xdmNode) {
        if (xdmNode.getNodeKind() == XdmNodeKind.ELEMENT) {
            String string;
            FingerprintedQName fingerprintedQName;
            FingerprintedQName fingerprintedQName2;
            NodeInfo nodeInfo = xdmNode.getUnderlyingNode();
            int n = 0;
            Iterator iterator = NamespaceIterator.iterateNamespaces((NodeInfo)nodeInfo);
            while (iterator.hasNext()) {
                ++n;
                iterator.next();
            }
            boolean bl = false;
            NamespaceBinding[] namespaceBindingArray = null;
            if (n > 0) {
                fingerprintedQName2 = new NamespaceBinding[n];
                namespaceBindingArray = new NamespaceBinding[n + 1];
                for (int i = 0; i < ((FingerprintedQName)fingerprintedQName2).length; ++i) {
                    fingerprintedQName = fingerprintedQName2[i];
                    string = fingerprintedQName.getPrefix();
                    if ("".equals(string)) {
                        NamespaceBinding namespaceBinding;
                        namespaceBindingArray[i] = namespaceBinding = new NamespaceBinding(string, this.namespace);
                        bl = true;
                        continue;
                    }
                    namespaceBindingArray[i] = fingerprintedQName;
                }
                if (!bl) {
                    NamespaceBinding namespaceBinding;
                    namespaceBindingArray[namespaceBindingArray.length - 1] = namespaceBinding = new NamespaceBinding("", this.namespace);
                }
            }
            fingerprintedQName2 = new FingerprintedQName("", this.namespace, nodeInfo.getLocalPart());
            treeWriter.addStartElement((NodeName)fingerprintedQName2, nodeInfo.getSchemaType(), namespaceBindingArray);
            XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.ATTRIBUTE);
            while (xdmSequenceIterator.hasNext()) {
                fingerprintedQName = (XdmNode)xdmSequenceIterator.next();
                treeWriter.addAttribute((XdmNode)fingerprintedQName);
            }
            fingerprintedQName = xdmNode.axisIterator(Axis.CHILD);
            while (fingerprintedQName.hasNext()) {
                string = (XdmNode)fingerprintedQName.next();
                this.remapDefaultNamespace(treeWriter, (XdmNode)string);
            }
            treeWriter.addEndElement();
        } else {
            treeWriter.addSubtree(xdmNode);
        }
    }

    private String extractText(XdmNode xdmNode) {
        String string = "";
        XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.CHILD);
        while (xdmSequenceIterator.hasNext()) {
            XdmNode xdmNode2 = (XdmNode)xdmSequenceIterator.next();
            if (xdmNode2.getNodeKind() != XdmNodeKind.ELEMENT && xdmNode2.getNodeKind() != XdmNodeKind.TEXT) continue;
            string = string + xdmNode2.getStringValue();
        }
        return string;
    }

    private String decodeBase64(XdmNode xdmNode, String string) {
        String string2 = this.extractText(xdmNode);
        byte[] byArray = Base64.decode(string2);
        try {
            return new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw XProcException.stepError(10, unsupportedEncodingException);
        }
    }

    private XdmNode tagSoup(String string) {
        StringReader stringReader = new StringReader(string);
        InputSource inputSource = new InputSource(stringReader);
        Parser parser = new Parser();
        parser.setEntityResolver((EntityResolver)this.runtime.getResolver());
        SAXSource sAXSource = new SAXSource((XMLReader)parser, inputSource);
        DocumentBuilder documentBuilder = this.runtime.getProcessor().newDocumentBuilder();
        try {
            XdmNode xdmNode = documentBuilder.build((Source)sAXSource);
            return xdmNode;
        }
        catch (Exception exception) {
            throw new XProcException(exception);
        }
    }

    private XdmNode parseHTML(String string) {
        HtmlDocumentBuilder htmlDocumentBuilder = new HtmlDocumentBuilder(XmlViolationPolicy.ALTER_INFOSET);
        htmlDocumentBuilder.setEntityResolver((EntityResolver)this.runtime.getResolver());
        try {
            InputSource inputSource = new InputSource(new StringReader(string));
            Document document = htmlDocumentBuilder.parse(inputSource);
            DocumentBuilder documentBuilder = this.runtime.getProcessor().newDocumentBuilder();
            XdmNode xdmNode = documentBuilder.build((Source)new DOMSource(document));
            return xdmNode;
        }
        catch (Exception exception) {
            throw new XProcException(exception);
        }
    }
}

