/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.S9apiUtils;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SaxonApiUncheckedException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.InputSource;

public class ValidateWithSCH
extends DefaultStep {
    private static final QName _assert_valid = new QName("", "assert-valid");
    private static final QName _phase = new QName("", "phase");
    private InputStream skeleton = null;
    private ReadablePipe source = null;
    private ReadablePipe schema = null;
    private WritablePipe resultPipe = null;
    private WritablePipe reportPipe = null;
    private Hashtable<QName, RuntimeValue> params = new Hashtable();
    private boolean schemaAware = false;

    public ValidateWithSCH(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        if ("source".equals(string)) {
            this.source = readablePipe;
        } else if ("schema".equals(string)) {
            this.schema = readablePipe;
        }
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        if ("result".equals(string)) {
            this.resultPipe = writablePipe;
        } else if ("report".equals(string)) {
            this.reportPipe = writablePipe;
        }
    }

    @Override
    public void setParameter(QName qName, RuntimeValue runtimeValue) {
        this.params.put(qName, runtimeValue);
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.schema.resetReader();
        this.resultPipe.resetWriter();
        this.reportPipe.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        RuntimeValue runtimeValue;
        QName qName2;
        Object object;
        super.run();
        XdmNode xdmNode = this.source.read();
        this.schemaAware = xdmNode.getUnderlyingNode().getTypeAnnotation() != 630;
        XdmNode xdmNode2 = this.schema.read();
        XdmNode xdmNode3 = this.transform(xdmNode2, this.getSchematronXSLT("iso_dsdl_include.xsl"));
        XdmNode xdmNode4 = this.transform(xdmNode3, this.getSchematronXSLT("iso_abstract_expand.xsl"));
        this.skeleton = this.getClass().getResourceAsStream("/etc/schematron/iso_schematron_skeleton_for_saxon.xsl");
        if (this.skeleton == null) {
            throw new UnsupportedOperationException("Failed to load iso_schematron_skeleton_for_saxon.xsl from JAR file.");
        }
        XsltCompiler xsltCompiler = this.runtime.getProcessor().newXsltCompiler();
        xsltCompiler.setSchemaAware(this.schemaAware);
        xsltCompiler.setURIResolver((URIResolver)new UResolver());
        XsltExecutable xsltExecutable = xsltCompiler.compile((Source)this.getSchematronXSLT("iso_svrl_for_xslt2.xsl"));
        XsltTransformer xsltTransformer = xsltExecutable.load();
        if (this.getOption(_phase) != null) {
            object = this.getOption(_phase).getString();
            xsltTransformer.setParameter(new QName("", "phase"), (XdmValue)new XdmAtomicValue((String)object));
        }
        for (QName qName2 : this.params.keySet()) {
            runtimeValue = this.params.get(qName2);
            xsltTransformer.setParameter(qName2, (XdmValue)new XdmAtomicValue(runtimeValue.getString()));
        }
        xsltTransformer.setInitialContextNode(xdmNode4);
        XdmDestination xdmDestination = new XdmDestination();
        xsltTransformer.setDestination((Destination)xdmDestination);
        this.runtime.getConfigurer().getSaxonConfigurer().configSchematron(xsltTransformer.getUnderlyingController().getConfiguration());
        xsltTransformer.transform();
        object = xdmDestination.getXdmNode();
        qName2 = S9apiUtils.getDocumentElement((XdmNode)object);
        if (qName2 == null) {
            runtimeValue = S9apiUtils.getDocumentElement(xdmNode2);
            String string = runtimeValue == null ? "null" : runtimeValue.getNodeName().toString();
            throw new XProcException("p:validate-with-schematron failed to compile provided schema: " + string);
        }
        xsltCompiler = this.runtime.getProcessor().newXsltCompiler();
        xsltCompiler.setSchemaAware(this.schemaAware);
        xsltExecutable = xsltCompiler.compile(object.asSource());
        runtimeValue = xsltExecutable.load();
        runtimeValue.setInitialContextNode(xdmNode);
        xdmDestination = new XdmDestination();
        runtimeValue.setDestination((Destination)xdmDestination);
        runtimeValue.transform();
        XdmNode xdmNode5 = xdmDestination.getXdmNode();
        boolean bl = this.checkFailedAssert(xdmNode5);
        if (bl && this.getOption(_assert_valid, false)) {
            throw XProcException.stepError(54);
        }
        this.resultPipe.write(xdmNode);
        this.reportPipe.write(xdmNode5);
    }

    private boolean checkFailedAssert(XdmNode xdmNode) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("svrl", "http://purl.oclc.org/dsdl/svrl");
        String string = "//svrl:failed-assert";
        Vector vector = new Vector();
        Configuration configuration = this.runtime.getProcessor().getUnderlyingConfiguration();
        try {
            String string22;
            XPathCompiler xPathCompiler = this.runtime.getProcessor().newXPathCompiler();
            xPathCompiler.setBaseURI(this.step.getNode().getBaseURI());
            for (String string22 : hashtable.keySet()) {
                xPathCompiler.declareNamespace(string22, (String)hashtable.get(string22));
            }
            XPathExecutable xPathExecutable = null;
            xPathExecutable = xPathCompiler.compile(string);
            string22 = xPathExecutable.load();
            string22.setContextItem((XdmItem)xdmNode);
            try {
                Iterator iterator = string22.iterator();
                while (iterator.hasNext()) {
                    vector.add(iterator.next());
                }
            }
            catch (SaxonApiUncheckedException saxonApiUncheckedException) {
                Throwable throwable = saxonApiUncheckedException.getCause();
                if (throwable instanceof XPathException) {
                    XPathException xPathException = (XPathException)throwable;
                    if ("http://www.w3.org/2005/xqt-errors".equals(xPathException.getErrorCodeNamespace()) && "XPDY0002".equals(xPathException.getErrorCodeLocalPart())) {
                        throw XProcException.dynamicError(26, this.step.getNode(), "Expression refers to context when none is available: " + string);
                    }
                    throw saxonApiUncheckedException;
                }
                throw saxonApiUncheckedException;
            }
        }
        catch (SaxonApiException saxonApiException) {
            throw new XProcException(saxonApiException);
        }
        return vector.size() != 0;
    }

    private SAXSource getSchematronXSLT(String string) {
        InputStream inputStream = this.getClass().getResourceAsStream("/etc/schematron/" + string);
        if (inputStream == null) {
            throw new UnsupportedOperationException("Failed to load " + string + " from JAR file.");
        }
        return new SAXSource(new InputSource(inputStream));
    }

    private XdmNode transform(XdmNode xdmNode, SAXSource sAXSource) throws SaxonApiException {
        XsltCompiler xsltCompiler = this.runtime.getProcessor().newXsltCompiler();
        xsltCompiler.setSchemaAware(this.schemaAware);
        xsltCompiler.setURIResolver((URIResolver)new UResolver());
        XsltExecutable xsltExecutable = xsltCompiler.compile((Source)sAXSource);
        XsltTransformer xsltTransformer = xsltExecutable.load();
        xsltTransformer.setInitialContextNode(xdmNode);
        XdmDestination xdmDestination = new XdmDestination();
        xsltTransformer.setDestination((Destination)xdmDestination);
        xsltTransformer.transform();
        return xdmDestination.getXdmNode();
    }

    private class UResolver
    implements URIResolver {
        private UResolver() {
        }

        @Override
        public Source resolve(String string, String string2) throws TransformerException {
            if ("iso_schematron_skeleton_for_saxon.xsl".equals(string)) {
                return new SAXSource(new InputSource(ValidateWithSCH.this.skeleton));
            }
            throw new XProcException(ValidateWithSCH.this.step.getNode(), "Failed to resolve " + string + " from JAR file.");
        }
    }
}

