/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SchemaManager;
import net.sf.saxon.s9api.SchemaValidator;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmNode;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidateWithXSD
extends DefaultStep {
    private static final QName _assert_valid = new QName("", "assert-valid");
    private static final QName _mode = new QName("", "mode");
    private static final QName _use_location_hints = new QName("", "use-location-hints");
    private static final QName _try_namespaces = new QName("", "try-namespaces");
    private static final QName _line = new QName("line");
    private static final QName _column = new QName("column");
    private static final Class[] paramTypes = new Class[0];
    private ReadablePipe source = null;
    private ReadablePipe schemas = null;
    private WritablePipe result = null;
    private URI docBaseURI = null;
    private Throwable validationException = null;

    public ValidateWithXSD(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        if ("source".equals(string)) {
            this.source = readablePipe;
        } else if ("schema".equals(string)) {
            this.schemas = readablePipe;
        }
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        Processor processor = this.runtime.getProcessor();
        SchemaManager schemaManager = processor.getSchemaManager();
        if (schemaManager == null) {
            this.validateWithXerces();
        } else {
            this.validateWithSaxonSA(schemaManager);
        }
    }

    public void validateWithSaxonSA(SchemaManager schemaManager) throws SaxonApiException {
        Object object;
        block13: {
            Object object2;
            InputSource inputSource;
            Method method;
            this.fine(this.step.getNode(), "Validating with Saxon");
            Configuration configuration = this.runtime.getProcessor().getUnderlyingConfiguration();
            this.runtime.getConfigurer().getSaxonConfigurer().configXSD(configuration);
            try {
                method = configuration.getClass().getMethod("clearSchemaCache", paramTypes);
                method.invoke((Object)configuration, new Object[0]);
                this.finest(this.step.getNode(), "Cleared schema cache.");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.finest(this.step.getNode(), "Cannot reset schema cache.");
            }
            catch (IllegalAccessException illegalAccessException) {
                this.finest(this.step.getNode(), "Cannot reset schema cache.");
            }
            catch (InvocationTargetException invocationTargetException) {
                this.finest(this.step.getNode(), "Cannot reset schema cache.");
            }
            method = this.source.read();
            this.docBaseURI = method.getBaseURI();
            String string2 = S9apiUtils.getDocumentElement((XdmNode)method).getNodeName().getNamespaceURI();
            boolean bl = this.getOption(_try_namespaces, false) && !"".equals(string2);
            Vector<Object> vector = new Vector<Object>();
            while (this.schemas.moreDocuments()) {
                object = this.schemas.read();
                String string3 = object.getBaseURI().toASCIIString();
                this.finer(this.step.getNode(), "Caching input schema: " + string3);
                if (string3.equals(string2)) {
                    bl = false;
                }
                vector.add(object);
                this.runtime.getResolver().cache((XdmNode)object, object.getBaseURI());
            }
            if (bl) {
                try {
                    object = this.runtime.parse(string2, method.getBaseURI().toASCIIString(), false);
                    vector.add(object);
                    this.runtime.getResolver().cache((XdmNode)object, object.getBaseURI());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            for (XdmNode xdmNode : vector) {
                inputSource = S9apiUtils.xdmToInputSource(this.runtime, xdmNode);
                inputSource.setSystemId(xdmNode.getBaseURI().toASCIIString());
                object2 = new SAXSource(inputSource);
                schemaManager.load((Source)object2);
            }
            object = new XdmDestination();
            Controller controller = new Controller(configuration);
            inputSource = object.getReceiver(controller.getConfiguration());
            object2 = controller.makePipelineConfiguration();
            object2.setRecoverFromValidationErrors(!this.getOption(_assert_valid, false));
            inputSource.setPipelineConfiguration((PipelineConfiguration)object2);
            SchemaValidator schemaValidator = schemaManager.newSchemaValidator();
            schemaValidator.setDestination((Destination)object);
            schemaValidator.setErrorListener((ErrorListener)new XSDErrorHandler());
            String string = this.getOption(_mode, "strict");
            schemaValidator.setLax("lax".equals(string));
            boolean bl2 = this.getOption(_use_location_hints, false);
            schemaValidator.setUseXsiSchemaLocation(bl2);
            try {
                this.finer(this.step.getNode(), "Validating: " + method.getBaseURI().toASCIIString());
                schemaValidator.validate(method.asSource());
                if (this.validationException != null) {
                    throw (SaxonApiException)this.validationException;
                }
            }
            catch (SaxonApiException saxonApiException) {
                if (!this.getOption(_assert_valid, false)) break block13;
                throw new XProcException(XProcConstants.stepError(53), (Throwable)saxonApiException);
            }
        }
        XdmNode xdmNode = object.getXdmNode();
        this.result.write(xdmNode);
    }

    private void validateWithXerces() throws SaxonApiException {
        XdmNode xdmNode;
        this.fine(this.step.getNode(), "Validating with Xerces");
        Vector<XdmNode> vector = new Vector<XdmNode>();
        while (this.schemas.moreDocuments()) {
            xdmNode = this.schemas.read();
            vector.add(xdmNode);
            this.runtime.getResolver().cache(xdmNode, xdmNode.getBaseURI());
        }
        xdmNode = this.source.read();
        this.docBaseURI = xdmNode.getBaseURI();
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            this.runtime.getConfigurer().getJaxpConfigurer().configSchemaFactory(schemaFactory);
            XdmNode xdmNode2 = (XdmNode)vector.get(0);
            InputSource inputSource = S9apiUtils.xdmToInputSource(this.runtime, xdmNode2);
            inputSource.setSystemId(xdmNode2.getBaseURI().toASCIIString());
            Schema schema = schemaFactory.newSchema(new SAXSource(inputSource));
            Validator validator = schema.newValidator();
            validator.setErrorHandler(new XSDErrorHandler());
            InputSource inputSource2 = S9apiUtils.xdmToInputSource(this.runtime, xdmNode);
            inputSource2.setSystemId(xdmNode.getBaseURI().toASCIIString());
            try {
                validator.validate(new SAXSource(inputSource2));
                if (this.validationException != null) {
                    throw (SAXParseException)this.validationException;
                }
            }
            catch (SAXParseException sAXParseException) {
                if (this.getOption(_assert_valid, false)) {
                    throw new XProcException(XProcConstants.stepError(53), (Throwable)sAXParseException);
                }
            }
        }
        catch (SAXException sAXException) {
            throw new XProcException(sAXException);
        }
        catch (IOException iOException) {
            throw new XProcException(iOException);
        }
        this.result.write(xdmNode);
    }

    class XSDErrorHandler
    implements ErrorHandler,
    ErrorListener {
        XSDErrorHandler() {
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.error(sAXParseException);
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            TreeWriter treeWriter = new TreeWriter(ValidateWithXSD.this.runtime);
            treeWriter.startDocument(ValidateWithXSD.this.docBaseURI);
            treeWriter.addStartElement(XProcConstants.c_error);
            if (sAXParseException.getLineNumber() != -1) {
                treeWriter.addAttribute(_line, "" + sAXParseException.getLineNumber());
            }
            if (sAXParseException.getColumnNumber() != -1) {
                treeWriter.addAttribute(_column, "" + sAXParseException.getColumnNumber());
            }
            treeWriter.startContent();
            treeWriter.addText(sAXParseException.toString());
            treeWriter.addEndElement();
            treeWriter.addText("\n");
            treeWriter.endDocument();
            ValidateWithXSD.this.step.reportError(treeWriter.getResult());
            if (ValidateWithXSD.this.validationException == null) {
                ValidateWithXSD.this.validationException = sAXParseException;
            }
        }

        @Override
        public void warning(SAXParseException sAXParseException) {
        }

        @Override
        public void warning(TransformerException transformerException) throws TransformerException {
        }

        @Override
        public void error(TransformerException transformerException) throws TransformerException {
            TreeWriter treeWriter = new TreeWriter(ValidateWithXSD.this.runtime);
            treeWriter.startDocument(ValidateWithXSD.this.docBaseURI);
            treeWriter.addStartElement(XProcConstants.c_error);
            SourceLocator sourceLocator = transformerException.getLocator();
            if (sourceLocator != null) {
                if (sourceLocator.getLineNumber() != -1) {
                    treeWriter.addAttribute(_line, "" + sourceLocator.getLineNumber());
                }
                if (sourceLocator.getColumnNumber() != -1) {
                    treeWriter.addAttribute(_column, "" + sourceLocator.getColumnNumber());
                }
            }
            treeWriter.startContent();
            treeWriter.addText(transformerException.toString());
            treeWriter.addEndElement();
            treeWriter.addText("\n");
            treeWriter.endDocument();
            ValidateWithXSD.this.step.reportError(treeWriter.getResult());
            if (ValidateWithXSD.this.validationException == null) {
                ValidateWithXSD.this.validationException = transformerException;
            }
        }

        @Override
        public void fatalError(TransformerException transformerException) throws TransformerException {
            this.error(transformerException);
        }
    }
}

