/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.DocumentSequenceIterator;
import com.xmlcalabash.util.TreeWriter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.trans.XPathException;

public class WrapSequence
extends DefaultStep {
    private static QName _wrapper = new QName("", "wrapper");
    private static QName _wrapper_prefix = new QName("", "wrapper-prefix");
    private static QName _wrapper_namespace = new QName("", "wrapper-namespace");
    private static QName _group_adjacent = new QName("", "group-adjacent");
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private QName wrapper = null;
    private RuntimeValue groupAdjacent = null;

    public WrapSequence(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        this.source = readablePipe;
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        RuntimeValue runtimeValue = this.getOption(_wrapper);
        String string = runtimeValue.getString();
        String string2 = this.getOption(_wrapper_prefix, (String)null);
        String string3 = this.getOption(_wrapper_namespace, (String)null);
        if (string2 != null && string3 == null) {
            throw XProcException.dynamicError(34, this.step.getNode(), "You can't specify a prefix without a namespace");
        }
        if (string3 != null && string.contains(":")) {
            throw XProcException.dynamicError(34, this.step.getNode(), "You can't specify a namespace if the wrapper name contains a colon");
        }
        this.wrapper = string.contains(":") ? new QName(string, runtimeValue.getNode()) : new QName(string2 == null ? "" : string2, string3, string);
        this.groupAdjacent = this.getOption(_group_adjacent);
        if (this.groupAdjacent != null) {
            this.runAdjacent();
        } else {
            this.runSimple();
        }
    }

    private void runSimple() throws SaxonApiException {
        XdmNode xdmNode;
        TreeWriter treeWriter = new TreeWriter(this.runtime);
        treeWriter.startDocument(this.step.getNode().getBaseURI());
        treeWriter.addStartElement(this.wrapper);
        treeWriter.startContent();
        while (this.source.moreDocuments()) {
            xdmNode = this.source.read();
            treeWriter.addSubtree(xdmNode);
        }
        treeWriter.addEndElement();
        treeWriter.endDocument();
        xdmNode = treeWriter.getResult();
        this.result.write(xdmNode);
    }

    private void runAdjacent() throws SaxonApiException {
        TreeWriter treeWriter = null;
        String string = null;
        boolean bl = false;
        int n = 0;
        while (this.source.moreDocuments()) {
            ++n;
            this.source.read();
        }
        this.source.resetReader();
        DocumentSequenceIterator documentSequenceIterator = new DocumentSequenceIterator();
        documentSequenceIterator.setLast(n);
        int n2 = 0;
        while (this.source.moreDocuments()) {
            Object object;
            XdmNode xdmNode = this.source.read();
            ++n2;
            Item item = null;
            try {
                String string22;
                object = this.runtime.getProcessor().newXPathCompiler();
                object.setBaseURI(this.step.getNode().getBaseURI());
                for (String string22 : this.groupAdjacent.getNamespaceBindings().keySet()) {
                    object.declareNamespace(string22, this.groupAdjacent.getNamespaceBindings().get(string22));
                }
                XPathExecutable xPathExecutable = object.compile(this.groupAdjacent.getString());
                string22 = xPathExecutable.getUnderlyingExpression();
                XPathDynamicContext xPathDynamicContext = string22.createDynamicContext((Item)xdmNode.getUnderlyingNode());
                XPathContext xPathContext = xPathDynamicContext.getXPathContextObject();
                documentSequenceIterator.setPosition(n2);
                documentSequenceIterator.setItem((Item)xdmNode.getUnderlyingNode());
                xPathContext.setCurrentIterator((SequenceIterator)documentSequenceIterator);
                SequenceIterator sequenceIterator = string22.iterate(xPathDynamicContext);
                item = sequenceIterator.next();
                if (item == null) {
                    throw new XProcException(this.step.getNode(), "The group-adjacent expression returned nothing.");
                }
                if (sequenceIterator.next() != null) {
                    throw new XProcException(this.step.getNode(), "Didn't expect group-adjacent to return a sequence!");
                }
            }
            catch (XPathException xPathException) {
                throw new XProcException(xPathException);
            }
            object = item.getStringValue();
            if (string != null) {
                if (string.equals(object)) {
                    treeWriter.addSubtree(xdmNode);
                } else if (bl) {
                    bl = false;
                    treeWriter.addEndElement();
                    treeWriter.endDocument();
                    this.result.write(treeWriter.getResult());
                }
            }
            if (string != null && string.equals(object)) continue;
            string = object;
            bl = true;
            treeWriter = new TreeWriter(this.runtime);
            treeWriter.startDocument(this.step.getNode().getBaseURI());
            treeWriter.addStartElement(this.wrapper);
            treeWriter.startContent();
            treeWriter.addSubtree(xdmNode);
        }
        if (bl) {
            bl = false;
            treeWriter.addEndElement();
            treeWriter.endDocument();
            this.result.write(treeWriter.getResult());
        }
    }
}

