/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.CollectionResolver;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import java.util.Hashtable;
import java.util.Vector;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.CollectionURIResolver;
import net.sf.saxon.lib.ModuleURIResolver;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XQueryEvaluator;
import net.sf.saxon.s9api.XQueryExecutable;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmValue;

public class XQuery
extends DefaultStep {
    private static final QName _content_type = new QName("content-type");
    private ReadablePipe source = null;
    private Hashtable<QName, RuntimeValue> params = new Hashtable();
    private ReadablePipe query = null;
    private WritablePipe result = null;

    public XQuery(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        if ("source".equals(string)) {
            this.source = readablePipe;
        } else if ("query".equals(string)) {
            this.query = readablePipe;
        }
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void setParameter(QName qName, RuntimeValue runtimeValue) {
        this.params.put(qName, runtimeValue);
    }

    @Override
    public void reset() {
        this.query.resetReader();
        this.result.resetWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws SaxonApiException {
        Object object;
        super.run();
        Vector<XdmNode> vector = new Vector<XdmNode>();
        while (this.source.moreDocuments()) {
            vector.add(this.source.read());
        }
        XdmNode xdmNode = null;
        if (vector.size() > 0) {
            xdmNode = (XdmNode)vector.firstElement();
        }
        XdmNode xdmNode2 = S9apiUtils.getDocumentElement(this.query.read());
        String string = null;
        if (XProcConstants.c_data.equals((Object)xdmNode2.getNodeName()) && "application/octet-stream".equals(xdmNode2.getAttributeValue(_content_type)) || "base64".equals(xdmNode2.getAttributeValue(_encoding))) {
            object = Base64.decode(xdmNode2.getStringValue());
            string = new String((byte[])object);
        } else {
            string = xdmNode2.getStringValue();
        }
        object = this.runtime.getProcessor().getUnderlyingConfiguration();
        this.runtime.getConfigurer().getSaxonConfigurer().configXQuery((Configuration)object);
        CollectionURIResolver collectionURIResolver = object.getCollectionURIResolver();
        object.setCollectionURIResolver((CollectionURIResolver)new CollectionResolver(this.runtime, vector, collectionURIResolver));
        try {
            RuntimeValue runtimeValue;
            Processor processor = this.runtime.getProcessor();
            XQueryCompiler xQueryCompiler = processor.newXQueryCompiler();
            xQueryCompiler.setBaseURI(xdmNode2.getBaseURI());
            xQueryCompiler.setModuleURIResolver((ModuleURIResolver)this.runtime.getResolver());
            XQueryExecutable xQueryExecutable = xQueryCompiler.compile(string);
            XQueryEvaluator xQueryEvaluator = xQueryExecutable.load();
            if (xdmNode != null) {
                xQueryEvaluator.setContextItem((XdmItem)xdmNode);
            }
            for (QName qName : this.params.keySet()) {
                runtimeValue = this.params.get(qName);
                if (this.runtime.getAllowGeneralExpressions()) {
                    xQueryEvaluator.setExternalVariable(qName, runtimeValue.getValue());
                    continue;
                }
                xQueryEvaluator.setExternalVariable(qName, (XdmValue)new XdmAtomicValue(runtimeValue.getString()));
            }
            for (QName qName : xQueryEvaluator) {
                if (qName.isAtomicValue()) {
                    throw new XProcException(this.step.getNode(), "Not expecting atomic values back from XQuery!");
                }
                runtimeValue = (XdmNode)qName;
                if (runtimeValue.getNodeKind() != XdmNodeKind.DOCUMENT) {
                    TreeWriter treeWriter = new TreeWriter(this.runtime);
                    treeWriter.startDocument(this.step.getNode().getBaseURI());
                    treeWriter.addSubtree((XdmNode)runtimeValue);
                    treeWriter.endDocument();
                    runtimeValue = treeWriter.getResult();
                }
                this.result.write((XdmNode)runtimeValue);
            }
        }
        finally {
            object.setCollectionURIResolver(collectionURIResolver);
        }
    }
}

