/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.CollectionResolver;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.XProcURIResolver;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.lib.CollectionURIResolver;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.lib.UnparsedTextURIResolver;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.MessageListener;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.ValidationMode;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltTransformer;
import org.xml.sax.InputSource;

public class XSLT
extends DefaultStep {
    private static final QName _initial_mode = new QName("", "initial-mode");
    private static final QName _template_name = new QName("", "template-name");
    private static final QName _output_base_uri = new QName("", "output-base-uri");
    private static final QName _version = new QName("", "version");
    private ReadablePipe sourcePipe = null;
    private ReadablePipe stylesheetPipe = null;
    private WritablePipe resultPipe = null;
    private WritablePipe secondaryPipe = null;
    private Hashtable<QName, RuntimeValue> params = new Hashtable();
    private Hashtable<String, XdmDestination> secondaryResults = new Hashtable();

    public XSLT(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        if ("source".equals(string)) {
            this.sourcePipe = readablePipe;
        } else {
            this.stylesheetPipe = readablePipe;
        }
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        if ("result".equals(string)) {
            this.resultPipe = writablePipe;
        } else {
            this.secondaryPipe = writablePipe;
        }
    }

    @Override
    public void setParameter(QName qName, RuntimeValue runtimeValue) {
        this.params.put(qName, runtimeValue);
    }

    @Override
    public void reset() {
        this.sourcePipe.resetReader();
        this.stylesheetPipe.resetReader();
        this.resultPipe.resetWriter();
        this.secondaryPipe.resetWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws SaxonApiException {
        Object object;
        XsltCompiler xsltCompiler;
        XdmNode xdmNode;
        super.run();
        XdmNode xdmNode2 = this.stylesheetPipe.read();
        if (xdmNode2 == null) {
            throw XProcException.dynamicError(6, this.step.getNode(), "No stylesheet provided.");
        }
        Vector<XdmNode> vector = new Vector<XdmNode>();
        while (this.sourcePipe.moreDocuments()) {
            vector.add(this.sourcePipe.read());
        }
        XdmNode xdmNode3 = null;
        if (vector.size() > 0) {
            xdmNode3 = (XdmNode)vector.firstElement();
        }
        String string = null;
        if (this.getOption(_version) == null) {
            xdmNode = S9apiUtils.getDocumentElement(xdmNode2);
            string = xdmNode.getAttributeValue(new QName("", "version"));
            if (string == null) {
                string = xdmNode.getAttributeValue(new QName("http://www.w3.org/1999/XSL/Transform", "version"));
            }
            if (string == null) {
                string = "2.0";
            }
        } else {
            string = this.getOption(_version).getString();
        }
        if ("3.0".equals(string) && Configuration.softwareEdition.toLowerCase().equals("he")) {
            throw XProcException.stepError(38, "XSLT version '" + string + "' is not supported (Saxon PE or EE processor required).");
        }
        if ("1.0".equals(string) && vector.size() > 1) {
            throw XProcException.stepError(39);
        }
        if ("1.0".equals(string) && this.runtime.getUseXslt10Processor()) {
            this.run10(xdmNode2, xdmNode3);
            return;
        }
        xdmNode = null;
        QName qName = null;
        String string2 = null;
        RuntimeValue runtimeValue = this.getOption(_initial_mode);
        if (runtimeValue != null) {
            xdmNode = runtimeValue.getQName();
        }
        if ((runtimeValue = this.getOption(_template_name)) != null) {
            qName = runtimeValue.getQName();
        }
        if ((runtimeValue = this.getOption(_output_base_uri)) != null) {
            string2 = runtimeValue.getString();
        }
        Processor processor = this.runtime.getProcessor();
        Configuration configuration = processor.getUnderlyingConfiguration();
        this.runtime.getConfigurer().getSaxonConfigurer().configXSLT(configuration);
        OutputURIResolver outputURIResolver = configuration.getOutputURIResolver();
        CollectionURIResolver collectionURIResolver = configuration.getCollectionURIResolver();
        XProcURIResolver xProcURIResolver = this.runtime.getResolver();
        configuration.setOutputURIResolver((OutputURIResolver)new OutputResolver());
        configuration.setCollectionURIResolver((CollectionURIResolver)new CollectionResolver(this.runtime, vector, collectionURIResolver));
        XdmDestination xdmDestination = null;
        try {
            xsltCompiler = this.runtime.getProcessor().newXsltCompiler();
            xsltCompiler.setSchemaAware(processor.isSchemaAware());
            object = xsltCompiler.compile(xdmNode2.asSource());
            XsltTransformer xsltTransformer = object.load();
            for (QName qName2 : this.params.keySet()) {
                RuntimeValue runtimeValue2 = this.params.get(qName2);
                if (this.runtime.getAllowGeneralExpressions()) {
                    xsltTransformer.setParameter(qName2, runtimeValue2.getValue());
                    continue;
                }
                xsltTransformer.setParameter(qName2, (XdmValue)new XdmAtomicValue(runtimeValue2.getString()));
            }
            if (xdmNode3 != null) {
                xsltTransformer.setInitialContextNode(xdmNode3);
            }
            xsltTransformer.setMessageListener((MessageListener)new CatchMessages());
            xdmDestination = new XdmDestination();
            xsltTransformer.setDestination((Destination)xdmDestination);
            if (xdmNode != null) {
                xsltTransformer.setInitialMode((QName)xdmNode);
            }
            if (qName != null) {
                xsltTransformer.setInitialTemplate(qName);
            }
            if (string2 != null) {
                xsltTransformer.setBaseOutputURI(string2);
                try {
                    xdmDestination.setBaseURI(new URI(string2));
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            xsltTransformer.setSchemaValidationMode(ValidationMode.DEFAULT);
            xsltTransformer.getUnderlyingController().setUnparsedTextURIResolver((UnparsedTextURIResolver)xProcURIResolver);
            xsltTransformer.transform();
        }
        finally {
            configuration.setOutputURIResolver(outputURIResolver);
            configuration.setCollectionURIResolver(collectionURIResolver);
        }
        xsltCompiler = xdmDestination.getXdmNode();
        if (xsltCompiler != null) {
            if (xdmNode3 != null && (xsltCompiler.getBaseURI() == null || "".equals(xsltCompiler.getBaseURI().toASCIIString()))) {
                object = xdmNode3.getBaseURI().toASCIIString();
                xsltCompiler.getUnderlyingNode().setSystemId((String)object);
            }
            this.resultPipe.write((XdmNode)xsltCompiler);
        }
    }

    public void run10(XdmNode xdmNode, XdmNode xdmNode2) {
        try {
            RuntimeValue runtimeValue;
            QName qName2;
            InputSource inputSource = S9apiUtils.xdmToInputSource(this.runtime, xdmNode);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(new SAXSource(inputSource));
            transformer.setURIResolver(this.runtime.getResolver());
            for (QName qName2 : this.params.keySet()) {
                runtimeValue = this.params.get(qName2);
                transformer.setParameter(qName2.getClarkName(), runtimeValue.getString());
            }
            DOMResult dOMResult = new DOMResult();
            inputSource = S9apiUtils.xdmToInputSource(this.runtime, xdmNode2);
            transformer.transform(new SAXSource(inputSource), dOMResult);
            qName2 = this.runtime.getConfiguration().getProcessor().newDocumentBuilder();
            runtimeValue = qName2.build((Source)new DOMSource(dOMResult.getNode()));
            if (runtimeValue != null) {
                if (xdmNode2 != null && (runtimeValue.getBaseURI() == null || "".equals(runtimeValue.getBaseURI().toASCIIString()))) {
                    String string = xdmNode2.getBaseURI().toASCIIString();
                    runtimeValue.getUnderlyingNode().setSystemId(string);
                }
                this.resultPipe.write((XdmNode)runtimeValue);
            }
        }
        catch (SaxonApiException saxonApiException) {
            throw new XProcException(saxonApiException);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new XProcException(transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw new XProcException(transformerException);
        }
    }

    class CatchMessages
    implements MessageListener {
        public void message(XdmNode xdmNode, boolean bl, SourceLocator sourceLocator) {
            TreeWriter treeWriter = new TreeWriter(XSLT.this.runtime);
            treeWriter.startDocument(xdmNode.getBaseURI());
            treeWriter.addStartElement(XProcConstants.c_error);
            treeWriter.startContent();
            treeWriter.addSubtree(xdmNode);
            treeWriter.addEndElement();
            treeWriter.endDocument();
            XSLT.this.step.reportError(treeWriter.getResult());
            XSLT.this.step.info(XSLT.this.step.getNode(), xdmNode.toString());
        }
    }

    class OutputResolver
    implements OutputURIResolver {
        public OutputURIResolver newInstance() {
            return new OutputResolver();
        }

        public Result resolve(String string, String string2) throws TransformerException {
            URI uRI = null;
            try {
                uRI = new URI(string2);
                uRI = uRI.resolve(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new XProcException(uRISyntaxException);
            }
            XSLT.this.finest(XSLT.this.step.getNode(), "XSLT secondary result document: " + uRI);
            try {
                XdmDestination xdmDestination = new XdmDestination();
                XSLT.this.secondaryResults.put(uRI.toASCIIString(), xdmDestination);
                Receiver receiver = xdmDestination.getReceiver(XSLT.this.runtime.getProcessor().getUnderlyingConfiguration());
                receiver.setSystemId(uRI.toASCIIString());
                return receiver;
            }
            catch (SaxonApiException saxonApiException) {
                throw new XProcException(saxonApiException);
            }
        }

        public void close(Result result) throws TransformerException {
            String string = result.getSystemId();
            XdmDestination xdmDestination = (XdmDestination)XSLT.this.secondaryResults.get(string);
            XdmNode xdmNode = xdmDestination.getXdmNode();
            XSLT.this.secondaryPipe.write(xdmNode);
        }
    }
}

