/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.runtime;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.DocumentSequence;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.model.NamespaceBinding;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.runtime.XCompoundStep;
import com.xmlcalabash.runtime.XStep;
import com.xmlcalabash.util.S9apiUtils;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Logger;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.sxpath.IndependentContext;

public class XSelect
implements ReadablePipe {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private ReadablePipe source = null;
    private String select = null;
    private XdmNode context = null;
    private DocumentSequence documents = null;
    private XPathSelector selector = null;
    private XProcRuntime runtime = null;
    private boolean initialized = false;
    private int docindex = 0;
    private Step reader = null;
    private XStep forStep = null;

    public XSelect(XProcRuntime xProcRuntime, XStep xStep, ReadablePipe readablePipe, String string, XdmNode xdmNode) {
        this.source = readablePipe;
        this.select = string;
        this.runtime = xProcRuntime;
        this.context = xdmNode;
        this.documents = new DocumentSequence(xProcRuntime);
        this.forStep = xStep;
    }

    @Override
    public void canReadSequence(boolean bl) {
    }

    @Override
    public boolean readSequence() {
        return true;
    }

    private void readSource() {
        Iterator<Object> iterator;
        XdmDestination xdmDestination;
        Hashtable<Object, Object> hashtable;
        NamespaceBinding namespaceBinding;
        this.initialized = true;
        try {
            namespaceBinding = new NamespaceBinding(this.runtime, this.context);
            XPathCompiler xPathCompiler = this.runtime.getProcessor().newXPathCompiler();
            xPathCompiler.setBaseURI(this.context.getBaseURI());
            IndependentContext independentContext = (IndependentContext)xPathCompiler.getUnderlyingStaticContext();
            hashtable = new Hashtable();
            try {
                hashtable = ((XCompoundStep)this.forStep).getInScopeOptions();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            xdmDestination = new Hashtable();
            for (QName object : hashtable.keySet()) {
                RuntimeValue runtimeValue = (RuntimeValue)hashtable.get(object);
                if (!runtimeValue.initialized()) continue;
                xdmDestination.put(object, runtimeValue);
            }
            for (QName qName : xdmDestination.keySet()) {
                xPathCompiler.declareVariable(qName);
            }
            for (String string : namespaceBinding.getNamespaceBindings().keySet()) {
                xPathCompiler.declareNamespace(string, namespaceBinding.getNamespaceBindings().get(string));
            }
            iterator = xPathCompiler.compile(this.select);
            this.selector = iterator.load();
            for (RuntimeValue runtimeValue : xdmDestination.keySet()) {
                XdmAtomicValue xdmAtomicValue = ((RuntimeValue)xdmDestination.get(runtimeValue)).getUntypedAtomic(this.runtime);
                this.selector.setVariable((QName)runtimeValue, (XdmValue)xdmAtomicValue);
            }
        }
        catch (SaxonApiException saxonApiException) {
            if (S9apiUtils.xpathSyntaxError(saxonApiException)) {
                throw XProcException.dynamicError(23, this.context, "Invalid XPath expression: '" + this.select + "'.");
            }
            throw new XProcException(saxonApiException);
        }
        while (this.source.moreDocuments()) {
            try {
                namespaceBinding = this.source.read();
                if (this.reader != null) {
                    this.runtime.finest(null, this.reader.getNode(), this.reader.getName() + " select read '" + (namespaceBinding == null ? "null" : namespaceBinding.getBaseURI()) + "' from " + this.source);
                }
                this.selector.setContextItem((XdmItem)namespaceBinding);
                for (IndependentContext independentContext : this.selector) {
                    hashtable = null;
                    try {
                        hashtable = (XdmNode)independentContext;
                        if (hashtable.getNodeKind() != XdmNodeKind.ELEMENT && hashtable.getNodeKind() != XdmNodeKind.DOCUMENT) {
                            throw XProcException.dynamicError(16);
                        }
                    }
                    catch (ClassCastException classCastException) {
                        throw XProcException.dynamicError(16);
                    }
                    xdmDestination = new XdmDestination();
                    S9apiUtils.writeXdmValue(this.runtime, hashtable, (Destination)xdmDestination, hashtable.getBaseURI());
                    iterator = xdmDestination.getXdmNode();
                    if (this.reader != null) {
                        this.runtime.finest(null, this.reader.getNode(), this.reader.getName() + " select wrote '" + (iterator == null ? "null" : iterator.getBaseURI()) + "' to " + this.documents);
                    }
                    this.documents.add((XdmNode)iterator);
                }
            }
            catch (SaxonApiException saxonApiException) {
                throw new XProcException(saxonApiException);
            }
        }
    }

    @Override
    public void resetReader() {
        this.docindex = 0;
        this.source.resetReader();
        this.documents.reset();
        this.initialized = false;
    }

    @Override
    public boolean moreDocuments() {
        if (!this.initialized) {
            this.readSource();
        }
        return this.docindex < this.documents.size();
    }

    @Override
    public boolean closed() {
        return true;
    }

    @Override
    public int documentCount() {
        if (!this.initialized) {
            this.readSource();
        }
        return this.documents.size();
    }

    @Override
    public DocumentSequence documents() {
        return this.documents;
    }

    @Override
    public void setReader(Step step) {
        this.reader = step;
    }

    @Override
    public XdmNode read() throws SaxonApiException {
        if (!this.initialized) {
            this.readSource();
        }
        XdmNode xdmNode = null;
        if (this.moreDocuments()) {
            xdmNode = this.documents.get(this.docindex++);
        }
        if (this.reader != null) {
            this.runtime.finest(null, this.reader.getNode(), this.reader.getName() + " read '" + (xdmNode == null ? "null" : xdmNode.getBaseURI()) + "' from " + this);
        }
        return xdmNode;
    }

    public String toString() {
        return "xselect " + this.documents;
    }
}

