/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.runtime;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRunnable;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.model.DeclareStep;
import com.xmlcalabash.model.Input;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.runtime.XCompoundStep;
import com.xmlcalabash.runtime.XInput;
import com.xmlcalabash.runtime.XOutput;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

public abstract class XStep
implements XProcRunnable {
    protected XProcRuntime runtime = null;
    protected Step step = null;
    protected String name = null;
    private Hashtable<String, XInput> xinputs = new Hashtable();
    private Hashtable<String, XOutput> xoutputs = new Hashtable();
    private Hashtable<QName, RuntimeValue> options = new Hashtable();
    private Hashtable<String, Hashtable<QName, RuntimeValue>> parameters = new Hashtable();
    protected XCompoundStep parent = null;
    protected Logger logger = Logger.getLogger(this.getClass().getName());
    protected Hashtable<QName, RuntimeValue> inScopeOptions = new Hashtable();

    public XStep(XProcRuntime xProcRuntime, Step step) {
        this.runtime = xProcRuntime;
        this.step = step;
        if (step != null) {
            this.name = step.getName();
        }
    }

    public Step getStep() {
        return this.step;
    }

    public XdmNode getNode() {
        return this.step.getNode();
    }

    public QName getType() {
        return this.step.getNode().getNodeName();
    }

    public String getName() {
        return this.name;
    }

    public DeclareStep getDeclareStep() {
        return this.step.getDeclaration();
    }

    public XCompoundStep getParent() {
        return this.parent;
    }

    public void addInput(XInput xInput) {
        String string = xInput.getPort();
        if (this.xinputs.containsKey(string)) {
            throw new XProcException(xInput.getNode(), "Attempt to add output '" + string + "' port to the same step twice.");
        }
        this.xinputs.put(string, xInput);
    }

    public void addOutput(XOutput xOutput) {
        String string = xOutput.getPort();
        if (this.xoutputs.containsKey(string)) {
            throw new XProcException(xOutput.getNode(), "Attempt to add output '" + string + "' port to the same step twice.");
        }
        this.xoutputs.put(string, xOutput);
    }

    public XInput getInput(String string) {
        if (this.xinputs.containsKey(string)) {
            return this.xinputs.get(string);
        }
        throw new XProcException(this.step.getNode(), "Attempt to get non-existant input '" + string + "' port from step.");
    }

    public XOutput getOutput(String string) {
        if (this.xoutputs.containsKey(string)) {
            return this.xoutputs.get(string);
        }
        if ("http://www.w3.org/ns/xproc".equals(this.step.getType().getNamespaceURI()) && this.step.getStep().getVersion() > 1.0) {
            return null;
        }
        throw new XProcException(this.step.getNode(), "Attempt to get non-existant output '" + string + "' port from step.");
    }

    public void setParameter(QName qName, RuntimeValue runtimeValue) {
        Set<String> set = this.getParameterPorts();
        int n = 0;
        String string = null;
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2;
            string = string2 = iterator.next();
            ++n;
        }
        if (n == 0) {
            throw new XProcException(this.step.getNode(), "Attempt to set parameter but there's no parameter port.");
        }
        if (n > 1) {
            throw new XProcException(this.step.getNode(), "Attempt to set parameter w/o specifying a port (and there's more than one)");
        }
        this.setParameter(string, qName, runtimeValue);
    }

    public void setParameter(String string, QName qName, RuntimeValue runtimeValue) {
        Hashtable<Object, Object> hashtable;
        if (this.parameters.containsKey(string)) {
            hashtable = this.parameters.get(string);
        } else {
            hashtable = new Hashtable();
            this.parameters.put(string, hashtable);
        }
        if (hashtable.containsKey(qName)) {
            throw new XProcException(this.step.getNode(), "Duplicate parameter: " + qName);
        }
        if ("http://www.w3.org/ns/xproc".equals(qName.getNamespaceURI())) {
            throw XProcException.dynamicError(31);
        }
        hashtable.put(qName, runtimeValue);
    }

    public Set<QName> getOptions() {
        return this.options.keySet();
    }

    public RuntimeValue getOption(QName qName) {
        if (this.options.containsKey(qName)) {
            return this.options.get(qName);
        }
        return null;
    }

    public void setOption(QName qName, RuntimeValue runtimeValue) {
        if (this.options.containsKey(qName)) {
            throw new XProcException(this.step.getNode(), "Duplicate option: " + qName);
        }
        this.options.put(qName, runtimeValue);
    }

    public void clearOptions() {
        this.options.clear();
    }

    public void clearParameters() {
        this.parameters.clear();
    }

    public Set<QName> getParameters() {
        return this.getParameters("*");
    }

    public RuntimeValue getParameter(QName qName) {
        Set<String> set = this.getParameterPorts();
        int n = 0;
        String string = null;
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2;
            string = string2 = iterator.next();
            ++n;
        }
        if (n != 1) {
            return null;
        }
        return this.getParameter(string, qName);
    }

    public Set<String> getParameterPorts() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Input input : this.step.inputs()) {
            if (!input.getParameterInput()) continue;
            hashSet.add(input.getPort());
        }
        return hashSet;
    }

    public Set<QName> getParameters(String string) {
        if (this.parameters.containsKey(string)) {
            return this.parameters.get(string).keySet();
        }
        return new HashSet<QName>();
    }

    public RuntimeValue getParameter(String string, QName qName) {
        Hashtable<QName, RuntimeValue> hashtable;
        if (this.parameters.containsKey(string) && (hashtable = this.parameters.get(string)).containsKey(qName)) {
            return hashtable.get(qName);
        }
        return null;
    }

    public String getExtensionAttribute(QName qName) {
        if (this.step != null) {
            return this.step.getExtensionAttribute(qName);
        }
        return null;
    }

    public String getInheritedExtensionAttribute(QName qName) {
        if (this.getExtensionAttribute(qName) != null) {
            return this.getExtensionAttribute(qName);
        }
        if (this.parent != null) {
            return this.parent.getInheritedExtensionAttribute(qName);
        }
        return null;
    }

    public boolean hasInScopeVariableBinding(QName qName) {
        if (this.inScopeOptions.containsKey(qName)) {
            return true;
        }
        return this.getParent() == null ? false : this.getParent().hasInScopeVariableBinding(qName);
    }

    public boolean hasInScopeVariableValue(QName qName) {
        if (this.inScopeOptions.containsKey(qName)) {
            RuntimeValue runtimeValue = this.getOption(qName);
            return runtimeValue.initialized();
        }
        return this.getParent() == null ? false : this.getParent().hasInScopeVariableBinding(qName);
    }

    public Hashtable<QName, RuntimeValue> getInScopeOptions() {
        Hashtable<QName, RuntimeValue> hashtable = new Hashtable<QName, RuntimeValue>();
        if (this.inScopeOptions != null) {
            for (QName qName : this.inScopeOptions.keySet()) {
                hashtable.put(qName, this.inScopeOptions.get(qName));
            }
        }
        return hashtable;
    }

    public abstract RuntimeValue optionAvailable(QName var1);

    public abstract void instantiate(Step var1);

    @Override
    public abstract void reset();

    @Override
    public abstract void run() throws SaxonApiException;

    public void error(XdmNode xdmNode, String string, QName qName) {
        this.runtime.error(this, xdmNode, string, qName);
    }

    public void warning(XdmNode xdmNode, String string) {
        this.runtime.warning(this, xdmNode, string);
    }

    public void info(XdmNode xdmNode, String string) {
        this.runtime.info(this, xdmNode, string);
    }

    public void fine(XdmNode xdmNode, String string) {
        this.runtime.fine(this, xdmNode, string);
    }

    public void finer(XdmNode xdmNode, String string) {
        this.runtime.finer(this, xdmNode, string);
    }

    public void finest(XdmNode xdmNode, String string) {
        this.runtime.finest(this, xdmNode, string);
    }
}

