/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.princexml.Prince;
import com.princexml.PrinceEvents;
import com.xmlcalabash.config.CssProcessor;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.runtime.XStep;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.S9apiUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Properties;
import java.util.Vector;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;

public class CssPrince
implements CssProcessor {
    private static final QName _content_type = new QName("content-type");
    private static final QName _encoding = new QName("", "encoding");
    XProcRuntime runtime = null;
    Properties options = null;
    String primarySS = null;
    Vector<String> userSS = new Vector();
    XStep step = null;
    Prince prince = null;

    @Override
    public void initialize(XProcRuntime xProcRuntime, XStep xStep, Properties properties) {
        Integer n;
        Boolean bl;
        this.runtime = xProcRuntime;
        this.step = xStep;
        this.options = properties;
        String string = this.getStringProp("exePath");
        if (string == null) {
            string = System.getProperty("com.xmlcalabash.css.prince.exepath");
        }
        if (string == null || "".equals(string)) {
            throw new XProcException("Attempt to use Prince as CSS formater but no Prince exePath specified");
        }
        this.prince = new Prince(string, (PrinceEvents)new PrinceMessages());
        String string2 = this.getStringProp("baseURL");
        if (string2 != null) {
            this.prince.setBaseURL(string2);
        }
        if ((bl = this.getBooleanProp("compress")) != null) {
            this.prince.setCompress(bl.booleanValue());
        }
        if ((bl = this.getBooleanProp("debug")) != null) {
            this.prince.setDebug(bl.booleanValue());
        }
        if ((bl = this.getBooleanProp("embedFonts")) != null) {
            this.prince.setEmbedFonts(bl.booleanValue());
        }
        if ((bl = this.getBooleanProp("encrypt")) != null) {
            this.prince.setEncrypt(bl.booleanValue());
        }
        if ((n = this.getIntProp("keyBits")) != null) {
            String[] stringArray = this.getStringProp("userPassword");
            String string3 = this.getStringProp("ownerPassword");
            bl = this.getBooleanProp("disallowPrint");
            int n2 = bl == null ? 0 : bl;
            bl = this.getBooleanProp("disallowModify");
            boolean bl2 = bl == null ? false : bl;
            bl = this.getBooleanProp("disallowCopy");
            boolean bl3 = bl == null ? false : bl;
            bl = this.getBooleanProp("disallowAnnotate");
            boolean bl4 = bl == null ? false : bl;
            this.prince.setEncryptInfo(n.intValue(), (String)stringArray, string3, n2 != 0, bl2, bl3, bl4);
        }
        if ((string2 = this.getStringProp("fileRoot")) != null) {
            this.prince.setFileRoot(string2);
        }
        if ((bl = this.getBooleanProp("html")) != null) {
            this.prince.setHTML(bl.booleanValue());
        }
        if ((string2 = this.getStringProp("httpPassword")) != null) {
            this.prince.setHttpPassword(string2);
        }
        if ((string2 = this.getStringProp("httpUsername")) != null) {
            this.prince.setHttpUsername(string2);
        }
        if ((string2 = this.getStringProp("httpProxy")) != null) {
            this.prince.setHttpProxy(string2);
        }
        if ((string2 = this.getStringProp("inputType")) != null) {
            this.prince.setInputType(string2);
        }
        if ((bl = this.getBooleanProp("javascript")) != null) {
            this.prince.setJavaScript(bl.booleanValue());
        }
        if ((string2 = this.getStringProp("log")) != null) {
            this.prince.setLog(string2);
        }
        if ((bl = this.getBooleanProp("network")) != null) {
            this.prince.setNetwork(bl.booleanValue());
        }
        if ((bl = this.getBooleanProp("subsetFonts")) != null) {
            this.prince.setSubsetFonts(bl.booleanValue());
        }
        if ((bl = this.getBooleanProp("verbose")) != null) {
            this.prince.setVerbose(bl.booleanValue());
        }
        if ((bl = this.getBooleanProp("XInclude")) != null) {
            this.prince.setXInclude(bl.booleanValue());
        }
        if ((string2 = this.getStringProp("scripts")) != null) {
            for (String string4 : string2.split("\\s+")) {
                this.prince.addScript(string4);
            }
        }
    }

    @Override
    public void addStylesheet(XdmNode xdmNode) {
        File file;
        Object object;
        xdmNode = S9apiUtils.getDocumentElement(xdmNode);
        String string = null;
        if (XProcConstants.c_data.equals((Object)xdmNode.getNodeName()) && "application/octet-stream".equals(xdmNode.getAttributeValue(_content_type)) || "base64".equals(xdmNode.getAttributeValue(_encoding))) {
            object = Base64.decode(xdmNode.getStringValue());
            string = new String((byte[])object);
        } else {
            string = xdmNode.getStringValue();
        }
        object = "temp";
        String string2 = ".css";
        try {
            file = File.createTempFile((String)object, string2);
        }
        catch (IOException iOException) {
            throw new XProcException(this.step.getNode(), "Failed to create temporary file for CSS");
        }
        file.deleteOnExit();
        try {
            PrintStream printStream = new PrintStream(file);
            printStream.print(string);
            printStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new XProcException(this.step.getNode(), "Failed to write to temporary CSS file");
        }
        if (this.primarySS == null) {
            this.primarySS = file.toURI().toASCIIString();
        } else {
            this.userSS.add(file.toURI().toASCIIString());
        }
    }

    @Override
    public void format(XdmNode xdmNode, OutputStream outputStream, String string) {
        if (string != null && !"application/pdf".equals(string)) {
            throw new XProcException(this.step.getNode(), "Unsupported content-type on p:css-formatter: " + string);
        }
        try {
            if (this.primarySS != null) {
                this.prince.addStyleSheet(this.primarySS);
            }
            for (String string2 : this.userSS) {
                this.prince.addStyleSheet(string2);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdmNode.toString().getBytes("UTF-8"));
            this.prince.convert((InputStream)byteArrayInputStream, outputStream);
        }
        catch (IOException iOException) {
            if (this.runtime.getDebug()) {
                iOException.printStackTrace();
            }
            throw new XProcException(iOException);
        }
    }

    private String getStringProp(String string) {
        return this.options.getProperty(string);
    }

    private Integer getIntProp(String string) {
        String string2 = this.getStringProp(string);
        if (string2 != null) {
            try {
                int n = Integer.parseInt(string2);
                return new Integer(n);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return null;
    }

    private Boolean getBooleanProp(String string) {
        String string2 = this.options.getProperty(string);
        if (string2 != null) {
            return "true".equals(string2);
        }
        return null;
    }

    private class PrinceMessages
    implements PrinceEvents {
        private PrinceMessages() {
        }

        public void onMessage(String string, String string2, String string3) {
            if ("inf".equals(string)) {
                CssPrince.this.step.info(CssPrince.this.step.getNode(), string3);
            } else if ("wrn".equals(string)) {
                CssPrince.this.step.warning(CssPrince.this.step.getNode(), string3);
            } else {
                CssPrince.this.step.error(CssPrince.this.step.getNode(), string3, new QName("http://xproc.org/ns/errors", "prince"));
            }
        }
    }
}

