/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import java.io.InputStream;

public class Input {
    private String uri;
    private InputStream inputStream;
    private Type type;
    private String contentType;
    private Kind kind = Kind.NONE;

    public Input(String string) {
        this(string, Type.XML);
    }

    public Input(String string, Type type) {
        this(string, type, null);
    }

    public Input(String string, Type type, String string2) {
        this.uri = string;
        this.type = type;
        this.contentType = string2;
        this.kind = Kind.URI;
    }

    public Input(InputStream inputStream, String string) {
        this(inputStream, string, Type.XML);
    }

    public Input(InputStream inputStream, String string, Type type) {
        this(inputStream, string, type, null);
    }

    public Input(InputStream inputStream, String string, Type type, String string2) {
        this(string, type, string2);
        this.inputStream = inputStream;
        this.kind = Kind.INPUT_STREAM;
    }

    public String getUri() {
        if (this.kind != Kind.URI) {
            throw new IllegalArgumentException("Input is not of kind 'URI'");
        }
        return this.uri;
    }

    public InputStream getInputStream() {
        if (this.kind != Kind.INPUT_STREAM) {
            throw new IllegalArgumentException("Input is not of kind 'INPUT_STREAM'");
        }
        return this.inputStream;
    }

    public String getInputStreamUri() {
        if (this.kind != Kind.INPUT_STREAM) {
            throw new IllegalArgumentException("Input is not of kind 'INPUT_STREAM'");
        }
        return this.uri;
    }

    public Type getType() {
        return this.type;
    }

    public String getContentType() {
        if (this.contentType != null && this.type != Type.DATA) {
            throw new IllegalStateException("contentType of input can only be set if type is DATA");
        }
        return this.contentType;
    }

    public Kind getKind() {
        return this.kind;
    }

    public static enum Kind {
        NONE,
        URI,
        INPUT_STREAM;

    }

    public static enum Type {
        XML,
        DATA;

    }
}

