/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.util.Input;
import com.xmlcalabash.util.UserArgs;

public class ParseArgs {
    private String[] args = null;
    private int argpos = 0;
    private String arg = null;
    private UserArgs userArgs = new UserArgs();

    public UserArgs parse(String[] stringArray) {
        Object object;
        this.args = stringArray;
        this.argpos = 0;
        while (this.arg != null || this.argpos < stringArray.length) {
            Object object2;
            if (this.arg == null) {
                this.arg = stringArray[this.argpos];
            }
            if (this.arg.startsWith("-P") || this.arg.startsWith("--saxon-processor")) {
                this.userArgs.setSaxonProcessor(this.parseString("P", "saxon-processor"));
                continue;
            }
            if (this.arg.startsWith("--saxon-configuration")) {
                this.userArgs.setSaxonConfig(this.parseString(null, "saxon-configuration"));
                continue;
            }
            if (this.arg.startsWith("-a") || this.arg.startsWith("--schema-aware")) {
                this.userArgs.setSchemaAware(this.parseBoolean("a", "schema-aware"));
                continue;
            }
            if (this.arg.startsWith("-D") || this.arg.startsWith("--debug")) {
                this.userArgs.setDebug(this.parseBoolean("D", "debug"));
                continue;
            }
            if (this.arg.startsWith("--profile")) {
                this.userArgs.setProfile(this.parseString(null, "profile"));
                continue;
            }
            if (this.arg.startsWith("-S") || this.arg.startsWith("--safe-mode")) {
                this.userArgs.setSafeMode(this.parseBoolean("S", "safe-mode"));
                continue;
            }
            if (this.arg.startsWith("-c") || this.arg.startsWith("--config")) {
                this.userArgs.setConfig(this.parseString("c", "config"));
                continue;
            }
            if (this.arg.startsWith("-G") || this.arg.startsWith("--log-style")) {
                this.userArgs.setLogStyle(this.parseString("G", "log-style"));
                continue;
            }
            if (this.arg.startsWith("-E") || this.arg.startsWith("--entity-resolver")) {
                this.userArgs.setEntityResolverClass(this.parseString("E", "entity-resolver"));
                continue;
            }
            if (this.arg.startsWith("-U") || this.arg.startsWith("--uri-resolver")) {
                this.userArgs.setUriResolverClass(this.parseString("U", "uri-resolver"));
                continue;
            }
            if (this.arg.startsWith("-i") || this.arg.equals("--input")) {
                object = this.parseString("i", "input");
                if (((String)object).contains("=")) {
                    object2 = this.parseOption((String)object);
                    this.userArgs.addInput(((KeyValuePair)object2).key, ((KeyValuePair)object2).value, Input.Type.XML);
                    continue;
                }
                this.userArgs.addInput(null, (String)object, Input.Type.XML);
                continue;
            }
            if (this.arg.startsWith("-d") || this.arg.equals("--data-input")) {
                KeyValuePair keyValuePair;
                object = this.parseString("d", "data-input");
                object2 = null;
                if (((String)object).contains("@")) {
                    keyValuePair = this.parseOption((String)object, "@");
                    object2 = keyValuePair.key;
                    object = keyValuePair.value;
                }
                if (((String)object).contains("=")) {
                    keyValuePair = this.parseOption((String)object);
                    this.userArgs.addInput(keyValuePair.key, keyValuePair.value, Input.Type.DATA, (String)object2);
                    continue;
                }
                this.userArgs.addInput(null, (String)object, Input.Type.DATA, (String)object2);
                continue;
            }
            if (this.arg.startsWith("-o") || this.arg.equals("--output")) {
                object = this.parseString("o", "output");
                if (((String)object).contains("=")) {
                    object2 = this.parseOption((String)object);
                    this.userArgs.addOutput(((KeyValuePair)object2).key, ((KeyValuePair)object2).value);
                    continue;
                }
                this.userArgs.addOutput(null, (String)object);
                continue;
            }
            if (this.arg.startsWith("-b") || this.arg.equals("--binding")) {
                object = this.parseKeyValue("b", "binding");
                this.userArgs.addBinding(((KeyValuePair)object).key, ((KeyValuePair)object).value);
                continue;
            }
            if (this.arg.startsWith("-p") || this.arg.equals("--with-param")) {
                object = this.parseKeyValue("p", "with-param");
                this.userArgs.addParam(((KeyValuePair)object).key, ((KeyValuePair)object).value);
                continue;
            }
            if (this.arg.startsWith("-v") || this.arg.equals("--version")) {
                this.userArgs.setShowVersion(this.parseBoolean("v", "version"));
                continue;
            }
            if (this.arg.startsWith("-s") || this.arg.startsWith("--step")) {
                this.userArgs.setCurStepName(this.parseString("s", "step"));
                continue;
            }
            if (this.arg.startsWith("-l") || this.arg.startsWith("--library")) {
                this.userArgs.addLibrary(this.parseString("l", "library"));
                continue;
            }
            if (this.arg.startsWith("-X") || this.arg.startsWith("--extension")) {
                object = this.parseString("X", "extension");
                if ("general-values".equals(object)) {
                    this.userArgs.setExtensionValues(true);
                    continue;
                }
                if ("xpointer-on-text".equals(object)) {
                    this.userArgs.setAllowXPointerOnText(true);
                    continue;
                }
                if ("use-xslt-1.0".equals(object) || "use-xslt-10".equals(object)) {
                    this.userArgs.setUseXslt10(true);
                    continue;
                }
                if ("transparent-json".equals(object)) {
                    this.userArgs.setTransparentJSON(true);
                    continue;
                }
                if (((String)object).startsWith("json-flavor=")) {
                    this.userArgs.setJsonFlavor(((String)object).substring(12));
                    continue;
                }
                throw new XProcException("Unexpected extension: " + (String)object);
            }
            if (this.arg.startsWith("-")) {
                throw new XProcException("Unrecognized option: '" + this.arg + "'.");
            }
            if (!this.arg.contains("=")) break;
            object = this.parseOption(this.arg);
            this.userArgs.addOption(((KeyValuePair)object).key, ((KeyValuePair)object).value);
            this.arg = null;
            ++this.argpos;
        }
        if (this.argpos < stringArray.length) {
            this.userArgs.setPipeline(stringArray[this.argpos++]);
        }
        while (this.argpos < stringArray.length) {
            if (stringArray[this.argpos].startsWith("-")) {
                throw new XProcException("Only options can occur on the command line after the pipeline document.");
            }
            object = this.parseOption(stringArray[this.argpos++]);
            this.userArgs.addOption(((KeyValuePair)object).key, ((KeyValuePair)object).value);
        }
        this.userArgs.checkArgs();
        return this.userArgs;
    }

    private boolean parseBoolean(String string, String string2) {
        String string3 = "-" + string;
        String string4 = "--" + string2;
        boolean bl = false;
        if (this.arg.startsWith(string3)) {
            bl = true;
            if (this.arg.equals(string3)) {
                this.arg = null;
                ++this.argpos;
            } else {
                this.arg = "-" + this.arg.substring(2);
            }
            return bl;
        }
        if (this.arg.equals(string4)) {
            bl = true;
            this.arg = null;
            ++this.argpos;
            return bl;
        }
        if (this.arg.startsWith(string4 + "=")) {
            this.arg = this.arg.substring(string4.length() + 1);
            if (!this.arg.equals("true") && !this.arg.equals("false")) {
                throw new XProcException("Unparseable command line argument: " + string4 + "=" + this.arg);
            }
            bl = this.arg.equals("true");
            this.arg = null;
            ++this.argpos;
            return bl;
        }
        throw new XProcException("Unparseable command line argument: " + this.arg);
    }

    private String parseString(String string, String string2) {
        String string3;
        String string4 = null;
        if (string != null && this.arg.startsWith(string3 = "-" + string)) {
            if (this.arg.equals(string3)) {
                string4 = this.args[++this.argpos];
                this.arg = null;
                ++this.argpos;
            } else {
                string4 = this.arg.substring(2);
                this.arg = null;
                ++this.argpos;
            }
            return string4;
        }
        string3 = "--" + string2;
        if (this.arg.equals(string3)) {
            string4 = this.args[++this.argpos];
            this.arg = null;
            ++this.argpos;
            return string4;
        }
        if (this.arg.startsWith(string3 + "=")) {
            string4 = this.arg.substring(string3.length() + 1);
            this.arg = null;
            ++this.argpos;
            return string4;
        }
        throw new XProcException("Unparseable command line argument: " + this.arg);
    }

    private KeyValuePair parseKeyValue(String string, String string2) {
        String string3 = "-" + (string == null ? "" : string);
        String string4 = "--" + string2;
        String string5 = null;
        if (string != null && this.arg.startsWith(string3)) {
            if (this.arg.equals(string3)) {
                string5 = this.args[++this.argpos];
                this.arg = null;
                ++this.argpos;
            } else {
                string5 = this.arg.substring(2);
                this.arg = null;
                ++this.argpos;
            }
        } else if (this.arg.equals(string4)) {
            string5 = this.args[++this.argpos];
            this.arg = null;
            ++this.argpos;
        } else {
            throw new XProcException("Unparseable command line argument: '" + this.arg + "'.");
        }
        return this.parseOption(string5);
    }

    private KeyValuePair parseOption(String string) {
        return this.parseOption(string, "=");
    }

    private KeyValuePair parseOption(String string, String string2) {
        String string3 = null;
        String string4 = null;
        int n = string.indexOf(string2);
        if (n <= 0) {
            throw new XProcException("Unparseable command line argument: '" + string + "'.");
        }
        string3 = string.substring(0, n);
        string4 = string.substring(n + 1);
        return new KeyValuePair(string3, string4);
    }

    private class KeyValuePair {
        public String key = null;
        public String value = null;

        public KeyValuePair(String string, String string2) {
            this.key = string;
            this.value = string2;
        }
    }
}

