/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.util.S9apiUtils;
import java.util.Iterator;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SaxonApiUncheckedException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.trans.XPathException;

public class RelevantNodes
implements Iterable<XdmNode> {
    private static QName use_when = new QName("", "use-when");
    private static QName p_use_when = new QName("http://www.w3.org/ns/xproc", "use-when");
    private RelevantNodesIter iter = null;
    private XProcRuntime runtime = null;

    public RelevantNodes(XProcRuntime xProcRuntime, XdmNode xdmNode, Axis axis) {
        this.runtime = xProcRuntime;
        this.iter = new RelevantNodesIter(xdmNode, axis);
    }

    public RelevantNodes(XdmNode xdmNode, Axis axis, boolean bl) {
        this.iter = new RelevantNodesIter(xdmNode, axis, bl);
    }

    public RelevantNodes(XdmNode xdmNode, QName qName) {
        this.iter = new RelevantNodesIter(xdmNode, Axis.CHILD, qName);
    }

    @Override
    public Iterator<XdmNode> iterator() {
        return this.iter;
    }

    private class RelevantNodesIter
    implements Iterator<XdmNode> {
        private XdmSequenceIterator iter = null;
        private XdmNode next = null;
        private boolean finished = false;
        private QName onlyMatch = null;
        private boolean ignoreInfo = true;

        public RelevantNodesIter(XdmNode xdmNode, Axis axis) {
            this.iter = xdmNode.axisIterator(axis);
        }

        public RelevantNodesIter(XdmNode xdmNode, Axis axis, boolean bl) {
            this.ignoreInfo = bl;
            this.iter = xdmNode.axisIterator(axis);
        }

        public RelevantNodesIter(XdmNode xdmNode, Axis axis, QName qName) {
            this.iter = xdmNode.axisIterator(axis);
            this.onlyMatch = qName;
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                boolean bl = this.iter.hasNext();
                boolean bl2 = this.finished = this.finished || !bl;
                if (this.finished) {
                    return false;
                }
                this.next = (XdmNode)this.iter.next();
                while (this.next != null && !this.ok(this.next)) {
                    if (this.iter.hasNext()) {
                        this.next = (XdmNode)this.iter.next();
                        continue;
                    }
                    this.next = null;
                }
                return this.ok(this.next);
            }
            return true;
        }

        @Override
        public XdmNode next() {
            XdmNode xdmNode = this.next;
            this.next = null;
            return xdmNode;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported!");
        }

        private boolean ok(XdmNode xdmNode) {
            if (xdmNode == null || this.ignoreInfo && (XProcConstants.p_documentation.equals((Object)xdmNode.getNodeName()) || XProcConstants.p_pipeinfo.equals((Object)xdmNode.getNodeName()))) {
                return false;
            }
            if (xdmNode.getNodeKind() == XdmNodeKind.COMMENT || xdmNode.getNodeKind() == XdmNodeKind.PROCESSING_INSTRUCTION) {
                return false;
            }
            if (xdmNode.getNodeKind() == XdmNodeKind.TEXT) {
                return !"".equals(xdmNode.toString().trim());
            }
            if (xdmNode.getNodeKind() == XdmNodeKind.ELEMENT) {
                if ("http://www.w3.org/ns/xproc".equals(xdmNode.getNodeName().getNamespaceURI()) && xdmNode.getAttributeValue(use_when) != null || !"http://www.w3.org/ns/xproc".equals(xdmNode.getNodeName().getNamespaceURI()) && xdmNode.getAttributeValue(p_use_when) != null) {
                    String string = xdmNode.getAttributeValue(use_when);
                    if (!"http://www.w3.org/ns/xproc".equals(xdmNode.getNodeName().getNamespaceURI())) {
                        string = xdmNode.getAttributeValue(p_use_when);
                    }
                    return this.useWhen(xdmNode, string);
                }
                return this.onlyMatch == null || this.onlyMatch.equals((Object)xdmNode.getNodeName());
            }
            if (xdmNode.getNodeKind() == XdmNodeKind.ATTRIBUTE) {
                return this.onlyMatch == null || this.onlyMatch.equals((Object)xdmNode.getNodeName());
            }
            return false;
        }

        private boolean useWhen(XdmNode xdmNode, String string) {
            boolean bl = false;
            if (RelevantNodes.this.runtime == null) {
                return true;
            }
            try {
                XdmNode xdmNode2;
                XPathCompiler xPathCompiler = RelevantNodes.this.runtime.getProcessor().newXPathCompiler();
                XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.NAMESPACE);
                while (xdmSequenceIterator.hasNext()) {
                    xdmNode2 = (XdmNode)xdmSequenceIterator.next();
                    xPathCompiler.declareNamespace(xdmNode2.getNodeName().getLocalName(), xdmNode2.getStringValue());
                }
                xdmNode2 = null;
                xdmNode2 = xPathCompiler.compile(string);
                XPathSelector xPathSelector = xdmNode2.load();
                try {
                    bl = xPathSelector.effectiveBooleanValue();
                }
                catch (SaxonApiUncheckedException saxonApiUncheckedException) {
                    Throwable throwable = saxonApiUncheckedException.getCause();
                    if (throwable instanceof XPathException) {
                        XPathException xPathException = (XPathException)throwable;
                        if ("http://www.w3.org/2005/xqt-errors".equals(xPathException.getErrorCodeNamespace()) && "XPDY0002".equals(xPathException.getErrorCodeLocalPart())) {
                            throw XProcException.dynamicError(26, xdmNode, "Expression refers to context when none is available: " + string);
                        }
                        throw saxonApiUncheckedException;
                    }
                    throw saxonApiUncheckedException;
                }
            }
            catch (SaxonApiException saxonApiException) {
                if (S9apiUtils.xpathSyntaxError(saxonApiException)) {
                    throw XProcException.dynamicError(23, xdmNode, saxonApiException.getCause().getMessage());
                }
                throw new XProcException(saxonApiException);
            }
            return bl;
        }
    }
}

