/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.util.RelevantNodes;
import com.xmlcalabash.util.TreeWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.lib.ModuleURIResolver;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XQueryEvaluator;
import net.sf.saxon.s9api.XQueryExecutable;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.NamespaceIterator;
import org.xml.sax.InputSource;

public class S9apiUtils {
    private static final QName vara = new QName("", "vara");
    private static final QName varb = new QName("", "varb");

    public static void writeXdmValue(XProcRuntime xProcRuntime, Vector<XdmValue> vector, Destination destination, URI uRI) throws SaxonApiException {
        S9apiUtils.writeXdmValue(xProcRuntime.getProcessor(), vector, destination, uRI);
    }

    public static void writeXdmValue(Processor processor, Vector<XdmValue> vector, Destination destination, URI uRI) throws SaxonApiException {
        try {
            Configuration configuration = processor.getUnderlyingConfiguration();
            PipelineConfiguration pipelineConfiguration = configuration.makePipelineConfiguration();
            Receiver receiver = destination.getReceiver(configuration);
            receiver = new NamespaceReducer(receiver);
            TreeReceiver treeReceiver = new TreeReceiver(receiver);
            treeReceiver.setPipelineConfiguration(pipelineConfiguration);
            if (uRI != null) {
                treeReceiver.setSystemId(uRI.toASCIIString());
            }
            treeReceiver.open();
            treeReceiver.startDocument(0);
            for (XdmValue xdmValue : vector) {
                for (XdmItem xdmItem : xdmValue) {
                    treeReceiver.append((Item)xdmItem.getUnderlyingValue(), 0, 2);
                }
            }
            treeReceiver.endDocument();
            treeReceiver.close();
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException((Throwable)xPathException);
        }
    }

    public static void writeXdmValue(XProcRuntime xProcRuntime, XdmItem xdmItem, Destination destination, URI uRI) throws SaxonApiException {
        try {
            Processor processor = xProcRuntime.getProcessor();
            Configuration configuration = processor.getUnderlyingConfiguration();
            PipelineConfiguration pipelineConfiguration = configuration.makePipelineConfiguration();
            Receiver receiver = destination.getReceiver(configuration);
            receiver = new NamespaceReducer(receiver);
            TreeReceiver treeReceiver = new TreeReceiver(receiver);
            treeReceiver.setPipelineConfiguration(pipelineConfiguration);
            if (uRI != null) {
                treeReceiver.setSystemId(uRI.toASCIIString());
            }
            treeReceiver.open();
            treeReceiver.startDocument(0);
            treeReceiver.append((Item)xdmItem.getUnderlyingValue(), 0, 2);
            treeReceiver.endDocument();
            treeReceiver.close();
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException((Throwable)xPathException);
        }
    }

    public static XdmNode getDocumentElement(XdmNode xdmNode) {
        if (xdmNode.getNodeKind() == XdmNodeKind.DOCUMENT) {
            for (XdmNode xdmNode2 : new RelevantNodes(xdmNode, Axis.CHILD, true)) {
                if (xdmNode2.getNodeKind() != XdmNodeKind.ELEMENT) continue;
                return xdmNode2;
            }
            return null;
        }
        return xdmNode;
    }

    public static void serialize(XProcRuntime xProcRuntime, XdmNode xdmNode, Serializer serializer) throws SaxonApiException {
        Vector<XdmNode> vector = new Vector<XdmNode>();
        vector.add(xdmNode);
        S9apiUtils.serialize(xProcRuntime, vector, serializer);
    }

    public static void serialize(XProcRuntime xProcRuntime, Vector<XdmNode> vector, Serializer serializer) throws SaxonApiException {
        Processor processor = xProcRuntime.getProcessor();
        XQueryCompiler xQueryCompiler = processor.newXQueryCompiler();
        xQueryCompiler.setModuleURIResolver((ModuleURIResolver)xProcRuntime.getResolver());
        xQueryCompiler.getUnderlyingStaticContext().setSchemaAware(xQueryCompiler.getProcessor().getUnderlyingConfiguration().isLicensedFeature(4));
        XQueryExecutable xQueryExecutable = xQueryCompiler.compile(".");
        XQueryEvaluator xQueryEvaluator = xQueryExecutable.load();
        xQueryEvaluator.setDestination((Destination)serializer);
        for (XdmNode xdmNode : vector) {
            xQueryEvaluator.setContextItem((XdmItem)xdmNode);
            xQueryEvaluator.run();
            serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
        }
    }

    public static boolean xpathEqual(Processor processor, XdmItem xdmItem, XdmItem xdmItem2) {
        try {
            XPathCompiler xPathCompiler = processor.newXPathCompiler();
            xPathCompiler.declareVariable(vara);
            xPathCompiler.declareVariable(varb);
            XPathExecutable xPathExecutable = xPathCompiler.compile("$vara = $varb");
            XPathSelector xPathSelector = xPathExecutable.load();
            xPathSelector.setVariable(vara, (XdmValue)xdmItem);
            xPathSelector.setVariable(varb, (XdmValue)xdmItem2);
            Iterator iterator = xPathSelector.iterator();
            XdmAtomicValue xdmAtomicValue = (XdmAtomicValue)iterator.next();
            boolean bl = xdmAtomicValue.getBooleanValue();
            return bl;
        }
        catch (SaxonApiException saxonApiException) {
            return false;
        }
    }

    public static InputSource xdmToInputSource(XProcRuntime xProcRuntime, XdmNode xdmNode) throws SaxonApiException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Serializer serializer = new Serializer();
        serializer.setOutputStream((OutputStream)byteArrayOutputStream);
        S9apiUtils.serialize(xProcRuntime, xdmNode, serializer);
        InputSource inputSource = new InputSource(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        if (xdmNode.getBaseURI() != null) {
            inputSource.setSystemId(xdmNode.getBaseURI().toASCIIString());
        }
        return inputSource;
    }

    public static HashSet<String> excludeInlinePrefixes(XdmNode xdmNode, String string) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("http://www.w3.org/ns/xproc");
        if (string != null) {
            NodeInfo nodeInfo = xdmNode.getUnderlyingNode();
            InscopeNamespaceResolver inscopeNamespaceResolver = new InscopeNamespaceResolver(nodeInfo);
            boolean bl = false;
            for (String string2 : string.split("\\s+")) {
                boolean bl2 = false;
                if ("#all".equals(string2)) {
                    bl2 = true;
                    bl = true;
                } else if ("#default".equals(string2)) {
                    boolean bl3 = bl2 = inscopeNamespaceResolver.getURIForPrefix("", true) != null;
                    if (bl2) {
                        hashSet.add(inscopeNamespaceResolver.getURIForPrefix("", true));
                    }
                } else {
                    boolean bl4 = bl2 = inscopeNamespaceResolver.getURIForPrefix(string2, false) != null;
                    if (bl2) {
                        hashSet.add(inscopeNamespaceResolver.getURIForPrefix(string2, false));
                    }
                }
                if (bl2) continue;
                throw new XProcException(XProcConstants.staticError(57), xdmNode, "No binding for '" + string2 + ":'");
            }
            if (bl) {
                Iterator iterator = inscopeNamespaceResolver.iteratePrefixes();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    int n = "".equals(string3) ? 1 : 0;
                    hashSet.add(inscopeNamespaceResolver.getURIForPrefix(string3, n != 0));
                }
            }
        }
        return hashSet;
    }

    public static XdmNode removeNamespaces(XProcRuntime xProcRuntime, XdmNode xdmNode, HashSet<String> hashSet, boolean bl) {
        return S9apiUtils.removeNamespaces(xProcRuntime.getProcessor(), xdmNode, hashSet, bl);
    }

    public static XdmNode removeNamespaces(Processor processor, XdmNode xdmNode, HashSet<String> hashSet, boolean bl) {
        TreeWriter treeWriter = new TreeWriter(processor);
        treeWriter.startDocument(xdmNode.getBaseURI());
        S9apiUtils.removeNamespacesWriter(treeWriter, xdmNode, hashSet, bl);
        treeWriter.endDocument();
        return treeWriter.getResult();
    }

    private static void removeNamespacesWriter(TreeWriter treeWriter, XdmNode xdmNode, HashSet<String> hashSet, boolean bl) {
        if (xdmNode.getNodeKind() == XdmNodeKind.DOCUMENT) {
            XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.CHILD);
            while (xdmSequenceIterator.hasNext()) {
                XdmNode xdmNode2 = (XdmNode)xdmSequenceIterator.next();
                S9apiUtils.removeNamespacesWriter(treeWriter, xdmNode2, hashSet, bl);
            }
        } else if (xdmNode.getNodeKind() == XdmNodeKind.ELEMENT) {
            String string;
            NamespaceBinding namespaceBinding;
            boolean bl2 = "".equals(xdmNode.getNodeName().getPrefix()) && !"".equals(xdmNode.getNodeName().getNamespaceURI());
            NodeInfo nodeInfo = xdmNode.getUnderlyingNode();
            int n = 0;
            Iterator iterator = NamespaceIterator.iterateNamespaces((NodeInfo)nodeInfo);
            while (iterator.hasNext()) {
                ++n;
                iterator.next();
            }
            boolean bl3 = false;
            boolean bl4 = false;
            NamespaceBinding namespaceBinding2 = null;
            if (n > 0) {
                namespaceBinding2 = new NamespaceBinding[n];
                int n2 = 0;
                iterator = NamespaceIterator.iterateNamespaces((NodeInfo)nodeInfo);
                while (iterator.hasNext()) {
                    namespaceBinding = (NamespaceBinding)iterator.next();
                    String string2 = namespaceBinding.getPrefix();
                    string = namespaceBinding.getURI();
                    boolean bl5 = hashSet.contains(string);
                    boolean bl6 = bl3 = bl3 || "".equals(string2) && bl5;
                    if ("".equals(string2) && bl2 && bl) {
                        bl5 = false;
                    }
                    boolean bl7 = bl4 = bl4 || bl5;
                    if (bl5) continue;
                    namespaceBinding2[n2++] = namespaceBinding;
                }
                namespaceBinding = new NamespaceBinding[n2];
                for (int i = 0; i < n2; ++i) {
                    namespaceBinding[i] = namespaceBinding2[i];
                }
                namespaceBinding2 = namespaceBinding;
            }
            NameOfNode nameOfNode = new NameOfNode(nodeInfo);
            if (!bl && hashSet.contains((namespaceBinding = nameOfNode.getNamespaceBinding()).getURI())) {
                nameOfNode = new FingerprintedQName("", "", nameOfNode.getLocalPart());
            }
            treeWriter.addStartElement((NodeName)nameOfNode, nodeInfo.getSchemaType(), (NamespaceBinding[])namespaceBinding2);
            if (!bl) {
                namespaceBinding = xdmNode.axisIterator(Axis.ATTRIBUTE);
                while (namespaceBinding.hasNext()) {
                    XdmNode xdmNode3 = (XdmNode)namespaceBinding.next();
                    string = xdmNode3.getNodeName().getNamespaceURI();
                    if (hashSet.contains(string)) {
                        treeWriter.addAttribute(new QName(xdmNode3.getNodeName().getLocalName()), xdmNode3.getStringValue());
                        continue;
                    }
                    treeWriter.addAttribute(xdmNode3);
                }
            } else {
                treeWriter.addAttributes(xdmNode);
            }
            namespaceBinding = xdmNode.axisIterator(Axis.CHILD);
            while (namespaceBinding.hasNext()) {
                XdmNode xdmNode4 = (XdmNode)namespaceBinding.next();
                S9apiUtils.removeNamespacesWriter(treeWriter, xdmNode4, hashSet, bl);
            }
            treeWriter.addEndElement();
        } else {
            treeWriter.addSubtree(xdmNode);
        }
    }

    public static void dumpTree(XdmNode xdmNode, String string) {
        NodeInfo nodeInfo = xdmNode.getUnderlyingNode();
        System.err.println(string);
        System.err.println("Dumping tree: " + nodeInfo.getSystemId() + ", " + xdmNode.getBaseURI());
        XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.CHILD);
        while (xdmSequenceIterator.hasNext()) {
            XdmNode xdmNode2 = (XdmNode)xdmSequenceIterator.next();
            S9apiUtils.dumpTreeNode(xdmNode2, "  ");
        }
    }

    private static void dumpTreeNode(XdmNode xdmNode, String string) {
        if (xdmNode.getNodeKind() == XdmNodeKind.ELEMENT) {
            System.err.println(string + xdmNode.getNodeName() + ": " + xdmNode.getBaseURI());
            XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.CHILD);
            while (xdmSequenceIterator.hasNext()) {
                XdmNode xdmNode2 = (XdmNode)xdmSequenceIterator.next();
                S9apiUtils.dumpTreeNode(xdmNode2, string + "  ");
            }
        } else if (xdmNode.getNodeKind() == XdmNodeKind.TEXT) {
            System.err.println(string + "text: ...");
        }
    }

    public static boolean xpathSyntaxError(SaxonApiException saxonApiException) {
        Throwable throwable = saxonApiException.getCause();
        return throwable != null && throwable instanceof XPathException;
    }

    public static void assertDocument(XdmNode xdmNode) {
        if (xdmNode.getNodeKind() == XdmNodeKind.DOCUMENT) {
            S9apiUtils.assertDocumentContent(xdmNode.axisIterator(Axis.CHILD));
        } else if (xdmNode.getNodeKind() != XdmNodeKind.ELEMENT) {
            throw XProcException.dynamicError(1, "Document root cannot be " + xdmNode.getNodeKind());
        }
    }

    public static void assertDocumentContent(XdmSequenceIterator xdmSequenceIterator) {
        int n = 0;
        while (xdmSequenceIterator.hasNext()) {
            XdmNode xdmNode = (XdmNode)xdmSequenceIterator.next();
            if (xdmNode.getNodeKind() == XdmNodeKind.ELEMENT) {
                if (++n <= 1) continue;
                throw XProcException.dynamicError(1, "Document must have exactly one top-level element");
            }
            if (xdmNode.getNodeKind() == XdmNodeKind.PROCESSING_INSTRUCTION || xdmNode.getNodeKind() == XdmNodeKind.COMMENT) continue;
            if (xdmNode.getNodeKind() == XdmNodeKind.TEXT) {
                if ("".equals(xdmNode.getStringValue().trim())) continue;
                throw XProcException.dynamicError(1, "Only whitespace text nodes can appear at the top level in a document");
            }
            throw XProcException.dynamicError(1, "Document cannot have top level " + xdmNode.getNodeKind());
        }
    }

    public static XdmNode getParent(XdmNode xdmNode) {
        try {
            return xdmNode.getParent();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }
}

