/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.util.XProcLocationProvider;
import java.net.URI;
import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.NamespaceIterator;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class TreeWriter {
    protected static final String logger = "com.xmlcalabash.util";
    protected Controller controller = null;
    protected XProcRuntime runtime = null;
    protected Executable exec = null;
    protected NamePool pool = null;
    protected XdmDestination destination = null;
    protected Receiver receiver = null;
    protected XProcLocationProvider xLocationProvider = null;
    protected boolean seenRoot = false;
    protected boolean inDocument = false;

    public TreeWriter(XProcRuntime xProcRuntime) {
        this.runtime = xProcRuntime;
        this.controller = new Controller(this.runtime.getProcessor().getUnderlyingConfiguration());
        this.pool = this.controller.getNamePool();
        this.xLocationProvider = new XProcLocationProvider();
    }

    public TreeWriter(Processor processor) {
        this.controller = new Controller(processor.getUnderlyingConfiguration());
        this.pool = this.controller.getNamePool();
        this.xLocationProvider = new XProcLocationProvider();
    }

    public XdmNode getResult() {
        return this.destination.getXdmNode();
    }

    public boolean inDocument() {
        return this.inDocument;
    }

    public void startDocument(URI uRI) {
        this.inDocument = true;
        this.seenRoot = false;
        try {
            this.exec = new Executable(this.controller.getConfiguration());
            this.destination = new XdmDestination();
            this.receiver = this.destination.getReceiver(this.controller.getConfiguration());
            this.receiver = new NamespaceReducer(this.receiver);
            PipelineConfiguration pipelineConfiguration = this.controller.makePipelineConfiguration();
            pipelineConfiguration.setLocationProvider((LocationProvider)this.xLocationProvider);
            this.receiver.setPipelineConfiguration(pipelineConfiguration);
            if (uRI != null) {
                this.receiver.setSystemId(uRI.toASCIIString());
            } else {
                this.receiver.setSystemId("http://example.com/");
            }
            this.receiver.open();
            this.receiver.startDocument(0);
        }
        catch (Exception exception) {
            throw new XProcException(exception);
        }
    }

    public void endDocument() {
        try {
            this.receiver.endDocument();
            this.receiver.close();
        }
        catch (XPathException xPathException) {
            throw new XProcException(xPathException);
        }
    }

    public void addSubtree(XdmNode xdmNode) {
        if (xdmNode.getNodeKind() == XdmNodeKind.DOCUMENT) {
            this.writeChildren(xdmNode);
        } else if (xdmNode.getNodeKind() == XdmNodeKind.ELEMENT) {
            this.addStartElement(xdmNode);
            XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.ATTRIBUTE);
            while (xdmSequenceIterator.hasNext()) {
                XdmNode xdmNode2 = (XdmNode)xdmSequenceIterator.next();
                this.addAttribute(xdmNode2, xdmNode2.getStringValue());
            }
            try {
                this.receiver.startContent();
            }
            catch (XPathException xPathException) {
                throw new XProcException(xPathException);
            }
            this.writeChildren(xdmNode);
            this.addEndElement();
        } else if (xdmNode.getNodeKind() == XdmNodeKind.COMMENT) {
            this.addComment(xdmNode.getStringValue());
        } else if (xdmNode.getNodeKind() == XdmNodeKind.TEXT) {
            this.addText(xdmNode.getStringValue());
        } else if (xdmNode.getNodeKind() == XdmNodeKind.PROCESSING_INSTRUCTION) {
            this.addPI(xdmNode.getNodeName().getLocalName(), xdmNode.getStringValue());
        } else {
            throw new UnsupportedOperationException("Unexpected node type");
        }
    }

    protected void writeChildren(XdmNode xdmNode) {
        XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.CHILD);
        while (xdmSequenceIterator.hasNext()) {
            XdmNode xdmNode2 = (XdmNode)xdmSequenceIterator.next();
            this.addSubtree(xdmNode2);
        }
    }

    public void addStartElement(XdmNode xdmNode) {
        NodeInfo nodeInfo = xdmNode.getUnderlyingNode();
        NamespaceBinding[] namespaceBindingArray = null;
        if (this.seenRoot) {
            namespaceBindingArray = nodeInfo.getDeclaredNamespaces(null);
        } else {
            int n = 0;
            Iterator iterator = NamespaceIterator.iterateNamespaces((NodeInfo)nodeInfo);
            while (iterator.hasNext()) {
                ++n;
                iterator.next();
            }
            namespaceBindingArray = new NamespaceBinding[n];
            iterator = NamespaceIterator.iterateNamespaces((NodeInfo)nodeInfo);
            n = 0;
            while (iterator.hasNext()) {
                namespaceBindingArray[n] = (NamespaceBinding)iterator.next();
                ++n;
            }
            this.seenRoot = true;
        }
        URI uRI = xdmNode.getBaseURI();
        this.receiver.setSystemId(uRI.toASCIIString());
        this.addStartElement((NodeName)new NameOfNode(nodeInfo), nodeInfo.getSchemaType(), namespaceBindingArray);
    }

    public void addStartElement(XdmNode xdmNode, QName qName) {
        int n;
        NodeInfo nodeInfo = xdmNode.getUnderlyingNode();
        NamespaceBinding[] namespaceBindingArray = null;
        if (this.seenRoot) {
            namespaceBindingArray = nodeInfo.getDeclaredNamespaces(null);
        } else {
            n = 0;
            Iterator iterator = NamespaceIterator.iterateNamespaces((NodeInfo)nodeInfo);
            while (iterator.hasNext()) {
                ++n;
                iterator.next();
            }
            namespaceBindingArray = new NamespaceBinding[n];
            iterator = NamespaceIterator.iterateNamespaces((NodeInfo)nodeInfo);
            n = 0;
            while (iterator.hasNext()) {
                namespaceBindingArray[n] = (NamespaceBinding)iterator.next();
                ++n;
            }
            this.seenRoot = true;
        }
        if ("".equals(qName.getPrefix())) {
            n = 0;
            for (int i = 0; i < namespaceBindingArray.length; ++i) {
                NamespaceBinding namespaceBinding = namespaceBindingArray[i];
                if ("".equals(namespaceBinding.getPrefix())) continue;
                ++n;
            }
            if (n != namespaceBindingArray.length) {
                NamespaceBinding[] namespaceBindingArray2 = new NamespaceBinding[n];
                int n2 = 0;
                for (int i = 0; i < namespaceBindingArray.length; ++i) {
                    NamespaceBinding namespaceBinding = namespaceBindingArray[i];
                    if ("".equals(namespaceBinding.getPrefix())) continue;
                    namespaceBindingArray2[n2++] = namespaceBinding;
                }
                namespaceBindingArray = namespaceBindingArray2;
            }
        }
        URI uRI = xdmNode.getBaseURI();
        this.receiver.setSystemId(uRI.toASCIIString());
        FingerprintedQName fingerprintedQName = new FingerprintedQName(qName.getPrefix(), qName.getNamespaceURI(), qName.getLocalName());
        this.addStartElement((NodeName)fingerprintedQName, nodeInfo.getSchemaType(), namespaceBindingArray);
    }

    public void addStartElement(QName qName) {
        FingerprintedQName fingerprintedQName = new FingerprintedQName(qName.getPrefix(), qName.getNamespaceURI(), qName.getLocalName());
        SchemaType schemaType = BuiltInType.getSchemaType((int)630);
        NamespaceBinding[] namespaceBindingArray = null;
        this.addStartElement((NodeName)fingerprintedQName, schemaType, namespaceBindingArray);
    }

    public void addStartElement(NodeName nodeName, SchemaType schemaType, NamespaceBinding[] namespaceBindingArray) {
        String string = this.receiver.getSystemId();
        int n = string == null ? 0 : this.xLocationProvider.allocateLocation(string);
        try {
            this.receiver.startElement(nodeName, schemaType, n, 0);
            if (namespaceBindingArray != null) {
                for (NamespaceBinding namespaceBinding : namespaceBindingArray) {
                    this.receiver.namespace(namespaceBinding, 0);
                }
            }
        }
        catch (XPathException xPathException) {
            throw new XProcException(xPathException);
        }
    }

    public void addNamespace(String string, String string2) {
        NamespaceBinding namespaceBinding = new NamespaceBinding(string, string2);
        try {
            this.receiver.namespace(namespaceBinding, 0);
        }
        catch (XPathException xPathException) {
            throw new XProcException(xPathException);
        }
    }

    public void addAttributes(XdmNode xdmNode) {
        XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.ATTRIBUTE);
        while (xdmSequenceIterator.hasNext()) {
            XdmNode xdmNode2 = (XdmNode)xdmSequenceIterator.next();
            this.addAttribute(xdmNode2);
        }
    }

    public void addAttribute(XdmNode xdmNode) {
        this.addAttribute(xdmNode, xdmNode.getStringValue());
    }

    public void addAttribute(XdmNode xdmNode, String string) {
        NodeInfo nodeInfo = xdmNode.getUnderlyingNode();
        NameOfNode nameOfNode = new NameOfNode(nodeInfo);
        SimpleType simpleType = (SimpleType)nodeInfo.getSchemaType();
        try {
            this.receiver.attribute((NodeName)nameOfNode, simpleType, (CharSequence)string, 0, 0);
        }
        catch (XPathException xPathException) {
            throw new XProcException(xPathException);
        }
    }

    public void addAttribute(NodeName nodeName, SimpleType simpleType, String string) {
        try {
            this.receiver.attribute(nodeName, simpleType, (CharSequence)string, 0, 0);
        }
        catch (XPathException xPathException) {
            throw new XProcException(xPathException);
        }
    }

    public void addAttribute(QName qName, String string) {
        FingerprintedQName fingerprintedQName = new FingerprintedQName(qName.getPrefix(), qName.getNamespaceURI(), qName.getLocalName());
        SimpleType simpleType = (SimpleType)BuiltInType.getSchemaType((int)631);
        try {
            this.receiver.attribute((NodeName)fingerprintedQName, simpleType, (CharSequence)string, 0, 0);
        }
        catch (XPathException xPathException) {
            throw new XProcException(xPathException);
        }
    }

    public void startContent() {
        try {
            this.receiver.startContent();
        }
        catch (XPathException xPathException) {
            throw new XProcException(xPathException);
        }
    }

    public void addEndElement() {
        try {
            this.receiver.endElement();
        }
        catch (XPathException xPathException) {
            throw new XProcException(xPathException);
        }
    }

    public void addComment(String string) {
        try {
            this.receiver.comment((CharSequence)string, 0, 0);
        }
        catch (XPathException xPathException) {
            throw new XProcException(xPathException);
        }
    }

    public void addText(String string) {
        try {
            this.receiver.characters((CharSequence)string, 0, 0);
        }
        catch (XPathException xPathException) {
            throw new XProcException(xPathException);
        }
    }

    public void addPI(String string, String string2) {
        try {
            this.receiver.processingInstruction(string, (CharSequence)string2, 0, 0);
        }
        catch (XPathException xPathException) {
            throw new XProcException(xPathException);
        }
    }
}

