/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcConfiguration;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.runtime.XLibrary;
import com.xmlcalabash.util.Input;
import com.xmlcalabash.util.JSONtoXML;
import com.xmlcalabash.util.LogOptions;
import com.xmlcalabash.util.Output;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.URIUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.xml.sax.InputSource;

public class UserArgs {
    private boolean needsCheck = false;
    private Boolean debug = null;
    private Output profile = null;
    private boolean showVersion = false;
    private String saxonProcessor = null;
    private Input saxonConfig = null;
    private boolean schemaAware = false;
    private Boolean safeMode = null;
    private Input config = null;
    private String logStyle = null;
    private String entityResolverClass = null;
    private String uriResolverClass = null;
    private Input pipeline = null;
    private List<Input> libraries = new ArrayList<Input>();
    private Map<String, Output> outputs = new HashMap<String, Output>();
    private Map<String, String> bindings = new HashMap<String, String>();
    private List<StepArgs> steps = new ArrayList<StepArgs>();
    private StepArgs curStep = new StepArgs();
    private StepArgs lastStep = null;
    private boolean extensionValues = false;
    private boolean allowXPointerOnText = false;
    private boolean useXslt10 = false;
    private boolean transparentJSON = false;
    private String jsonFlavor = null;

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    private void setProfile(Output output) {
        this.needsCheck = true;
        if (this.profile != null && output != null) {
            throw new XProcException("Multiple profile are not supported.");
        }
        this.profile = output;
    }

    public void setProfile(String string) {
        if ("-".equals(string)) {
            this.setProfile(new Output(System.out));
        } else {
            this.setProfile(new Output("file://" + this.fixUpURI(string)));
        }
    }

    public void setProfile(OutputStream outputStream) {
        this.setProfile(new Output(outputStream));
    }

    public boolean isShowVersion() {
        return this.showVersion;
    }

    public void setShowVersion(boolean bl) {
        this.showVersion = bl;
    }

    public void setSaxonProcessor(String string) {
        this.needsCheck = true;
        this.saxonProcessor = string;
        if (!("he".equals(string) || "pe".equals(string) || "ee".equals(string))) {
            throw new XProcException("Invalid Saxon processor option: '" + string + "'. Must be 'he' (default), 'pe' or 'ee'.");
        }
    }

    private void setSaxonConfig(Input input) {
        this.needsCheck = true;
        if (this.saxonConfig != null && input != null) {
            throw new XProcException("Multiple saxonConfig are not supported.");
        }
        this.saxonConfig = input;
    }

    public void setSaxonConfig(String string) {
        if ("-".equals(string)) {
            this.setSaxonConfig(new Input(System.in, "<stdin>"));
        } else {
            this.setSaxonConfig(new Input("file://" + this.fixUpURI(string)));
        }
    }

    public void setSaxonConfig(InputStream inputStream, String string) {
        this.setSaxonConfig(new Input(inputStream, string));
    }

    public void setSchemaAware(boolean bl) {
        this.needsCheck = true;
        this.schemaAware = bl;
    }

    public void setSafeMode(boolean bl) {
        this.safeMode = bl;
    }

    private void setConfig(Input input) {
        if (this.config != null && input != null) {
            throw new XProcException("Multiple config are not supported.");
        }
        this.config = input;
    }

    public void setConfig(String string) {
        if ("-".equals(string)) {
            this.setConfig(new Input(System.in, "<stdin>"));
        } else {
            this.setConfig(new Input("file://" + this.fixUpURI(string)));
        }
    }

    public void setConfig(InputStream inputStream, String string) {
        this.setConfig(new Input(inputStream, string));
    }

    public void setLogStyle(String string) {
        this.logStyle = string;
        if (!("off".equals(string) || "plain".equals(string) || "wrapped".equals(string) || "directory".equals(string))) {
            throw new XProcException("Invalid log style: '" + string + "'. Must be 'off', 'plain', 'wrapped' (default) or 'directory'.");
        }
    }

    public void setEntityResolverClass(String string) {
        this.entityResolverClass = string;
    }

    public void setUriResolverClass(String string) {
        this.uriResolverClass = string;
    }

    public Input getPipeline() {
        this.checkArgs();
        return this.pipeline;
    }

    private void setPipeline(Input input) {
        this.needsCheck = true;
        if (this.pipeline != null && input != null) {
            throw new XProcException("Multiple pipelines are not supported.");
        }
        this.pipeline = input;
    }

    public void setPipeline(String string) {
        this.setPipeline(new Input(string));
    }

    public void setPipeline(InputStream inputStream, String string) {
        this.setPipeline(new Input(inputStream, string));
    }

    public void addLibrary(String string) {
        this.needsCheck = true;
        this.libraries.add(new Input(string));
    }

    public void addLibrary(InputStream inputStream, String string) {
        this.needsCheck = true;
        this.libraries.add(new Input(inputStream, string));
    }

    public Map<String, Output> getOutputs() {
        this.checkArgs();
        return Collections.unmodifiableMap(this.outputs);
    }

    public void addOutput(String string, String string2) {
        if (this.outputs.containsKey(string)) {
            if (string == null) {
                throw new XProcException("Duplicate output binding for default output port.");
            }
            throw new XProcException("Duplicate output binding: '" + string + "'.");
        }
        if ("-".equals(string2)) {
            this.outputs.put(string, new Output(string2));
        } else {
            this.outputs.put(string, new Output("file://" + this.fixUpURI(string2)));
        }
    }

    public void addOutput(String string, OutputStream outputStream) {
        if (this.outputs.containsKey(string)) {
            if (string == null) {
                throw new XProcException("Duplicate output binding for default output port.");
            }
            throw new XProcException("Duplicate output binding: '" + string + "'.");
        }
        this.outputs.put(string, new Output(outputStream));
    }

    public void addBinding(String string, String string2) {
        if (this.bindings.containsKey(string)) {
            throw new XProcException("Duplicate prefix binding: '" + string + "'.");
        }
        this.bindings.put(string, string2);
    }

    public void setCurStepName(String string) {
        this.needsCheck = true;
        this.curStep.setName(string);
        this.steps.add(this.curStep);
        this.lastStep = this.curStep;
        this.curStep = new StepArgs();
    }

    public Set<String> getInputPorts() {
        this.checkArgs();
        if (this.steps.size() != 0) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.curStep.inputs.keySet());
    }

    public List<Input> getInputs(String string) {
        this.checkArgs();
        if (this.steps.size() != 0) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.curStep.inputs.get(string));
    }

    public void addInput(String string, String string2, Input.Type type) {
        this.addInput(string, string2, type, null);
    }

    public void addInput(String string, String string2, Input.Type type, String string3) {
        if ("-".equals(string2) || string2.startsWith("http:") || string2.startsWith("https:") || string2.startsWith("file:") || "p:empty".equals(string2)) {
            this.curStep.addInput(string, string2, type, string3);
        } else {
            this.curStep.addInput(string, "file://" + this.fixUpURI(string2), type, string3);
        }
    }

    public void addInput(String string, InputStream inputStream, String string2, Input.Type type) throws IOException {
        this.addInput(string, inputStream, string2, type, null);
    }

    public void addInput(String string, InputStream inputStream, String string2, Input.Type type, String string3) throws IOException {
        inputStream = new BufferedInputStream(inputStream);
        string3 = string3 == null || "content/unknown".equals(string3) ? URLConnection.guessContentTypeFromStream(inputStream) : string3;
        string3 = string3 == null || "content/unknown".equals(string3) ? URLConnection.guessContentTypeFromName(string2) : string3;
        this.curStep.addInput(string, inputStream, string2, type, string3);
    }

    public void setDefaultInputPort(String string) {
        if (this.curStep.inputs.containsKey(null)) {
            this.curStep.inputs.put(string, this.curStep.inputs.remove(null));
        }
    }

    public Set<String> getParameterPorts() {
        this.checkArgs();
        if (this.steps.size() != 0) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.curStep.params.keySet());
    }

    public Map<QName, String> getParameters(String string) {
        this.checkArgs();
        if (this.steps.size() != 0) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.curStep.params.get(string));
    }

    public void addParam(String string, String string2) {
        this.needsCheck = true;
        String string3 = "*";
        int n = string.indexOf("@");
        if (n > 0) {
            string3 = string.substring(0, n);
            string = string.substring(n + 1);
        }
        this.curStep.addParameter(string3, string, string2);
    }

    public void addParam(String string, String string2, String string3) {
        this.needsCheck = true;
        this.curStep.addParameter(string, string2, string3);
    }

    public Set<QName> getOptionNames() {
        this.checkArgs();
        if (this.steps.size() != 0) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.curStep.options.keySet());
    }

    public String getOption(QName qName) {
        this.checkArgs();
        if (this.steps.size() != 0) {
            return null;
        }
        return this.curStep.options.get(qName);
    }

    public void addOption(String string, String string2) {
        this.needsCheck = true;
        if (this.lastStep != null) {
            this.lastStep.addOption(string, string2);
        } else {
            this.curStep.addOption(string, string2);
        }
    }

    public void setExtensionValues(boolean bl) {
        this.extensionValues = bl;
    }

    public void setAllowXPointerOnText(boolean bl) {
        this.allowXPointerOnText = bl;
    }

    public void setUseXslt10(boolean bl) {
        this.useXslt10 = bl;
    }

    public void setTransparentJSON(boolean bl) {
        this.transparentJSON = bl;
    }

    public void setJsonFlavor(String string) {
        this.jsonFlavor = string;
        if (string != null && !JSONtoXML.knownFlavor(string)) {
            throw new XProcException("Unknown JSON flavor: '" + string + "'.");
        }
    }

    public void checkArgs() {
        if (this.needsCheck) {
            if (this.hasImplicitPipelineInternal() && this.pipeline != null) {
                throw new XProcException("You can specify a library and / or steps or a pipeline, but not both.");
            }
            if (this.saxonConfig != null) {
                if (this.schemaAware) {
                    throw new XProcException("Specifying schema-aware processing is an error if you specify a Saxon configuration file.");
                }
                if (this.saxonProcessor != null) {
                    throw new XProcException("Specifying a processor type is an error if you specify a Saxon configuration file.");
                }
            }
            if (this.schemaAware && this.saxonProcessor != null && !"ee".equals(this.saxonProcessor)) {
                throw new XProcException("Schema-aware processing can only be used with saxon processor \"ee\".");
            }
            for (StepArgs stepArgs : this.steps) {
                stepArgs.checkArgs();
            }
            if (!this.steps.contains(this.curStep)) {
                this.curStep.checkArgs();
            }
            this.needsCheck = false;
        }
    }

    public XProcConfiguration createConfiguration() throws SaxonApiException {
        Object object;
        this.checkArgs();
        XProcConfiguration xProcConfiguration = null;
        try {
            object = this.saxonProcessor;
            if (this.schemaAware) {
                object = "ee";
            }
            xProcConfiguration = this.saxonConfig != null ? new XProcConfiguration(this.saxonConfig) : (object != null ? new XProcConfiguration((String)object, this.schemaAware) : new XProcConfiguration());
        }
        catch (Exception exception) {
            System.err.println("FATAL: Failed to parse Saxon configuration file.");
            System.err.println(exception);
            System.exit(2);
        }
        if (this.config != null) {
            try {
                Object object2;
                switch (this.config.getKind()) {
                    case URI: {
                        object2 = URI.create(this.config.getUri());
                        object = new FileInputStream(new File((URI)object2));
                        break;
                    }
                    case INPUT_STREAM: {
                        object = this.config.getInputStream();
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.format("Unsupported config kind '%s'", new Object[]{this.config.getKind()}));
                    }
                }
                object2 = new SAXSource(new InputSource((InputStream)object));
                DocumentBuilder documentBuilder = xProcConfiguration.getProcessor().newDocumentBuilder();
                XdmNode xdmNode = documentBuilder.build((Source)object2);
                xProcConfiguration.parse(xdmNode);
            }
            catch (Exception exception) {
                System.err.println("FATAL: Failed to parse configuration file.");
                System.err.println(exception);
                System.exit(3);
            }
        }
        if (this.logStyle != null) {
            xProcConfiguration.logOpt = this.logStyle.equals("off") ? LogOptions.OFF : (this.logStyle.equals("plain") ? LogOptions.PLAIN : (this.logStyle.equals("directory") ? LogOptions.DIRECTORY : LogOptions.WRAPPED));
        }
        if (this.uriResolverClass != null) {
            xProcConfiguration.uriResolver = this.uriResolverClass;
        }
        if (this.entityResolverClass != null) {
            xProcConfiguration.entityResolver = this.entityResolverClass;
        }
        if (this.safeMode != null) {
            xProcConfiguration.safeMode = this.safeMode;
        }
        if (this.debug != null) {
            xProcConfiguration.debug = this.debug;
        }
        if (this.profile != null) {
            xProcConfiguration.profile = this.profile;
        }
        xProcConfiguration.extensionValues |= this.extensionValues;
        xProcConfiguration.xpointerOnText |= this.allowXPointerOnText;
        xProcConfiguration.transparentJSON |= this.transparentJSON;
        if (this.jsonFlavor != null && !JSONtoXML.knownFlavor(this.jsonFlavor)) {
            xProcConfiguration.jsonFlavor = this.jsonFlavor;
        }
        xProcConfiguration.useXslt10 |= this.useXslt10;
        return xProcConfiguration;
    }

    private boolean hasImplicitPipelineInternal() {
        return this.steps.size() > 0 || this.libraries.size() > 0;
    }

    public boolean hasImplicitPipeline() {
        this.checkArgs();
        return this.hasImplicitPipelineInternal();
    }

    /*
     * WARNING - void declaration
     */
    public XdmNode getImplicitPipeline(XProcRuntime xProcRuntime) throws IOException {
        Object object;
        Object object2;
        this.checkArgs();
        if (this.steps.size() == 0 && this.libraries.size() > 0) {
            try {
                object2 = this.libraries.get(0);
                if (((Input)object2).getKind() == Input.Kind.INPUT_STREAM) {
                    object = ((Input)object2).getInputStream();
                    Iterator<Input> iterator = File.createTempFile("calabashLibrary", null);
                    ((File)((Object)iterator)).deleteOnExit();
                    FileOutputStream object3 = new FileOutputStream((File)((Object)iterator));
                    object3.getChannel().transferFrom(Channels.newChannel((InputStream)object), 0L, Long.MAX_VALUE);
                    object3.close();
                    ((InputStream)object).close();
                    this.libraries.set(0, new Input(((File)((Object)iterator)).toURI().toASCIIString()));
                }
                object = xProcRuntime.loadLibrary(this.libraries.get(0));
                this.curStep.setName(((XLibrary)object).getFirstPipelineType().getClarkName());
                this.curStep.checkArgs();
                this.steps.add(this.curStep);
            }
            catch (SaxonApiException saxonApiException) {
                throw new XProcException(saxonApiException);
            }
        }
        object2 = new TreeWriter(xProcRuntime);
        ((TreeWriter)object2).startDocument(xProcRuntime.getStaticBaseURI());
        ((TreeWriter)object2).addStartElement(XProcConstants.p_declare_step);
        ((TreeWriter)object2).addAttribute(new QName("version"), "1.0");
        ((TreeWriter)object2).startContent();
        ((TreeWriter)object2).addStartElement(XProcConstants.p_input);
        ((TreeWriter)object2).addAttribute(new QName("port"), "source");
        ((TreeWriter)object2).addAttribute(new QName("sequence"), "true");
        ((TreeWriter)object2).startContent();
        ((TreeWriter)object2).addEndElement();
        ((TreeWriter)object2).addStartElement(XProcConstants.p_input);
        ((TreeWriter)object2).addAttribute(new QName("port"), "parameters");
        ((TreeWriter)object2).addAttribute(new QName("kind"), "parameter");
        ((TreeWriter)object2).startContent();
        ((TreeWriter)object2).addEndElement();
        if (this.outputs.size() == 0) {
            this.outputs.put("result", new Output("-"));
        }
        object = "cmdlineStep" + this.steps.size();
        for (String string : this.outputs.keySet()) {
            void var5_11;
            if (string == null) {
                String string2 = "result";
            }
            ((TreeWriter)object2).addStartElement(XProcConstants.p_output);
            ((TreeWriter)object2).addAttribute(new QName("port"), (String)var5_11);
            ((TreeWriter)object2).startContent();
            ((TreeWriter)object2).addStartElement(XProcConstants.p_pipe);
            ((TreeWriter)object2).addAttribute(new QName("step"), (String)object);
            ((TreeWriter)object2).addAttribute(new QName("port"), (String)var5_11);
            ((TreeWriter)object2).startContent();
            ((TreeWriter)object2).addEndElement();
            ((TreeWriter)object2).addEndElement();
        }
        block11: for (Input input : this.libraries) {
            switch (input.getKind()) {
                case URI: {
                    ((TreeWriter)object2).addStartElement(XProcConstants.p_import);
                    ((TreeWriter)object2).addAttribute(new QName("href"), input.getUri());
                    ((TreeWriter)object2).startContent();
                    ((TreeWriter)object2).addEndElement();
                    continue block11;
                }
                case INPUT_STREAM: {
                    InputStream inputStream = input.getInputStream();
                    Iterator<String> iterator = File.createTempFile("calabashLibrary", null);
                    ((File)((Object)iterator)).deleteOnExit();
                    FileOutputStream fileOutputStream = new FileOutputStream((File)((Object)iterator));
                    fileOutputStream.getChannel().transferFrom(Channels.newChannel(inputStream), 0L, Long.MAX_VALUE);
                    fileOutputStream.close();
                    inputStream.close();
                    ((TreeWriter)object2).addStartElement(XProcConstants.p_import);
                    ((TreeWriter)object2).addAttribute(new QName("href"), ((File)((Object)iterator)).toURI().toASCIIString());
                    ((TreeWriter)object2).startContent();
                    ((TreeWriter)object2).addEndElement();
                    continue block11;
                }
            }
            throw new UnsupportedOperationException(String.format("Unsupported library kind '%s'", new Object[]{input.getKind()}));
        }
        int n = 0;
        for (StepArgs stepArgs : this.steps) {
            String string;
            ((TreeWriter)object2).addStartElement(stepArgs.stepName);
            ((TreeWriter)object2).addAttribute(new QName("name"), "cmdlineStep" + ++n);
            for (QName qName : stepArgs.options.keySet()) {
                ((TreeWriter)object2).addAttribute(qName, stepArgs.options.get(qName));
            }
            ((TreeWriter)object2).startContent();
            for (String string3 : stepArgs.inputs.keySet()) {
                ((TreeWriter)object2).addStartElement(XProcConstants.p_input);
                ((TreeWriter)object2).addAttribute(new QName("port"), string3 == null ? "source" : string3);
                ((TreeWriter)object2).startContent();
                block15: for (Input input : stepArgs.inputs.get(string3)) {
                    string = input.getType() == Input.Type.DATA ? XProcConstants.p_data : XProcConstants.p_document;
                    switch (input.getKind()) {
                        case URI: {
                            String string4 = input.getUri();
                            if ("p:empty".equals(string4)) {
                                ((TreeWriter)object2).addStartElement(XProcConstants.p_empty);
                                ((TreeWriter)object2).startContent();
                                ((TreeWriter)object2).addEndElement();
                                continue block15;
                            }
                            ((TreeWriter)object2).addStartElement((QName)string);
                            ((TreeWriter)object2).addAttribute(new QName("href"), string4);
                            if (input.getType() == Input.Type.DATA) {
                                ((TreeWriter)object2).addAttribute(new QName("content-type"), input.getContentType());
                            }
                            ((TreeWriter)object2).startContent();
                            ((TreeWriter)object2).addEndElement();
                            continue block15;
                        }
                        case INPUT_STREAM: {
                            InputStream inputStream = input.getInputStream();
                            if (System.in.equals(inputStream)) {
                                ((TreeWriter)object2).addStartElement((QName)string);
                                ((TreeWriter)object2).addAttribute(new QName("href"), "-");
                                if (input.getType() == Input.Type.DATA) {
                                    ((TreeWriter)object2).addAttribute(new QName("content-type"), input.getContentType());
                                }
                                ((TreeWriter)object2).startContent();
                                ((TreeWriter)object2).addEndElement();
                                continue block15;
                            }
                            File file = File.createTempFile("calabashInput", null);
                            file.deleteOnExit();
                            FileOutputStream fileOutputStream = new FileOutputStream(file);
                            fileOutputStream.getChannel().transferFrom(Channels.newChannel(inputStream), 0L, Long.MAX_VALUE);
                            fileOutputStream.close();
                            inputStream.close();
                            ((TreeWriter)object2).addStartElement((QName)string);
                            ((TreeWriter)object2).addAttribute(new QName("href"), file.toURI().toASCIIString());
                            if (input.getType() == Input.Type.DATA) {
                                ((TreeWriter)object2).addAttribute(new QName("content-type"), input.getContentType());
                            }
                            ((TreeWriter)object2).startContent();
                            ((TreeWriter)object2).addEndElement();
                            continue block15;
                        }
                    }
                    throw new UnsupportedOperationException(String.format("Unsupported input kind '%s'", new Object[]{input.getKind()}));
                }
                ((TreeWriter)object2).addEndElement();
            }
            for (String string5 : stepArgs.params.keySet()) {
                for (QName qName : stepArgs.params.get(string5).keySet()) {
                    string = stepArgs.params.get(string5).get(qName);
                    string = "'" + string.replace("'", "''") + "'";
                    ((TreeWriter)object2).addStartElement(XProcConstants.p_with_param);
                    if (!"*".equals(string5)) {
                        ((TreeWriter)object2).addAttribute(new QName("port"), string5);
                    }
                    if (!qName.getPrefix().isEmpty() || !qName.getNamespaceURI().isEmpty()) {
                        ((TreeWriter)object2).addNamespace(qName.getPrefix(), qName.getNamespaceURI());
                    }
                    ((TreeWriter)object2).addAttribute(new QName("name"), qName.toString());
                    ((TreeWriter)object2).addAttribute(new QName("select"), string);
                    ((TreeWriter)object2).startContent();
                    ((TreeWriter)object2).addEndElement();
                }
            }
            ((TreeWriter)object2).addEndElement();
            ((TreeWriter)object2).endDocument();
        }
        ((TreeWriter)object2).addEndElement();
        ((TreeWriter)object2).endDocument();
        return ((TreeWriter)object2).getResult();
    }

    private String fixUpURI(String string) {
        File file = new File(string);
        String string2 = URIUtils.encode(file.getAbsolutePath());
        if ("\\".equals(System.getProperty("file.separator"))) {
            string2 = "/" + string2;
        }
        return string2;
    }

    private class StepArgs {
        public String plainStepName = null;
        public QName stepName = null;
        public Map<String, List<Input>> inputs = new HashMap<String, List<Input>>();
        public Map<String, Map<String, String>> plainParams = new HashMap<String, Map<String, String>>();
        public Map<String, Map<QName, String>> params = new HashMap<String, Map<QName, String>>();
        public Map<String, String> plainOptions = new HashMap<String, String>();
        public Map<QName, String> options = new HashMap<QName, String>();

        private StepArgs() {
        }

        public void setName(String string) {
            UserArgs.this.needsCheck = true;
            this.plainStepName = string;
        }

        public void addInput(String string, String string2, Input.Type type, String string3) {
            if (!this.inputs.containsKey(string)) {
                this.inputs.put(string, new ArrayList());
            }
            this.inputs.get(string).add(new Input(string2, type, string3));
        }

        public void addInput(String string, InputStream inputStream, String string2, Input.Type type, String string3) {
            if (!this.inputs.containsKey(string)) {
                this.inputs.put(string, new ArrayList());
            }
            this.inputs.get(string).add(new Input(inputStream, string2, type, string3));
        }

        public void addOption(String string, String string2) {
            UserArgs.this.needsCheck = true;
            if (this.plainOptions.containsKey(string)) {
                throw new XProcException("Duplicate option name: '" + string + "'.");
            }
            this.plainOptions.put(string, string2);
        }

        public void addParameter(String string, String string2, String string3) {
            UserArgs.this.needsCheck = true;
            Map<Object, Object> map = !this.plainParams.containsKey(string) ? new HashMap() : this.plainParams.get(string);
            if (map.containsKey(string2)) {
                throw new XProcException("Duplicate parameter name: '" + string2 + "'.");
            }
            map.put(string2, string3);
            this.plainParams.put(string, map);
        }

        private QName makeQName(String string) {
            QName qName;
            if (string == null) {
                qName = new QName("");
            } else if (string.indexOf("{") == 0) {
                qName = QName.fromClarkName((String)string);
            } else {
                int n = string.indexOf(":");
                if (n > 0) {
                    String string2 = string.substring(0, n);
                    if (!UserArgs.this.bindings.containsKey(string2)) {
                        throw new XProcException("Unbound prefix '" + string2 + "' in: '" + string + "'.");
                    }
                    String string3 = (String)UserArgs.this.bindings.get(string2);
                    qName = new QName(string2, string3, string.substring(n + 1));
                } else {
                    qName = new QName("", string);
                }
            }
            return qName;
        }

        public void checkArgs() {
            Object object;
            if (!UserArgs.this.bindings.containsKey("p")) {
                UserArgs.this.bindings.put("p", "http://www.w3.org/ns/xproc");
            }
            this.stepName = this.makeQName(this.plainStepName);
            this.options.clear();
            for (Map.Entry<String, String> entry : this.plainOptions.entrySet()) {
                object = this.makeQName(entry.getKey());
                if (this.options.containsKey(object)) {
                    throw new XProcException("Duplicate option name: '" + object + "'.");
                }
                this.options.put((QName)object, entry.getValue());
            }
            this.params.clear();
            for (Map.Entry<String, Object> entry : this.plainParams.entrySet()) {
                object = new HashMap();
                for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                    QName qName = this.makeQName((String)entry2.getKey());
                    if (object.containsKey(qName)) {
                        throw new XProcException("Duplicate parameter name: '" + qName + "'.");
                    }
                    object.put(qName, entry2.getValue());
                }
                this.params.put(entry.getKey(), (Map<QName, String>)object);
            }
        }
    }
}

