/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.URIUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.ModuleURIResolver;
import net.sf.saxon.lib.StandardModuleURIResolver;
import net.sf.saxon.lib.UnparsedTextURIResolver;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XProcURIResolver
implements URIResolver,
EntityResolver,
ModuleURIResolver,
UnparsedTextURIResolver {
    private URIResolver uriResolver = null;
    private EntityResolver entityResolver = null;
    private ModuleURIResolver moduleURIResolver = null;
    private UnparsedTextURIResolver unparsedTextResolver = null;
    private XProcRuntime runtime = null;
    private Hashtable<String, XdmNode> cache = new Hashtable();
    private static boolean useCache = true;

    public XProcURIResolver(XProcRuntime xProcRuntime) {
        this.runtime = xProcRuntime;
    }

    public void setUnderlyingURIResolver(URIResolver uRIResolver) {
        this.uriResolver = uRIResolver;
    }

    public void setUnderlyingEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setUnderlyingUnparsedTextURIResolver(UnparsedTextURIResolver unparsedTextURIResolver) {
        this.unparsedTextResolver = unparsedTextURIResolver;
    }

    public void setUnderlyingModuleURIResolver(ModuleURIResolver moduleURIResolver) {
        this.moduleURIResolver = moduleURIResolver;
    }

    public void cache(XdmNode xdmNode, URI uRI) {
        XdmNode xdmNode2 = S9apiUtils.getDocumentElement(xdmNode);
        URI uRI2 = uRI.resolve(xdmNode2.getBaseURI());
        if (useCache) {
            this.cache.put(uRI2.toASCIIString(), xdmNode);
        }
    }

    @Override
    public Source resolve(String string, String string2) throws TransformerException {
        Object object;
        this.runtime.finest(null, null, "URIResolver(" + string + "," + string2 + ")");
        String string3 = null;
        if (string2 == null) {
            try {
                object = new URL(string);
                string3 = ((URL)object).toURI().toASCIIString();
            }
            catch (MalformedURLException malformedURLException) {
                this.runtime.finest(null, null, "MalformedURLException on " + string);
            }
            catch (URISyntaxException uRISyntaxException) {
                this.runtime.finest(null, null, "URISyntaxException on " + string);
            }
        } else {
            try {
                object = new URI(string2);
                string3 = ((URI)object).resolve(string).toASCIIString();
            }
            catch (URISyntaxException uRISyntaxException) {
                this.runtime.finest(null, null, "URISyntaxException resolving base and href: " + string2 + " : " + string);
            }
        }
        this.runtime.finest(null, null, "Resolved: " + string3);
        if (this.cache.containsKey(string3)) {
            this.runtime.finest(null, null, "Returning cached document.");
            return this.cache.get(string3).asSource();
        }
        if (this.uriResolver != null) {
            SAXSource sAXSource;
            XMLReader xMLReader;
            this.runtime.finest(null, null, "uriResolver.resolve(" + string + "," + string2 + ")");
            object = this.uriResolver.resolve(string, string2);
            if (object != null && object instanceof SAXSource && (xMLReader = (sAXSource = (SAXSource)object).getXMLReader()) == null) {
                try {
                    SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                    sAXParserFactory.setNamespaceAware(true);
                    xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
                    xMLReader.setEntityResolver(this);
                    sAXSource.setXMLReader(xMLReader);
                }
                catch (SAXException sAXException) {
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    // empty catch block
                }
            }
            return object;
        }
        return null;
    }

    public XdmNode parse(String string, String string2) {
        return this.parse(string, string2, false);
    }

    public XdmNode parse(String string, String string2, boolean bl) {
        Object object;
        Object object2;
        Source source = null;
        string = URIUtils.encode(string);
        this.runtime.finest(null, null, "Attempting to parse: " + string + " (" + string2 + ")");
        try {
            source = this.resolve(string, string2);
        }
        catch (TransformerException transformerException) {
            throw new XProcException(XProcConstants.dynamicError(9), (Throwable)transformerException);
        }
        if (source == null) {
            try {
                object2 = new URI(string2);
                URI uRI = ((URI)object2).resolve(string);
                source = new SAXSource(new InputSource(uRI.toASCIIString()));
                object = ((SAXSource)source).getXMLReader();
                if (object == null) {
                    try {
                        object = XMLReaderFactory.createXMLReader();
                        ((SAXSource)source).setXMLReader((XMLReader)object);
                        object.setEntityResolver(this);
                    }
                    catch (SAXException sAXException) {}
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new XProcException(uRISyntaxException);
            }
        }
        object2 = this.runtime.getProcessor().newDocumentBuilder();
        object2.setDTDValidation(bl);
        object2.setLineNumbering(true);
        try {
            return object2.build(source);
        }
        catch (SaxonApiException saxonApiException) {
            object = saxonApiException.getMessage();
            if (((String)object).contains("validation")) {
                throw XProcException.stepError(27, (Exception)((Object)saxonApiException));
            }
            if (((String)object).contains("HTTP response code: 403 ")) {
                throw XProcException.dynamicError(21);
            }
            throw XProcException.dynamicError(11, (Exception)((Object)saxonApiException));
        }
    }

    public XdmNode parse(InputSource inputSource) {
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setEntityResolver(this);
            SAXSource sAXSource = new SAXSource(xMLReader, inputSource);
            DocumentBuilder documentBuilder = this.runtime.getProcessor().newDocumentBuilder();
            documentBuilder.setLineNumbering(true);
            documentBuilder.setDTDValidation(false);
            return documentBuilder.build((Source)sAXSource);
        }
        catch (SaxonApiException saxonApiException) {
            String string = saxonApiException.getMessage();
            if (string.contains("validation")) {
                throw XProcException.stepError(27, (Exception)((Object)saxonApiException));
            }
            if (string.contains("HTTP response code: 403 ")) {
                throw XProcException.dynamicError(21);
            }
            throw XProcException.dynamicError(11, (Exception)((Object)saxonApiException));
        }
        catch (SAXException sAXException) {
            throw new XProcException(sAXException);
        }
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        Object object;
        this.runtime.finest(null, null, "ResolveEntity(" + string + "," + string2 + ")");
        if (string2 == null) {
            return null;
        }
        try {
            object = new URI(string2);
            String string3 = ((URI)object).toASCIIString();
            if (this.cache.containsKey(string3)) {
                this.runtime.finest(null, null, "Returning cached document.");
                return S9apiUtils.xdmToInputSource(this.runtime, this.cache.get(string3));
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            this.runtime.finest(null, null, "URISyntaxException resolving entityResolver systemId: " + string2);
        }
        catch (SaxonApiException saxonApiException) {
            throw new XProcException(saxonApiException);
        }
        if (this.entityResolver != null) {
            object = this.entityResolver.resolveEntity(string, string2);
            return object;
        }
        return null;
    }

    public StreamSource[] resolve(String string, String string2, String[] stringArray) throws XPathException {
        if (this.moduleURIResolver != null) {
            return this.moduleURIResolver.resolve(string, string2, stringArray);
        }
        return StandardModuleURIResolver.getInstance().resolve(string, string2, stringArray);
    }

    public Reader resolve(URI uRI, String string, Configuration configuration) throws XPathException {
        if (this.unparsedTextResolver != null) {
            return this.unparsedTextResolver.resolve(uRI, string, configuration);
        }
        try {
            URL uRL = uRI.toURL();
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            return new InputStreamReader(inputStream);
        }
        catch (Exception exception) {
            throw new XPathException((Throwable)exception);
        }
    }
}

