/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.auth.basic;

import com.google.common.base.Optional;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.model.Parameter;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.server.impl.inject.AbstractHttpContextInjectable;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.inject.InjectableProvider;
import com.yammer.dropwizard.auth.Auth;
import com.yammer.dropwizard.auth.AuthenticationException;
import com.yammer.dropwizard.auth.Authenticator;
import com.yammer.dropwizard.auth.basic.BasicCredentials;
import java.io.UnsupportedEncodingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.eclipse.jetty.util.B64Code;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthProvider<T>
implements InjectableProvider<Auth, Parameter> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicAuthProvider.class);
    private final Authenticator<BasicCredentials, T> authenticator;
    private final String realm;

    public BasicAuthProvider(Authenticator<BasicCredentials, T> authenticator, String realm) {
        this.authenticator = authenticator;
        this.realm = realm;
    }

    public ComponentScope getScope() {
        return ComponentScope.PerRequest;
    }

    public Injectable<?> getInjectable(ComponentContext ic, Auth a, Parameter c) {
        return new BasicAuthInjectable(this.authenticator, this.realm, a.required());
    }

    private static class BasicAuthInjectable<T>
    extends AbstractHttpContextInjectable<T> {
        private static final String PREFIX = "Basic";
        private static final String HEADER_NAME = "WWW-Authenticate";
        private static final String HEADER_VALUE = "Basic realm=\"%s\"";
        private final Authenticator<BasicCredentials, T> authenticator;
        private final String realm;
        private final boolean required;

        private BasicAuthInjectable(Authenticator<BasicCredentials, T> authenticator, String realm, boolean required) {
            this.authenticator = authenticator;
            this.realm = realm;
            this.required = required;
        }

        public T getValue(HttpContext c) {
            String header = c.getRequest().getHeaderValue("Authorization");
            try {
                String password;
                String username;
                BasicCredentials credentials;
                Optional<T> result;
                String decoded;
                int i;
                String method;
                int space;
                if (header != null && (space = header.indexOf(32)) > 0 && PREFIX.equalsIgnoreCase(method = header.substring(0, space)) && (i = (decoded = B64Code.decode((String)header.substring(space + 1), (String)"ISO-8859-1")).indexOf(58)) > 0 && (result = this.authenticator.authenticate(credentials = new BasicCredentials(username = decoded.substring(0, i), password = decoded.substring(i + 1)))).isPresent()) {
                    return (T)result.get();
                }
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.debug("Error decoding credentials", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.debug("Error decoding credentials", (Throwable)e);
            }
            catch (AuthenticationException e) {
                LOGGER.warn("Error authenticating credentials", (Throwable)e);
                throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
            }
            if (this.required) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).header(HEADER_NAME, (Object)String.format(HEADER_VALUE, this.realm)).entity((Object)"Credentials are required to access this resource.").type(MediaType.TEXT_PLAIN_TYPE).build());
            }
            return null;
        }
    }
}

