/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.auth.oauth;

import com.google.common.base.Optional;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.api.model.Parameter;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.server.impl.inject.AbstractHttpContextInjectable;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.inject.InjectableProvider;
import com.yammer.dropwizard.auth.Auth;
import com.yammer.dropwizard.auth.AuthenticationException;
import com.yammer.dropwizard.auth.Authenticator;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthProvider<T>
implements InjectableProvider<Auth, Parameter> {
    private final Authenticator<String, T> authenticator;
    private final String realm;

    public OAuthProvider(Authenticator<String, T> authenticator, String realm) {
        this.authenticator = authenticator;
        this.realm = realm;
    }

    public ComponentScope getScope() {
        return ComponentScope.PerRequest;
    }

    public Injectable<?> getInjectable(ComponentContext ic, Auth a, Parameter c) {
        return new OAuthInjectable(this.authenticator, this.realm, a.required());
    }

    private static class OAuthInjectable<T>
    extends AbstractHttpContextInjectable<T> {
        private static final Logger LOGGER = LoggerFactory.getLogger(OAuthInjectable.class);
        private static final String HEADER_NAME = "WWW-Authenticate";
        private static final String HEADER_VALUE = "Bearer realm=\"%s\"";
        private static final String PREFIX = "bearer";
        private final Authenticator<String, T> authenticator;
        private final String realm;
        private final boolean required;

        private OAuthInjectable(Authenticator<String, T> authenticator, String realm, boolean required) {
            this.authenticator = authenticator;
            this.realm = realm;
            this.required = required;
        }

        public T getValue(HttpContext c) {
            try {
                String credentials;
                Optional<T> result;
                String method;
                int space;
                String header = c.getRequest().getHeaderValue("Authorization");
                if (header != null && (space = header.indexOf(32)) > 0 && PREFIX.equalsIgnoreCase(method = header.substring(0, space)) && (result = this.authenticator.authenticate(credentials = header.substring(space + 1))).isPresent()) {
                    return (T)result.get();
                }
            }
            catch (AuthenticationException e) {
                LOGGER.warn("Error authenticating credentials", (Throwable)e);
                throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
            }
            if (this.required) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).header(HEADER_NAME, (Object)String.format(HEADER_VALUE, this.realm)).entity((Object)"Credentials are required to access this resource.").type(MediaType.TEXT_PLAIN_TYPE).build());
            }
            return null;
        }
    }
}

