/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.client;

import com.yammer.dropwizard.client.HttpClientConfiguration;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.httpclient.InstrumentedClientConnManager;
import com.yammer.metrics.httpclient.InstrumentedHttpClient;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public class HttpClientBuilder {
    private static final HttpRequestRetryHandler NO_RETRIES = new HttpRequestRetryHandler(){

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            return false;
        }
    };
    private HttpClientConfiguration configuration = new HttpClientConfiguration();
    private DnsResolver resolver = new SystemDefaultDnsResolver();
    private SchemeRegistry registry = SchemeRegistryFactory.createSystemDefault();

    public HttpClientBuilder using(HttpClientConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    public HttpClientBuilder using(DnsResolver resolver) {
        this.resolver = resolver;
        return this;
    }

    public HttpClientBuilder using(SchemeRegistry registry) {
        this.registry = registry;
        return this;
    }

    public HttpClient build() {
        BasicHttpParams params = this.createHttpParams();
        InstrumentedClientConnManager manager = this.createConnectionManager(this.registry);
        InstrumentedHttpClient client = new InstrumentedHttpClient(manager, (HttpParams)params);
        this.setStrategiesForClient(client);
        return client;
    }

    protected void setStrategiesForClient(InstrumentedHttpClient client) {
        final long keepAlive = this.configuration.getKeepAlive().toMilliseconds();
        if (keepAlive == 0L) {
            client.setReuseStrategy((ConnectionReuseStrategy)new NoConnectionReuseStrategy());
        } else {
            client.setReuseStrategy((ConnectionReuseStrategy)new DefaultConnectionReuseStrategy());
            client.setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultConnectionKeepAliveStrategy(){

                public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                    long duration = super.getKeepAliveDuration(response, context);
                    return duration == -1L ? keepAlive : duration;
                }
            });
        }
        if (this.configuration.getRetries() == 0) {
            client.setHttpRequestRetryHandler(NO_RETRIES);
        } else {
            client.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(this.configuration.getRetries(), false));
        }
    }

    protected BasicHttpParams createHttpParams() {
        BasicHttpParams params = new BasicHttpParams();
        if (this.configuration.isCookiesEnabled()) {
            params.setParameter("http.protocol.cookie-policy", (Object)"best-match");
        } else {
            params.setParameter("http.protocol.cookie-policy", (Object)"ignoreCookies");
        }
        Integer timeout = (int)this.configuration.getTimeout().toMilliseconds();
        params.setParameter("http.socket.timeout", (Object)timeout);
        Integer connectionTimeout = (int)this.configuration.getConnectionTimeout().toMilliseconds();
        params.setParameter("http.connection.timeout", (Object)connectionTimeout);
        params.setParameter("http.tcp.nodelay", (Object)Boolean.TRUE);
        params.setParameter("http.connection.stalecheck", (Object)Boolean.FALSE);
        return params;
    }

    protected InstrumentedClientConnManager createConnectionManager(SchemeRegistry registry) {
        long ttl = this.configuration.getTimeToLive().toMilliseconds();
        InstrumentedClientConnManager manager = new InstrumentedClientConnManager(Metrics.defaultRegistry(), registry, ttl, TimeUnit.MILLISECONDS, this.resolver);
        manager.setDefaultMaxPerRoute(this.configuration.getMaxConnectionsPerRoute());
        manager.setMaxTotal(this.configuration.getMaxConnections());
        return manager;
    }
}

