/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.client;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.yammer.dropwizard.util.Duration;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class HttpClientConfiguration {
    @NotNull
    @JsonProperty
    private Duration timeout = Duration.milliseconds((long)500L);
    @NotNull
    @JsonProperty
    private Duration connectionTimeout = Duration.milliseconds((long)500L);
    @NotNull
    @JsonProperty
    private Duration timeToLive = Duration.hours((long)1L);
    @JsonProperty
    private boolean cookiesEnabled = false;
    @Min(value=1L)
    @Max(value=0x7FFFFFFFL)
    @JsonProperty
    private int maxConnections = 1024;
    @Min(value=1L)
    @Max(value=0x7FFFFFFFL)
    @JsonProperty
    private int maxConnectionsPerRoute = 1024;
    @NotNull
    @JsonProperty
    private Duration keepAlive = Duration.milliseconds((long)0L);
    @Min(value=0L)
    @Max(value=1000L)
    private int retries = 0;

    public Duration getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(Duration keepAlive) {
        this.keepAlive = keepAlive;
    }

    public int getMaxConnectionsPerRoute() {
        return this.maxConnectionsPerRoute;
    }

    public void setMaxConnectionsPerRoute(int maxConnectionsPerRoute) {
        this.maxConnectionsPerRoute = maxConnectionsPerRoute;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Duration getTimeToLive() {
        return this.timeToLive;
    }

    public boolean isCookiesEnabled() {
        return this.cookiesEnabled;
    }

    public void setTimeout(Duration duration) {
        this.timeout = duration;
    }

    public void setConnectionTimeout(Duration duration) {
        this.connectionTimeout = duration;
    }

    public void setTimeToLive(Duration timeToLive) {
        this.timeToLive = timeToLive;
    }

    public void setCookiesEnabled(boolean enabled) {
        this.cookiesEnabled = enabled;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }
}

