/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.client;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.yammer.dropwizard.client.HttpClientConfiguration;
import com.yammer.dropwizard.validation.ValidationMethod;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

public class JerseyClientConfiguration
extends HttpClientConfiguration {
    @Min(value=1L)
    @Max(value=16384L)
    @JsonProperty
    private int minThreads = 1;
    @Min(value=1L)
    @Max(value=16384L)
    @JsonProperty
    private int maxThreads = 128;
    @JsonProperty
    private boolean gzipEnabled = true;
    @JsonProperty
    private boolean gzipEnabledForRequests = true;

    public int getMinThreads() {
        return this.minThreads;
    }

    public void setMinThreads(int minThreads) {
        this.minThreads = minThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public boolean isGzipEnabled() {
        return this.gzipEnabled;
    }

    public void setGzipEnabled(boolean enabled) {
        this.gzipEnabled = enabled;
    }

    public boolean isGzipEnabledForRequests() {
        return this.gzipEnabledForRequests;
    }

    public void setGzipEnabledForRequests(boolean enabled) {
        this.gzipEnabledForRequests = enabled;
    }

    @ValidationMethod(message=".minThreads must be less than or equal to maxThreads")
    public boolean isThreadPoolSizedCorrectly() {
        return this.minThreads <= this.maxThreads;
    }

    @ValidationMethod(message=".gzipEnabledForRequests requires gzipEnabled set to true")
    public boolean isCompressionConfigurationValid() {
        return !this.gzipEnabledForRequests || this.gzipEnabled;
    }
}

