/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.cli;

import com.google.common.base.Preconditions;
import com.yammer.dropwizard.AbstractService;
import com.yammer.dropwizard.cli.UsagePrinter;
import com.yammer.dropwizard.util.JarLocation;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public abstract class Command {
    private final String name;
    private final String description;

    protected Command(String name, String description) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.description = (String)Preconditions.checkNotNull((Object)description);
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescription() {
        return this.description;
    }

    public Options getOptions() {
        return new Options();
    }

    final Options getOptionsWithHelp() {
        Options options = new Options();
        for (Option option : this.getOptions().getOptions()) {
            options.addOption(option);
        }
        options.addOption("h", "help", false, "display usage information");
        return options;
    }

    protected abstract void run(AbstractService<?> var1, CommandLine var2) throws Exception;

    protected String getSyntax() {
        return "[options]";
    }

    protected String getUsage(Class<?> klass) {
        return String.format("%s %s %s", new JarLocation(klass), this.getName(), this.getSyntax());
    }

    public final void run(AbstractService<?> service, String[] arguments) throws Exception {
        CommandLine cmdLine = new GnuParser().parse(this.getOptionsWithHelp(), (String[])Preconditions.checkNotNull((Object)arguments));
        if (cmdLine.hasOption("help")) {
            this.printHelp(service.getClass());
        } else {
            this.run((AbstractService)Preconditions.checkNotNull(service), cmdLine);
        }
    }

    protected final void printHelp(Class<?> klass) {
        UsagePrinter.printCommandHelp(this, klass);
    }

    protected final void printHelp(String message, Class<?> klass) {
        UsagePrinter.printCommandHelp(this, klass, message);
    }
}

