/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.cli;

import com.yammer.dropwizard.AbstractService;
import com.yammer.dropwizard.cli.Command;
import com.yammer.dropwizard.util.JarLocation;
import org.apache.commons.cli.HelpFormatter;

public class UsagePrinter {
    private UsagePrinter() {
    }

    public static void printRootHelp(AbstractService<?> service) {
        System.out.printf("java -jar %s <command> [arg1 arg2]\n\n", new JarLocation(service.getClass()));
        System.out.println("Commands");
        System.out.println("========\n");
        for (Command command : service.getCommands()) {
            UsagePrinter.printCommandHelp(command, service.getClass());
        }
    }

    public static void printCommandHelp(Command cmd, Class<?> klass) {
        UsagePrinter.printCommandHelp(cmd, klass, null);
    }

    public static void printCommandHelp(Command cmd, Class<?> klass, String errorMessage) {
        if (errorMessage != null) {
            System.err.println(errorMessage);
            System.out.println();
        }
        System.out.println(UsagePrinter.formatTitle(cmd));
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setLongOptPrefix(" --");
        helpFormatter.printHelp(String.format("java -jar %s", cmd.getUsage(klass)), cmd.getOptionsWithHelp());
        System.out.println("\n");
    }

    private static String formatTitle(Command cmd) {
        String title = cmd.getName() + ": " + cmd.getDescription();
        return title + '\n' + UsagePrinter.getBanner(title.length());
    }

    private static String getBanner(int length) {
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            builder.append('-');
        }
        return builder.toString();
    }
}

