/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.config;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.yammer.dropwizard.config.ConfigurationException;
import com.yammer.dropwizard.json.Json;
import com.yammer.dropwizard.validation.Validator;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.node.ObjectNode;

public class ConfigurationFactory<T> {
    private static final String PROPERTY_PREFIX = "dw.";
    private final Class<T> klass;
    private final Json json;
    private final Validator validator;

    public static <T> ConfigurationFactory<T> forClass(Class<T> klass, Validator validator, Iterable<Module> modules) {
        return new ConfigurationFactory<T>(klass, validator, modules);
    }

    public static <T> ConfigurationFactory<T> forClass(Class<T> klass, Validator validator) {
        return new ConfigurationFactory<T>(klass, validator, (Iterable<Module>)ImmutableList.of());
    }

    private ConfigurationFactory(Class<T> klass, Validator validator, Iterable<Module> modules) {
        this.klass = klass;
        this.json = new Json();
        this.json.enable(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES);
        for (Module module : modules) {
            this.json.registerModule(module);
        }
        this.validator = validator;
    }

    public T build(File file) throws IOException, ConfigurationException {
        JsonNode node = this.parse(file);
        for (Map.Entry<Object, Object> pref : System.getProperties().entrySet()) {
            String prefName = (String)pref.getKey();
            if (!prefName.startsWith(PROPERTY_PREFIX)) continue;
            String configName = prefName.substring(PROPERTY_PREFIX.length());
            this.addOverride(node, configName, System.getProperty(prefName));
        }
        T config = this.json.readValue(node, this.klass);
        this.validate(file, config);
        return config;
    }

    private void addOverride(JsonNode root, String name, String value) {
        JsonNode node = root;
        Iterator keys = Splitter.on((char)'.').trimResults().split((CharSequence)name).iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!(node instanceof ObjectNode)) {
                throw new IllegalArgumentException("Unable to override " + name + "; it's not a valid path.");
            }
            ObjectNode obj = (ObjectNode)node;
            if (keys.hasNext()) {
                JsonNode child = obj.get(key);
                if (child == null) {
                    child = obj.objectNode();
                    obj.put(key, child);
                }
                node = child;
                continue;
            }
            obj.put(key, value);
        }
    }

    private JsonNode parse(File file) throws IOException {
        if (file.getName().endsWith(".yaml") || file.getName().endsWith(".yml")) {
            return this.json.readYamlValue(file, JsonNode.class);
        }
        return this.json.readValue(file, JsonNode.class);
    }

    private void validate(File file, T config) throws ConfigurationException {
        ImmutableList<String> errors = this.validator.validate(config);
        if (!errors.isEmpty()) {
            throw new ConfigurationException(file, (Iterable<String>)errors);
        }
    }
}

