/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.sun.jersey.core.reflection.AnnotatedMethod;
import com.sun.jersey.core.reflection.MethodList;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import com.yammer.dropwizard.AbstractService;
import com.yammer.dropwizard.config.Configuration;
import com.yammer.dropwizard.config.FilterConfiguration;
import com.yammer.dropwizard.config.ServletConfiguration;
import com.yammer.dropwizard.jersey.DropwizardResourceConfig;
import com.yammer.dropwizard.jetty.JettyManaged;
import com.yammer.dropwizard.jetty.NonblockingServletHolder;
import com.yammer.dropwizard.lifecycle.ExecutorServiceManager;
import com.yammer.dropwizard.lifecycle.Managed;
import com.yammer.dropwizard.logging.Log;
import com.yammer.dropwizard.tasks.GarbageCollectionTask;
import com.yammer.dropwizard.tasks.Task;
import com.yammer.metrics.core.HealthCheck;
import java.util.EventListener;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.AggregateLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;

public class Environment
extends AbstractLifeCycle {
    private static final Log LOG = Log.forClass(Environment.class);
    private final AbstractService<?> service;
    private final DropwizardResourceConfig config;
    private final ImmutableSet.Builder<HealthCheck> healthChecks;
    private final ImmutableMap.Builder<String, ServletHolder> servlets;
    private final ImmutableMultimap.Builder<String, FilterHolder> filters;
    private final ImmutableSet.Builder<EventListener> servletListeners;
    private final ImmutableSet.Builder<Task> tasks;
    private final AggregateLifeCycle lifeCycle;

    public <T extends Configuration> Environment(AbstractService<T> service, T configuration) {
        this.service = service;
        this.config = new DropwizardResourceConfig(false){

            public void validate() {
                super.validate();
                Environment.this.logResources();
                Environment.this.logProviders();
                Environment.this.logHealthChecks();
                Environment.this.logManagedObjects();
                Environment.this.logEndpoints();
            }
        };
        this.healthChecks = ImmutableSet.builder();
        this.servlets = ImmutableMap.builder();
        this.filters = ImmutableMultimap.builder();
        this.servletListeners = ImmutableSet.builder();
        this.tasks = ImmutableSet.builder();
        this.lifeCycle = new AggregateLifeCycle();
        ServletContainer jerseyContainer = service.getJerseyContainer(this.config, configuration);
        if (jerseyContainer != null) {
            this.addServlet((Servlet)jerseyContainer, configuration.getHttpConfiguration().getRootPath()).setInitOrder(Integer.MAX_VALUE);
        }
        this.addTask(new GarbageCollectionTask());
    }

    protected void doStart() throws Exception {
        this.lifeCycle.start();
    }

    protected void doStop() throws Exception {
        this.lifeCycle.stop();
    }

    public void addResource(Object resource) {
        this.config.getSingletons().add(Preconditions.checkNotNull((Object)resource));
    }

    public void addResource(Class<?> klass) {
        this.config.getClasses().add(Preconditions.checkNotNull(klass));
    }

    public void addProvider(Object provider) {
        this.config.getSingletons().add(Preconditions.checkNotNull((Object)provider));
    }

    public void addProvider(Class<?> klass) {
        this.config.getClasses().add(Preconditions.checkNotNull(klass));
    }

    public void addHealthCheck(HealthCheck healthCheck) {
        this.healthChecks.add(Preconditions.checkNotNull((Object)healthCheck));
    }

    public void manage(Managed managed) {
        this.lifeCycle.addBean((Object)new JettyManaged((Managed)Preconditions.checkNotNull((Object)managed)));
    }

    public void manage(LifeCycle managed) {
        this.lifeCycle.addBean(Preconditions.checkNotNull((Object)managed));
    }

    public ServletConfiguration addServlet(Servlet servlet, String urlPattern) {
        NonblockingServletHolder holder = new NonblockingServletHolder((Servlet)Preconditions.checkNotNull((Object)servlet));
        ServletConfiguration configuration = new ServletConfiguration(holder, this.servlets);
        configuration.addUrlPattern((String)Preconditions.checkNotNull((Object)urlPattern));
        return configuration;
    }

    public ServletConfiguration addServlet(Class<? extends Servlet> klass, String urlPattern) {
        ServletHolder holder = new ServletHolder((Class)Preconditions.checkNotNull(klass));
        ServletConfiguration configuration = new ServletConfiguration(holder, this.servlets);
        configuration.addUrlPattern((String)Preconditions.checkNotNull((Object)urlPattern));
        return configuration;
    }

    public FilterConfiguration addFilter(Filter filter, String urlPattern) {
        FilterHolder holder = new FilterHolder((Filter)Preconditions.checkNotNull((Object)filter));
        FilterConfiguration configuration = new FilterConfiguration(holder, this.filters);
        configuration.addUrlPattern((String)Preconditions.checkNotNull((Object)urlPattern));
        return configuration;
    }

    public FilterConfiguration addFilter(Class<? extends Filter> klass, String urlPattern) {
        FilterHolder holder = new FilterHolder((Class)Preconditions.checkNotNull(klass));
        FilterConfiguration configuration = new FilterConfiguration(holder, this.filters);
        configuration.addUrlPattern((String)Preconditions.checkNotNull((Object)urlPattern));
        return configuration;
    }

    public void addServletListeners(EventListener ... listeners) {
        this.servletListeners.add((Object[])listeners);
    }

    public void addTask(Task task) {
        this.tasks.add(Preconditions.checkNotNull((Object)task));
    }

    public void enableJerseyFeature(String name) {
        this.config.getFeatures().put(Preconditions.checkNotNull((Object)name), Boolean.TRUE);
    }

    public void disableJerseyFeature(String name) {
        this.config.getFeatures().put(Preconditions.checkNotNull((Object)name), Boolean.FALSE);
    }

    public void setJerseyProperty(String name, @Nullable Object value) {
        this.config.getProperties().put(Preconditions.checkNotNull((Object)name), value);
    }

    public ExecutorService managedExecutorService(String nameFormat, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(nameFormat).build();
        ThreadPoolExecutor executor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, new LinkedBlockingQueue<Runnable>(), threadFactory);
        this.manage(new ExecutorServiceManager(executor, 5L, TimeUnit.SECONDS));
        return executor;
    }

    public ScheduledExecutorService managedScheduledExecutorService(String nameFormat, int corePoolSize) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(nameFormat).build();
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(corePoolSize, threadFactory);
        this.manage(new ExecutorServiceManager(executor, 5L, TimeUnit.SECONDS));
        return executor;
    }

    ImmutableSet<HealthCheck> getHealthChecks() {
        return this.healthChecks.build();
    }

    ImmutableMap<String, ServletHolder> getServlets() {
        return this.servlets.build();
    }

    ImmutableMultimap<String, FilterHolder> getFilters() {
        return this.filters.build();
    }

    ImmutableSet<Task> getTasks() {
        return this.tasks.build();
    }

    ImmutableSet<EventListener> getServletListeners() {
        return this.servletListeners.build();
    }

    private void logManagedObjects() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Object bean : this.lifeCycle.getBeans()) {
            builder.add((Object)bean.getClass().getCanonicalName());
        }
        LOG.debug("managed objects = {}", (Object)builder.build());
    }

    private void logHealthChecks() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (HealthCheck healthCheck : this.healthChecks.build()) {
            builder.add((Object)healthCheck.getClass().getCanonicalName());
        }
        LOG.debug("health checks = {}", (Object)builder.build());
    }

    private void logResources() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Class klass : this.config.getClasses()) {
            if (!klass.isAnnotationPresent(Path.class)) continue;
            builder.add((Object)klass.getCanonicalName());
        }
        for (Object o : this.config.getSingletons()) {
            if (!o.getClass().isAnnotationPresent(Path.class)) continue;
            builder.add((Object)o.getClass().getCanonicalName());
        }
        LOG.debug("resources = {}", (Object)builder.build());
    }

    private void logProviders() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Class klass : this.config.getClasses()) {
            if (!klass.isAnnotationPresent(Provider.class)) continue;
            builder.add((Object)klass.getCanonicalName());
        }
        for (Object o : this.config.getSingletons()) {
            if (!o.getClass().isAnnotationPresent(Provider.class)) continue;
            builder.add((Object)o.getClass().getCanonicalName());
        }
        LOG.debug("providers = {}", (Object)builder.build());
    }

    private void logEndpoints() {
        StringBuilder stringBuilder = new StringBuilder(1024).append("\n\n");
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Object o : this.config.getSingletons()) {
            if (!o.getClass().isAnnotationPresent(Path.class)) continue;
            builder.add(o.getClass());
        }
        for (Class klass : this.config.getClasses()) {
            if (!klass.isAnnotationPresent(Path.class)) continue;
            builder.add((Object)klass);
        }
        for (Class klass : builder.build()) {
            String path = klass.getAnnotation(Path.class).value();
            ImmutableList.Builder endpoints = ImmutableList.builder();
            for (AnnotatedMethod method : this.annotatedMethods(klass)) {
                String methodPath = "";
                if (method.isAnnotationPresent(Path.class) && !(methodPath = ((Path)method.getAnnotation(Path.class)).value()).startsWith("/") && !path.endsWith("/")) {
                    methodPath = "/" + methodPath;
                }
                for (HttpMethod verb : method.getMetaMethodAnnotations(HttpMethod.class)) {
                    endpoints.add((Object)String.format("    %-7s %s (%s)", verb.value(), path + methodPath, klass.getCanonicalName()));
                }
            }
            for (String line : Ordering.natural().sortedCopy((Iterable)endpoints.build())) {
                stringBuilder.append(line).append('\n');
            }
        }
        LOG.info(stringBuilder.toString());
    }

    private MethodList annotatedMethods(Class<?> resource) {
        return new MethodList(resource, true).hasMetaAnnotation(HttpMethod.class);
    }

    public AbstractService<?> getService() {
        return this.service;
    }
}

