/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.config;

import ch.qos.logback.classic.Level;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.yammer.dropwizard.validation.ValidationMethod;
import java.util.TimeZone;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.codehaus.jackson.annotate.JsonProperty;

public class LoggingConfiguration {
    static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    @NotNull
    @JsonProperty
    protected Level level = Level.INFO;
    @NotNull
    @JsonProperty
    protected ImmutableMap<String, Level> loggers = ImmutableMap.of();
    @Valid
    @NotNull
    @JsonProperty
    protected ConsoleConfiguration console = new ConsoleConfiguration();
    @Valid
    @NotNull
    @JsonProperty
    protected FileConfiguration file = new FileConfiguration();
    @Valid
    @NotNull
    @JsonProperty
    protected SyslogConfiguration syslog = new SyslogConfiguration();

    public Level getLevel() {
        return this.level;
    }

    public ImmutableMap<String, Level> getLoggers() {
        return this.loggers;
    }

    public ConsoleConfiguration getConsoleConfiguration() {
        return this.console;
    }

    public FileConfiguration getFileConfiguration() {
        return this.file;
    }

    public SyslogConfiguration getSyslogConfiguration() {
        return this.syslog;
    }

    public static class SyslogConfiguration {
        @JsonProperty
        protected boolean enabled = false;
        @NotNull
        @JsonProperty
        protected Level threshold = Level.ALL;
        @NotNull
        @JsonProperty
        protected String host = "localhost";
        @NotNull
        @JsonProperty
        @Pattern(regexp="(auth|authpriv|daemon|cron|ftp|lpr|kern|mail|news|syslog|user|uucp|local[0-7])", message="must be a valid syslog facility")
        protected String facility = "local0";
        @NotNull
        @JsonProperty
        protected TimeZone timeZone = UTC;
        @JsonProperty
        protected String logFormat;

        public boolean isEnabled() {
            return this.enabled;
        }

        public Level getThreshold() {
            return this.threshold;
        }

        public String getHost() {
            return this.host;
        }

        public String getFacility() {
            return this.facility;
        }

        public TimeZone getTimeZone() {
            return this.timeZone;
        }

        public Optional<String> getLogFormat() {
            return Optional.fromNullable((Object)this.logFormat);
        }
    }

    public static class FileConfiguration {
        @JsonProperty
        protected boolean enabled = false;
        @NotNull
        @JsonProperty
        protected Level threshold = Level.ALL;
        @JsonProperty
        protected String currentLogFilename;
        @JsonProperty
        protected String archivedLogFilenamePattern;
        @Min(value=1L)
        @Max(value=50L)
        @JsonProperty
        protected int archivedFileCount = 5;
        @NotNull
        @JsonProperty
        protected TimeZone timeZone = UTC;
        @JsonProperty
        protected String logFormat;

        @ValidationMethod(message="must have logging.file.currentLogFilename and logging.file.archivedLogFilenamePattern if logging.file.enabled is true")
        public boolean isConfigured() {
            return !this.enabled || this.currentLogFilename != null && this.archivedLogFilenamePattern != null;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Level getThreshold() {
            return this.threshold;
        }

        public String getCurrentLogFilename() {
            return this.currentLogFilename;
        }

        public int getArchivedFileCount() {
            return this.archivedFileCount;
        }

        public String getArchivedLogFilenamePattern() {
            return this.archivedLogFilenamePattern;
        }

        public TimeZone getTimeZone() {
            return this.timeZone;
        }

        public Optional<String> getLogFormat() {
            return Optional.fromNullable((Object)this.logFormat);
        }
    }

    public static class ConsoleConfiguration {
        @JsonProperty
        protected boolean enabled = true;
        @NotNull
        @JsonProperty
        protected Level threshold = Level.ALL;
        @NotNull
        @JsonProperty
        protected TimeZone timeZone = UTC;
        @JsonProperty
        protected String logFormat;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public Level getThreshold() {
            return this.threshold;
        }

        public void setThreshold(Level threshold) {
            this.threshold = threshold;
        }

        public TimeZone getTimeZone() {
            return this.timeZone;
        }

        public void setTimeZone(TimeZone timeZone) {
            this.timeZone = timeZone;
        }

        public Optional<String> getLogFormat() {
            return Optional.fromNullable((Object)this.logFormat);
        }
    }
}

