/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.config;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.yammer.dropwizard.config.ConfigurationException;
import com.yammer.dropwizard.config.Environment;
import com.yammer.dropwizard.config.GzipConfiguration;
import com.yammer.dropwizard.config.HttpConfiguration;
import com.yammer.dropwizard.config.RequestLogHandlerFactory;
import com.yammer.dropwizard.jetty.BiDiGzipHandler;
import com.yammer.dropwizard.jetty.InstrumentedSslSelectChannelConnector;
import com.yammer.dropwizard.jetty.InstrumentedSslSocketConnector;
import com.yammer.dropwizard.jetty.UnbrandedErrorHandler;
import com.yammer.dropwizard.logging.Log;
import com.yammer.dropwizard.servlets.ThreadNameFilter;
import com.yammer.dropwizard.tasks.Task;
import com.yammer.dropwizard.tasks.TaskServlet;
import com.yammer.dropwizard.util.Duration;
import com.yammer.dropwizard.util.Size;
import com.yammer.metrics.HealthChecks;
import com.yammer.metrics.core.HealthCheck;
import com.yammer.metrics.jetty.InstrumentedBlockingChannelConnector;
import com.yammer.metrics.jetty.InstrumentedHandler;
import com.yammer.metrics.jetty.InstrumentedQueuedThreadPool;
import com.yammer.metrics.jetty.InstrumentedSelectChannelConnector;
import com.yammer.metrics.jetty.InstrumentedSocketConnector;
import com.yammer.metrics.reporting.AdminServlet;
import com.yammer.metrics.util.DeadlockHealthCheck;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.Map;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.nio.AbstractNIOConnector;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class ServerFactory {
    private static final Log LOG = Log.forClass(ServerFactory.class);
    private final HttpConfiguration config;
    private final RequestLogHandlerFactory requestLogHandlerFactory;

    public ServerFactory(HttpConfiguration config, String name) {
        this.config = config;
        this.requestLogHandlerFactory = new RequestLogHandlerFactory(config.getRequestLogConfiguration(), name);
    }

    public Server buildServer(Environment env) throws ConfigurationException {
        HealthChecks.register((HealthCheck)new DeadlockHealthCheck());
        for (HealthCheck healthCheck : env.getHealthChecks()) {
            HealthChecks.register((HealthCheck)healthCheck);
        }
        if (env.getHealthChecks().isEmpty()) {
            LOG.warn("\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n!    THIS SERVICE HAS NO HEALTHCHECKS. THIS MEANS YOU WILL NEVER KNOW IF IT    !\n!    DIES IN PRODUCTION, WHICH MEANS YOU WILL NEVER KNOW IF YOU'RE LETTING     !\n!     YOUR USERS DOWN. YOU SHOULD ADD A HEALTHCHECK FOR EACH DEPENDENCY OF     !\n!     YOUR SERVICE WHICH FULLY (BUT LIGHTLY) TESTS YOUR SERVICE'S ABILITY TO   !\n!      USE THAT SERVICE. THINK OF IT AS A CONTINUOUS INTEGRATION TEST.         !\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
        Server server = this.createServer();
        server.setHandler(this.createHandler(env));
        server.addBean((Object)env);
        return server;
    }

    private Server createServer() {
        Server server = new Server();
        server.addConnector(this.createExternalConnector());
        if (this.config.getAdminPort() != this.config.getPort()) {
            server.addConnector(this.createInternalConnector());
        }
        server.addBean((Object)new UnbrandedErrorHandler());
        server.setSendDateHeader(this.config.isDateHeaderEnabled());
        server.setSendServerVersion(this.config.isServerHeaderEnabled());
        server.setThreadPool(this.createThreadPool());
        server.setStopAtShutdown(true);
        server.setGracefulShutdown((int)this.config.getShutdownGracePeriod().toMilliseconds());
        return server;
    }

    private Connector createExternalConnector() {
        AbstractConnector connector = this.createConnector(this.config.getPort());
        connector.setHost((String)this.config.getBindHost().orNull());
        connector.setAcceptors(this.config.getAcceptorThreadCount());
        connector.setForwarded(this.config.useForwardedHeaders());
        connector.setMaxIdleTime((int)this.config.getMaxIdleTime().toMilliseconds());
        connector.setLowResourcesMaxIdleTime((int)this.config.getLowResourcesMaxIdleTime().toMilliseconds());
        connector.setAcceptorPriorityOffset(this.config.getAcceptorThreadPriorityOffset());
        connector.setAcceptQueueSize(this.config.getAcceptQueueSize());
        connector.setMaxBuffers(this.config.getMaxBufferCount());
        connector.setRequestBufferSize((int)this.config.getRequestBufferSize().toBytes());
        connector.setRequestHeaderSize((int)this.config.getRequestHeaderBufferSize().toBytes());
        connector.setResponseBufferSize((int)this.config.getResponseBufferSize().toBytes());
        connector.setResponseHeaderSize((int)this.config.getResponseHeaderBufferSize().toBytes());
        connector.setReuseAddress(this.config.isReuseAddressEnabled());
        Optional<Duration> lingerTime = this.config.getSoLingerTime();
        if (lingerTime.isPresent()) {
            connector.setSoLingerTime((int)((Duration)lingerTime.get()).toMilliseconds());
        }
        connector.setPort(this.config.getPort());
        connector.setName("main");
        return connector;
    }

    private AbstractConnector createConnector(int port) {
        Object connector;
        switch (this.config.getConnectorType()) {
            case BLOCKING_CHANNEL: {
                connector = new InstrumentedBlockingChannelConnector(port);
                break;
            }
            case SOCKET: {
                connector = new InstrumentedSocketConnector(port);
                break;
            }
            case SOCKET_SSL: {
                connector = new InstrumentedSslSocketConnector(port);
                break;
            }
            case SELECT_CHANNEL: {
                connector = new InstrumentedSelectChannelConnector(port);
                break;
            }
            case SELECT_CHANNEL_SSL: {
                connector = new InstrumentedSslSelectChannelConnector(port);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid connector type: " + (Object)((Object)this.config.getConnectorType()));
            }
        }
        if (connector instanceof SslConnector) {
            this.configureSslContext(((SslConnector)connector).getSslContextFactory());
        }
        if (connector instanceof SelectChannelConnector) {
            ((SelectChannelConnector)connector).setLowResourcesConnections(this.config.getLowResourcesConnectionThreshold());
        }
        if (connector instanceof AbstractNIOConnector) {
            ((AbstractNIOConnector)connector).setUseDirectBuffers(this.config.useDirectBuffers());
        }
        return connector;
    }

    private void configureSslContext(SslContextFactory factory) {
        for (String path : this.config.getSslConfiguration().getKeyStorePath().asSet()) {
            factory.setKeyStorePath(path);
        }
        for (String password : this.config.getSslConfiguration().getKeyStorePassword().asSet()) {
            factory.setKeyStorePassword(password);
        }
        for (String password : this.config.getSslConfiguration().getKeyManagerPassword().asSet()) {
            factory.setKeyManagerPassword(password);
        }
    }

    private Handler createHandler(Environment env) {
        HandlerCollection collection = new HandlerCollection();
        collection.addHandler(this.createInternalServlet(env));
        collection.addHandler(this.createExternalServlet(env.getServlets(), env.getFilters(), env.getServletListeners()));
        if (this.requestLogHandlerFactory.isEnabled()) {
            collection.addHandler((Handler)this.requestLogHandlerFactory.build());
        }
        return collection;
    }

    private Handler createInternalServlet(Environment env) {
        ServletContextHandler handler = new ServletContextHandler();
        handler.addServlet(new ServletHolder((Servlet)new TaskServlet((Iterable<Task>)env.getTasks())), "/tasks/*");
        handler.addServlet(new ServletHolder((Servlet)new AdminServlet()), "/*");
        if (this.config.getAdminPort() == this.config.getPort()) {
            handler.setContextPath("/admin");
            handler.setConnectorNames(new String[]{"main"});
        } else {
            handler.setConnectorNames(new String[]{"internal"});
        }
        if (this.config.getAdminUsername().isPresent() || this.config.getAdminPassword().isPresent()) {
            handler.setSecurityHandler(this.basicAuthHandler((String)this.config.getAdminUsername().or((Object)""), (String)this.config.getAdminPassword().or((Object)"")));
        }
        return handler;
    }

    private SecurityHandler basicAuthHandler(String username, String password) {
        HashLoginService loginService = new HashLoginService();
        loginService.putUser(username, Credential.getCredential((String)password), new String[]{"user"});
        loginService.setName("admin");
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(new String[]{"user"});
        constraint.setAuthenticate(true);
        ConstraintMapping constraintMapping = new ConstraintMapping();
        constraintMapping.setConstraint(constraint);
        constraintMapping.setPathSpec("/*");
        ConstraintSecurityHandler csh = new ConstraintSecurityHandler();
        csh.setAuthenticator((Authenticator)new BasicAuthenticator());
        csh.setRealmName("admin");
        csh.addConstraintMapping(constraintMapping);
        csh.setLoginService((LoginService)loginService);
        return csh;
    }

    private Handler createExternalServlet(ImmutableMap<String, ServletHolder> servlets, ImmutableMultimap<String, FilterHolder> filters, ImmutableSet<EventListener> listeners) {
        ServletContextHandler handler = new ServletContextHandler();
        handler.addFilter(ThreadNameFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        handler.setBaseResource(Resource.newClassPathResource((String)"."));
        for (Map.Entry entry : servlets.entrySet()) {
            handler.addServlet((ServletHolder)entry.getValue(), (String)entry.getKey());
        }
        for (Map.Entry entry : filters.entries()) {
            handler.addFilter((FilterHolder)entry.getValue(), (String)entry.getKey(), EnumSet.of(DispatcherType.REQUEST));
        }
        for (EventListener listener : listeners) {
            handler.addEventListener(listener);
        }
        for (Map.Entry entry : this.config.getContextParameters().entrySet()) {
            handler.setInitParameter((String)entry.getKey(), (String)entry.getValue());
        }
        handler.setConnectorNames(new String[]{"main"});
        return this.wrapHandler(handler);
    }

    private Handler wrapHandler(ServletContextHandler handler) {
        InstrumentedHandler instrumented = new InstrumentedHandler((Handler)handler);
        GzipConfiguration gzip = this.config.getGzipConfiguration();
        if (gzip.isEnabled()) {
            Optional<ImmutableSet<String>> mimeTypes;
            Optional<ImmutableSet<String>> userAgents;
            Optional<Size> bufferSize;
            BiDiGzipHandler gzipHandler = new BiDiGzipHandler((Handler)instrumented);
            Optional<Size> minEntitySize = gzip.getMinimumEntitySize();
            if (minEntitySize.isPresent()) {
                gzipHandler.setMinGzipSize((int)((Size)minEntitySize.get()).toBytes());
            }
            if ((bufferSize = gzip.getBufferSize()).isPresent()) {
                gzipHandler.setBufferSize((int)((Size)bufferSize.get()).toBytes());
            }
            if ((userAgents = gzip.getExcludedUserAgents()).isPresent()) {
                gzipHandler.setExcluded((Set)userAgents.get());
            }
            if ((mimeTypes = gzip.getCompressedMimeTypes()).isPresent()) {
                gzipHandler.setMimeTypes((Set)mimeTypes.get());
            }
            return gzipHandler;
        }
        return instrumented;
    }

    private ThreadPool createThreadPool() {
        InstrumentedQueuedThreadPool pool = new InstrumentedQueuedThreadPool();
        pool.setMinThreads(this.config.getMinThreads());
        pool.setMaxThreads(this.config.getMaxThreads());
        return pool;
    }

    private Connector createInternalConnector() {
        SocketConnector connector = new SocketConnector();
        connector.setPort(this.config.getAdminPort());
        connector.setName("internal");
        connector.setThreadPool((ThreadPool)new QueuedThreadPool(8));
        return connector;
    }
}

