/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.jersey;

import com.yammer.dropwizard.jetty.UnbrandedErrorHandler;
import com.yammer.dropwizard.logging.Log;
import com.yammer.dropwizard.validation.InvalidEntityException;
import java.io.IOException;
import java.io.StringWriter;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class InvalidEntityExceptionMapper
implements ExceptionMapper<InvalidEntityException> {
    private static final Log LOG = Log.forClass(InvalidEntityExceptionMapper.class);
    private static final int UNPROCESSABLE_ENTITY = 422;
    @Context
    private HttpServletRequest request;
    private final UnbrandedErrorHandler errorHandler = new UnbrandedErrorHandler();

    public Response toResponse(InvalidEntityException exception) {
        StringWriter writer = new StringWriter(4096);
        try {
            this.errorHandler.writeValidationErrorPage(this.request, writer, exception);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Unable to generate error page", new Object[0]);
        }
        return Response.status((int)422).type(MediaType.TEXT_HTML_TYPE).entity((Object)writer.toString()).build();
    }
}

