/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.jersey;

import com.google.common.base.Splitter;
import com.yammer.dropwizard.jetty.UnbrandedErrorHandler;
import com.yammer.dropwizard.logging.Log;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonProcessingException;

public class JsonProcessingExceptionMapper
implements ExceptionMapper<JsonProcessingException> {
    private static final Log LOG = Log.forClass(JsonProcessingExceptionMapper.class);
    private static final Splitter LINE_SPLITTER = Splitter.on((String)"\n").trimResults();
    @Context
    private HttpServletRequest request;
    private final UnbrandedErrorHandler errorHandler = new UnbrandedErrorHandler();

    public Response toResponse(JsonProcessingException exception) {
        if (exception instanceof JsonGenerationException) {
            LOG.warn((Throwable)exception, "Error generating JSON", new Object[0]);
            return Response.serverError().build();
        }
        String message = exception.getMessage();
        if (message.startsWith("No suitable constructor found")) {
            LOG.error((Throwable)exception, "Unable to deserialize the specific type", new Object[0]);
            return Response.serverError().build();
        }
        try {
            LOG.debug((Throwable)exception, "Unable to process JSON", new Object[0]);
            StringWriter writer = new StringWriter(4096);
            this.errorHandler.writeErrorPage(this.request, writer, 400, this.stripLocation(message), false);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.TEXT_HTML_TYPE).entity((Object)writer.toString()).build();
        }
        catch (IOException e) {
            LOG.debug((Throwable)e, "Unable to output error message", new Object[0]);
            return Response.serverError().build();
        }
    }

    private String stripLocation(String message) {
        Iterator i$ = LINE_SPLITTER.split((CharSequence)message).iterator();
        if (i$.hasNext()) {
            String s = (String)i$.next();
            return s;
        }
        return message;
    }
}

