/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.jersey;

import com.yammer.dropwizard.jetty.UnbrandedErrorHandler;
import com.yammer.dropwizard.logging.Log;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class LoggingExceptionMapper<E extends Throwable>
implements ExceptionMapper<E> {
    private static final Log LOG = Log.forClass(LoggingExceptionMapper.class);
    private static final Random RANDOM = new Random();
    @Context
    private HttpServletRequest request;
    private final UnbrandedErrorHandler errorHandler = new UnbrandedErrorHandler();

    public Response toResponse(E exception) {
        if (exception instanceof WebApplicationException) {
            return ((WebApplicationException)exception).getResponse();
        }
        StringWriter writer = new StringWriter(4096);
        try {
            long id = LoggingExceptionMapper.randomId();
            this.logException(id, exception);
            this.errorHandler.writeErrorPage(this.request, writer, 500, this.formatResponseEntity(id, (Throwable)exception), false);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Unable to generate error page", new Object[0]);
        }
        return Response.serverError().type(MediaType.TEXT_HTML_TYPE).entity((Object)writer.toString()).build();
    }

    protected void logException(long id, E exception) {
        LOG.error((Throwable)exception, this.formatLogMessage(id, (Throwable)exception), new Object[0]);
    }

    protected String formatResponseEntity(long id, Throwable exception) {
        return String.format("There was an error processing your request. It has been logged (ID %016x).\n", id);
    }

    protected String formatLogMessage(long id, Throwable exception) {
        return String.format("Error handling a request: %016x", id);
    }

    protected static long randomId() {
        return RANDOM.nextLong();
    }
}

