/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.jetty;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.GzipHandler;

public class BiDiGzipHandler
extends GzipHandler {
    private static final String GZIP_ENCODING = "gzip";

    public BiDiGzipHandler(Handler underlying) {
        this.setHandler(underlying);
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (GZIP_ENCODING.equalsIgnoreCase(request.getHeader("Content-Encoding"))) {
            super.handle(target, baseRequest, (HttpServletRequest)new GzipServletRequest(request, this.getBufferSize()), response);
        } else {
            super.handle(target, baseRequest, request, response);
        }
    }

    private static class GzipServletRequest
    extends HttpServletRequestWrapper {
        private final ServletInputStream input;
        private final BufferedReader reader;

        private GzipServletRequest(HttpServletRequest request, int bufferSize) throws IOException {
            super(request);
            this.input = new GzipServletInputStream(request, bufferSize);
            this.reader = new BufferedReader(new InputStreamReader((InputStream)this.input));
        }

        public ServletInputStream getInputStream() throws IOException {
            return this.input;
        }

        public BufferedReader getReader() throws IOException {
            return this.reader;
        }
    }

    private static class GzipServletInputStream
    extends ServletInputStream {
        private final GZIPInputStream input;

        private GzipServletInputStream(HttpServletRequest request, int bufferSize) throws IOException {
            this.input = new GZIPInputStream((InputStream)request.getInputStream(), bufferSize);
        }

        public void close() throws IOException {
            this.input.close();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.input.read(b, off, len);
        }

        public int available() throws IOException {
            return this.input.available();
        }

        public void mark(int readlimit) {
            this.input.mark(readlimit);
        }

        public boolean markSupported() {
            return this.input.markSupported();
        }

        public int read() throws IOException {
            return this.input.read();
        }

        public void reset() throws IOException {
            this.input.reset();
        }

        public long skip(long n) throws IOException {
            return this.input.skip(n);
        }

        public int read(byte[] b) throws IOException {
            return this.input.read(b);
        }
    }
}

