/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.servlets;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheBuilderSpec;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.hash.Hashing;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.Buffer;

public class AssetServlet
extends HttpServlet {
    private static final long serialVersionUID = 6393345594784987908L;
    private static final String DEFAULT_MIME_TYPE = "text/html";
    private final transient LoadingCache<String, CachedAsset> cache;
    private final transient MimeTypes mimeTypes;

    public AssetServlet(String resourcePath, CacheBuilderSpec cacheBuilderSpec, String uriPath) {
        this.cache = CacheBuilder.from((CacheBuilderSpec)cacheBuilderSpec).build((CacheLoader)new AssetLoader(resourcePath, uriPath, "index.htm"));
        this.mimeTypes = new MimeTypes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            CachedAsset cachedAsset = (CachedAsset)this.cache.getUnchecked((Object)req.getRequestURI());
            if (this.isCachedClientSide(req, cachedAsset)) {
                resp.sendError(304);
                return;
            }
            resp.setDateHeader("Last-Modified", cachedAsset.getLastModifiedTime());
            resp.setHeader("ETag", cachedAsset.getETag());
            Buffer mimeType = this.mimeTypes.getMimeByExtension(req.getRequestURI());
            if (mimeType == null) {
                resp.setContentType(DEFAULT_MIME_TYPE);
            } else {
                resp.setContentType(mimeType.toString());
            }
            ServletOutputStream output = resp.getOutputStream();
            try {
                output.write(cachedAsset.getResource());
            }
            finally {
                output.close();
            }
        }
        catch (RuntimeException ignored) {
            resp.sendError(404);
        }
    }

    private boolean isCachedClientSide(HttpServletRequest req, CachedAsset cachedAsset) {
        return cachedAsset.getETag().equals(req.getHeader("If-None-Match")) || req.getDateHeader("If-Modified-Since") >= cachedAsset.getLastModifiedTime();
    }

    private static class CachedAsset {
        private final byte[] resource;
        private final String eTag;
        private final long lastModifiedTime;

        private CachedAsset(byte[] resource) {
            this.resource = resource;
            this.eTag = Hashing.murmur3_128().hashBytes(resource).toString();
            this.lastModifiedTime = this.roundedTimestamp();
        }

        private long roundedTimestamp() {
            return System.currentTimeMillis() / 1000L * 1000L;
        }

        public byte[] getResource() {
            return this.resource;
        }

        public String getETag() {
            return this.eTag;
        }

        public long getLastModifiedTime() {
            return this.lastModifiedTime;
        }
    }

    private static class AssetLoader
    extends CacheLoader<String, CachedAsset> {
        private final String resourcePath;
        private final String uriPath;
        private final String indexFilename;

        private AssetLoader(String resourcePath, String uriPath, String indexFilename) {
            this.resourcePath = resourcePath;
            this.uriPath = uriPath;
            this.indexFilename = indexFilename;
        }

        public CachedAsset load(String key) throws Exception {
            String resource = key.substring(this.uriPath.length());
            String fullResourcePath = this.resourcePath + resource;
            if (key.equals(this.uriPath)) {
                fullResourcePath = this.resourcePath + this.indexFilename;
            }
            URL resourceURL = Resources.getResource((String)fullResourcePath.substring(1));
            return new CachedAsset(Resources.toByteArray((URL)resourceURL));
        }
    }
}

