/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.servlets;

import com.yammer.dropwizard.logging.Log;
import com.yammer.dropwizard.util.Duration;
import com.yammer.dropwizard.util.Servlets;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class SlowRequestFilter
implements Filter {
    private static final Log LOG = Log.forClass(SlowRequestFilter.class);
    private final long threshold;

    public SlowRequestFilter() {
        this(Duration.seconds(1L));
    }

    public SlowRequestFilter(Duration threshold) {
        this.threshold = threshold.toNanoseconds();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        long elapsedMS;
        HttpServletRequest req = (HttpServletRequest)request;
        long startTime = System.nanoTime();
        try {
            chain.doFilter(request, response);
            elapsedMS = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
            if (elapsedMS < this.threshold) return;
        }
        catch (Throwable throwable) {
            long elapsedMS2 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
            if (elapsedMS2 < this.threshold) throw throwable;
            LOG.warn("Slow request: {} {} ({}ms)", req.getMethod(), Servlets.getFullUrl(req), elapsedMS2);
            throw throwable;
        }
        LOG.warn("Slow request: {} {} ({}ms)", req.getMethod(), Servlets.getFullUrl(req), elapsedMS);
    }
}

