/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.validation;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.yammer.dropwizard.validation.ValidationMethod;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;

public class Validator {
    private final ValidatorFactory factory = Validation.buildDefaultValidatorFactory();

    public <T> ImmutableList<String> validate(T o) {
        HashSet errors = Sets.newHashSet();
        Set violations = this.factory.getValidator().validate(o, new Class[0]);
        for (ConstraintViolation v : violations) {
            if (v.getConstraintDescriptor().getAnnotation() instanceof ValidationMethod) {
                ImmutableList nodes = ImmutableList.copyOf((Iterable)v.getPropertyPath());
                ImmutableList usefulNodes = nodes.subList(0, nodes.size() - 1);
                String msg = v.getMessage().startsWith(".") ? "%s%s" : "%s %s";
                errors.add(String.format(msg, Joiner.on((char)'.').join((Iterable)usefulNodes), v.getMessage()).trim());
                continue;
            }
            errors.add(String.format("%s %s (was %s)", v.getPropertyPath(), v.getMessage(), v.getInvalidValue()));
        }
        return ImmutableList.copyOf((Collection)Ordering.natural().sortedCopy((Iterable)errors));
    }
}

