/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.assets;

import com.yammer.dropwizard.assets.ResourceNotFoundException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class ResourceURL {
    private ResourceURL() {
    }

    public static boolean isDirectory(URL resourceURL) throws URISyntaxException {
        String protocol = resourceURL.getProtocol();
        if ("jar".equals(protocol)) {
            try {
                ZipEntry zipEntry;
                JarURLConnection jarConnection = (JarURLConnection)resourceURL.openConnection();
                JarEntry entry = jarConnection.getJarEntry();
                if (entry.isDirectory()) {
                    return true;
                }
                String filename = resourceURL.getFile();
                filename = filename.substring(filename.indexOf(33) + 2);
                JarFile jarFile = jarConnection.getJarFile();
                InputStream inputStream = jarFile.getInputStream(zipEntry = jarFile.getEntry(filename));
                return inputStream == null;
            }
            catch (IOException e) {
                throw new ResourceNotFoundException(e);
            }
        }
        if ("file".equals(protocol)) {
            return new File(resourceURL.toURI()).isDirectory();
        }
        throw new IllegalArgumentException("Unsupported protocol " + resourceURL.getProtocol() + " for resource " + resourceURL);
    }

    public static URL appendTrailingSlash(URL originalURL) {
        try {
            return originalURL.getPath().endsWith("/") ? originalURL : new URL(originalURL.getProtocol(), originalURL.getHost(), originalURL.getPort(), originalURL.getFile() + '/');
        }
        catch (MalformedURLException ignored) {
            throw new IllegalArgumentException("Invalid resource URL: " + originalURL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLastModified(URL resourceURL) {
        String protocol = resourceURL.getProtocol();
        if ("jar".equals(protocol)) {
            try {
                JarURLConnection jarConnection = (JarURLConnection)resourceURL.openConnection();
                JarEntry entry = jarConnection.getJarEntry();
                return entry.getTime();
            }
            catch (IOException ignored) {
                return 0L;
            }
        }
        if ("file".equals(protocol)) {
            URLConnection connection = null;
            try {
                connection = resourceURL.openConnection();
                long entry = connection.getLastModified();
                return entry;
            }
            catch (IOException ignored) {
                long l = 0L;
                return l;
            }
            finally {
                if (connection != null) {
                    try {
                        connection.getInputStream().close();
                    }
                    catch (IOException ignored) {}
                }
            }
        }
        throw new IllegalArgumentException("Unsupported protocol " + resourceURL.getProtocol() + " for resource " + resourceURL);
    }
}

