/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.yammer.dropwizard.Bundle;
import com.yammer.dropwizard.ConfiguredBundle;
import com.yammer.dropwizard.Service;
import com.yammer.dropwizard.cli.Command;
import com.yammer.dropwizard.cli.ConfiguredCommand;
import com.yammer.dropwizard.config.Configuration;
import com.yammer.dropwizard.config.Environment;
import com.yammer.dropwizard.json.ObjectMapperFactory;
import java.util.List;

public class Bootstrap<T extends Configuration> {
    private String name;
    private final ObjectMapperFactory objectMapperFactory;
    private final List<Bundle> bundles;
    private final List<ConfiguredBundle<? super T>> configuredBundles;
    private final List<Command> commands;

    public Bootstrap(Service<T> service) {
        this.name = service.getClass().getSimpleName();
        this.objectMapperFactory = new ObjectMapperFactory();
        this.bundles = Lists.newArrayList();
        this.configuredBundles = Lists.newArrayList();
        this.commands = Lists.newArrayList();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addBundle(Bundle bundle) {
        bundle.initialize(this);
        this.bundles.add(bundle);
    }

    public void addBundle(ConfiguredBundle<? super T> bundle) {
        this.configuredBundles.add(bundle);
    }

    public void addCommand(Command command) {
        this.commands.add(command);
    }

    public void addCommand(ConfiguredCommand<T> command) {
        this.commands.add(command);
    }

    public ObjectMapperFactory getObjectMapperFactory() {
        return this.objectMapperFactory;
    }

    public void runWithBundles(T configuration, Environment environment) throws Exception {
        for (Bundle bundle : this.bundles) {
            bundle.run(environment);
        }
        for (ConfiguredBundle configuredBundle : this.configuredBundles) {
            configuredBundle.run(configuration, environment);
        }
    }

    public ImmutableList<Command> getCommands() {
        return ImmutableList.copyOf(this.commands);
    }
}

