/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.core.reflection.AnnotatedMethod;
import com.sun.jersey.core.reflection.MethodList;
import com.sun.jersey.core.spi.scanning.PackageNamesScanner;
import com.sun.jersey.core.spi.scanning.Scanner;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import com.yammer.dropwizard.config.Configuration;
import com.yammer.dropwizard.config.FilterBuilder;
import com.yammer.dropwizard.config.ServletBuilder;
import com.yammer.dropwizard.jersey.DropwizardResourceConfig;
import com.yammer.dropwizard.jetty.JettyManaged;
import com.yammer.dropwizard.jetty.NonblockingServletHolder;
import com.yammer.dropwizard.json.ObjectMapperFactory;
import com.yammer.dropwizard.lifecycle.ExecutorServiceManager;
import com.yammer.dropwizard.lifecycle.Managed;
import com.yammer.dropwizard.lifecycle.ServerLifecycleListener;
import com.yammer.dropwizard.tasks.GarbageCollectionTask;
import com.yammer.dropwizard.tasks.Task;
import com.yammer.dropwizard.validation.Validator;
import com.yammer.metrics.core.HealthCheck;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Provider;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.AggregateLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Environment
extends AbstractLifeCycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(Environment.class);
    private final String name;
    private final Configuration configuration;
    private final DropwizardResourceConfig config;
    private final ImmutableSet.Builder<HealthCheck> healthChecks;
    private final ImmutableMap.Builder<String, ServletHolder> servlets;
    private final ImmutableMultimap.Builder<String, FilterHolder> filters;
    private final ImmutableSet.Builder<EventListener> servletListeners;
    private final ImmutableSet.Builder<Task> tasks;
    private final ImmutableSet.Builder<String> protectedTargets;
    private final ImmutableList.Builder<ServerLifecycleListener> serverListeners;
    private Resource baseResource;
    private final AggregateLifeCycle lifeCycle;
    private final ObjectMapperFactory objectMapperFactory;
    private SessionHandler sessionHandler;
    private ServletContainer jerseyServletContainer;
    private Validator validator;

    public Environment(String name, Configuration configuration, ObjectMapperFactory objectMapperFactory, Validator validator) {
        this.name = name;
        this.configuration = configuration;
        this.objectMapperFactory = objectMapperFactory;
        this.validator = validator;
        this.config = new DropwizardResourceConfig(false){

            public void validate() {
                super.validate();
                Environment.this.logResources();
                Environment.this.logProviders();
                Environment.this.logHealthChecks();
                Environment.this.logManagedObjects();
                Environment.this.logEndpoints();
                Environment.this.logTasks();
            }
        };
        this.healthChecks = ImmutableSet.builder();
        this.servlets = ImmutableMap.builder();
        this.filters = ImmutableMultimap.builder();
        this.servletListeners = ImmutableSet.builder();
        this.tasks = ImmutableSet.builder();
        this.baseResource = Resource.newClassPathResource((String)".");
        this.protectedTargets = ImmutableSet.builder();
        this.serverListeners = ImmutableList.builder();
        this.lifeCycle = new AggregateLifeCycle();
        this.jerseyServletContainer = new ServletContainer((Application)this.config);
        this.addTask(new GarbageCollectionTask());
    }

    protected void doStart() throws Exception {
        this.lifeCycle.start();
    }

    protected void doStop() throws Exception {
        this.lifeCycle.stop();
    }

    public void addResource(Object resource) {
        this.config.getSingletons().add(Preconditions.checkNotNull((Object)resource));
    }

    public void scanPackagesForResourcesAndProviders(Class<?> ... classes) {
        Preconditions.checkNotNull(classes);
        String[] names = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            names[i] = classes[i].getPackage().getName();
        }
        this.config.init((Scanner)new PackageNamesScanner(names));
    }

    public void addResource(Class<?> klass) {
        this.config.getClasses().add(Preconditions.checkNotNull(klass));
    }

    public void addProvider(Object provider) {
        this.config.getSingletons().add(Preconditions.checkNotNull((Object)provider));
    }

    public void addProvider(Class<?> klass) {
        this.config.getClasses().add(Preconditions.checkNotNull(klass));
    }

    public void addHealthCheck(HealthCheck healthCheck) {
        this.healthChecks.add(Preconditions.checkNotNull((Object)healthCheck));
    }

    public void manage(Managed managed) {
        this.lifeCycle.addBean((Object)new JettyManaged((Managed)Preconditions.checkNotNull((Object)managed)));
    }

    public void manage(LifeCycle managed) {
        this.lifeCycle.addBean(Preconditions.checkNotNull((Object)managed));
    }

    public ServletBuilder addServlet(Servlet servlet, String urlPattern) {
        NonblockingServletHolder holder = new NonblockingServletHolder((Servlet)Preconditions.checkNotNull((Object)servlet));
        ServletBuilder servletConfig = new ServletBuilder(holder, this.servlets);
        servletConfig.addUrlPattern((String)Preconditions.checkNotNull((Object)urlPattern));
        return servletConfig;
    }

    public ServletBuilder addServlet(Class<? extends Servlet> klass, String urlPattern) {
        ServletHolder holder = new ServletHolder((Class)Preconditions.checkNotNull(klass));
        ServletBuilder servletConfig = new ServletBuilder(holder, this.servlets);
        servletConfig.addUrlPattern((String)Preconditions.checkNotNull((Object)urlPattern));
        return servletConfig;
    }

    public FilterBuilder addFilter(Filter filter, String urlPattern) {
        FilterHolder holder = new FilterHolder((Filter)Preconditions.checkNotNull((Object)filter));
        FilterBuilder filterConfig = new FilterBuilder(holder, this.filters);
        filterConfig.addUrlPattern((String)Preconditions.checkNotNull((Object)urlPattern));
        return filterConfig;
    }

    public FilterBuilder addFilter(Class<? extends Filter> klass, String urlPattern) {
        FilterHolder holder = new FilterHolder((Class)Preconditions.checkNotNull(klass));
        FilterBuilder filterConfig = new FilterBuilder(holder, this.filters);
        filterConfig.addUrlPattern((String)Preconditions.checkNotNull((Object)urlPattern));
        return filterConfig;
    }

    public void addServletListeners(EventListener ... listeners) {
        this.servletListeners.add((Object[])listeners);
    }

    public void addTask(Task task) {
        this.tasks.add(Preconditions.checkNotNull((Object)task));
    }

    public void addProtectedTarget(String target) {
        this.protectedTargets.add(Preconditions.checkNotNull((Object)target));
    }

    public void setBaseResource(Resource baseResource) {
        this.baseResource = baseResource;
    }

    public void setSessionHandler(SessionHandler sessionHandler) {
        this.sessionHandler = sessionHandler;
    }

    public void enableJerseyFeature(String name) {
        this.config.getFeatures().put(Preconditions.checkNotNull((Object)name), Boolean.TRUE);
    }

    public void disableJerseyFeature(String name) {
        this.config.getFeatures().put(Preconditions.checkNotNull((Object)name), Boolean.FALSE);
    }

    public void setJerseyProperty(String name, @Nullable Object value) {
        this.config.getProperties().put(Preconditions.checkNotNull((Object)name), value);
    }

    public <T> T getJerseyProperty(String name) {
        return (T)this.config.getProperties().get(name);
    }

    public ExecutorService managedExecutorService(String nameFormat, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(nameFormat).build();
        ThreadPoolExecutor executor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, new LinkedBlockingQueue<Runnable>(), threadFactory);
        this.manage(new ExecutorServiceManager(executor, 5L, TimeUnit.SECONDS, nameFormat));
        return executor;
    }

    public ScheduledExecutorService managedScheduledExecutorService(String nameFormat, int corePoolSize) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(nameFormat).build();
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(corePoolSize, threadFactory);
        this.manage(new ExecutorServiceManager(executor, 5L, TimeUnit.SECONDS, nameFormat));
        return executor;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = (Validator)Preconditions.checkNotNull((Object)validator);
    }

    ImmutableSet<HealthCheck> getHealthChecks() {
        return this.healthChecks.build();
    }

    ImmutableMap<String, ServletHolder> getServlets() {
        return this.servlets.build();
    }

    ImmutableMultimap<String, FilterHolder> getFilters() {
        return this.filters.build();
    }

    ImmutableSet<Task> getTasks() {
        return this.tasks.build();
    }

    ImmutableSet<String> getProtectedTargets() {
        return this.protectedTargets.build();
    }

    Resource getBaseResource() {
        return this.baseResource;
    }

    ImmutableSet<EventListener> getServletListeners() {
        return this.servletListeners.build();
    }

    private void logManagedObjects() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Object bean : this.lifeCycle.getBeans()) {
            builder.add((Object)bean.toString());
        }
        LOGGER.debug("managed objects = {}", (Object)builder.build());
    }

    private void logHealthChecks() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (HealthCheck healthCheck : this.healthChecks.build()) {
            String canonicalName = healthCheck.getClass().getCanonicalName();
            if (canonicalName == null) {
                builder.add((Object)String.format("%s(\"%s\")", HealthCheck.class.getCanonicalName(), healthCheck.getName()));
                continue;
            }
            builder.add((Object)canonicalName);
        }
        LOGGER.debug("health checks = {}", (Object)builder.build());
    }

    private void logResources() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Class klass : this.config.getClasses()) {
            if (!klass.isAnnotationPresent(Path.class)) continue;
            builder.add((Object)klass.getCanonicalName());
        }
        for (Object o : this.config.getSingletons()) {
            if (!o.getClass().isAnnotationPresent(Path.class)) continue;
            builder.add((Object)o.getClass().getCanonicalName());
        }
        LOGGER.debug("resources = {}", (Object)builder.build());
    }

    private void logProviders() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Class klass : this.config.getClasses()) {
            if (!klass.isAnnotationPresent(Provider.class)) continue;
            builder.add((Object)klass.getCanonicalName());
        }
        for (Object o : this.config.getSingletons()) {
            if (!o.getClass().isAnnotationPresent(Provider.class)) continue;
            builder.add((Object)o.getClass().getCanonicalName());
        }
        LOGGER.debug("providers = {}", (Object)builder.build());
    }

    private void logEndpoints() {
        StringBuilder stringBuilder = new StringBuilder(1024).append("\n\n");
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Object o : this.config.getSingletons()) {
            if (!o.getClass().isAnnotationPresent(Path.class)) continue;
            builder.add(o.getClass());
        }
        for (Class klass : this.config.getClasses()) {
            if (!klass.isAnnotationPresent(Path.class)) continue;
            builder.add((Object)klass);
        }
        for (Class klass : builder.build()) {
            String path = klass.getAnnotation(Path.class).value();
            ImmutableList.Builder endpoints = ImmutableList.builder();
            for (AnnotatedMethod method : this.annotatedMethods(klass)) {
                String rootPath = this.configuration.getHttpConfiguration().getRootPath();
                if (rootPath.endsWith("/*")) {
                    rootPath = rootPath.substring(0, rootPath.length() - 2);
                }
                StringBuilder pathBuilder = new StringBuilder().append(rootPath).append(path);
                if (method.isAnnotationPresent(Path.class)) {
                    String methodPath = ((Path)method.getAnnotation(Path.class)).value();
                    if (!methodPath.startsWith("/") && !path.endsWith("/")) {
                        pathBuilder.append('/');
                    }
                    pathBuilder.append(methodPath);
                }
                for (HttpMethod verb : method.getMetaMethodAnnotations(HttpMethod.class)) {
                    endpoints.add((Object)String.format("    %-7s %s (%s)", verb.value(), pathBuilder.toString(), klass.getCanonicalName()));
                }
            }
            for (String line : Ordering.natural().sortedCopy((Iterable)endpoints.build())) {
                stringBuilder.append(line).append('\n');
            }
        }
        LOGGER.info(stringBuilder.toString());
    }

    private void logTasks() {
        StringBuilder stringBuilder = new StringBuilder(1024).append("\n\n");
        for (Task task : this.tasks.build()) {
            stringBuilder.append(String.format("    %-7s /tasks/%s (%s)\n", "POST", task.getName(), task.getClass().getCanonicalName()));
        }
        LOGGER.info("tasks = {}", (Object)stringBuilder.toString());
    }

    private MethodList annotatedMethods(Class<?> resource) {
        return new MethodList(resource, true).hasMetaAnnotation(HttpMethod.class);
    }

    public SessionHandler getSessionHandler() {
        return this.sessionHandler;
    }

    public ObjectMapperFactory getObjectMapperFactory() {
        return this.objectMapperFactory;
    }

    public ResourceConfig getJerseyResourceConfig() {
        return this.config;
    }

    public ServletContainer getJerseyServletContainer() {
        return this.jerseyServletContainer;
    }

    public void setJerseyServletContainer(ServletContainer jerseyServletContainer) {
        this.jerseyServletContainer = jerseyServletContainer;
    }

    public String getName() {
        return this.name;
    }

    public List<ServerLifecycleListener> getServerListeners() {
        return this.serverListeners.build();
    }

    public void addServerLifecycleListener(ServerLifecycleListener listener) {
        this.serverListeners.add((Object)listener);
    }
}

