/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.jersey;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Splitter;
import com.yammer.dropwizard.jetty.UnbrandedErrorHandler;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonProcessingExceptionMapper
implements ExceptionMapper<JsonProcessingException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonProcessingExceptionMapper.class);
    private static final Splitter LINE_SPLITTER = Splitter.on((String)"\n").trimResults();
    @Context
    private HttpServletRequest request;
    private final UnbrandedErrorHandler errorHandler = new UnbrandedErrorHandler();

    public Response toResponse(JsonProcessingException exception) {
        if (exception instanceof JsonGenerationException) {
            LOGGER.warn("Error generating JSON", (Throwable)exception);
            return Response.serverError().build();
        }
        String message = exception.getMessage();
        if (message.startsWith("No suitable constructor found")) {
            LOGGER.error("Unable to deserialize the specific type", (Throwable)exception);
            return Response.serverError().build();
        }
        try {
            LOGGER.debug("Unable to process JSON", (Throwable)exception);
            StringWriter writer = new StringWriter(4096);
            this.errorHandler.writeErrorPage(this.request, writer, 400, this.stripLocation(message), false);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.TEXT_HTML_TYPE).entity((Object)writer.toString()).build();
        }
        catch (IOException e) {
            LOGGER.debug("Unable to output error message", (Throwable)e);
            return Response.serverError().build();
        }
    }

    private String stripLocation(String message) {
        Iterator i$ = LINE_SPLITTER.split((CharSequence)message).iterator();
        if (i$.hasNext()) {
            String s = (String)i$.next();
            return s;
        }
        return message;
    }
}

