/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.jetty;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import com.yammer.metrics.core.Clock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.DateCache;
import org.eclipse.jetty.util.component.AbstractLifeCycle;

public class AsyncRequestLog
extends AbstractLifeCycle
implements RequestLog {
    private static final AtomicInteger THREAD_COUNTER = new AtomicInteger();
    private static final int BATCH_SIZE = 10000;
    private final Clock clock;
    private final ThreadLocal<DateCache> dateCache;
    private final BlockingQueue<String> queue;
    private final Dispatcher dispatcher;
    private final Thread dispatchThread;
    private final AppenderAttachableImpl<ILoggingEvent> appenders;

    public AsyncRequestLog(Clock clock, AppenderAttachableImpl<ILoggingEvent> appenders, final TimeZone timeZone) {
        this.clock = clock;
        this.queue = new LinkedBlockingQueue<String>();
        this.dispatcher = new Dispatcher();
        this.dispatchThread = new Thread(this.dispatcher);
        this.dispatchThread.setName("async-request-log-dispatcher-" + THREAD_COUNTER.incrementAndGet());
        this.dispatchThread.setDaemon(true);
        this.dateCache = new ThreadLocal<DateCache>(){

            @Override
            protected DateCache initialValue() {
                DateCache cache = new DateCache("dd/MMM/yyyy:HH:mm:ss Z", Locale.getDefault());
                cache.setTimeZoneID(timeZone.getID());
                return cache;
            }
        };
        this.appenders = appenders;
    }

    protected void doStart() throws Exception {
        Iterator iterator = this.appenders.iteratorForAppenders();
        while (iterator.hasNext()) {
            ((Appender)iterator.next()).start();
        }
        this.dispatchThread.start();
    }

    protected void doStop() throws Exception {
        this.dispatcher.stop();
        Iterator iterator = this.appenders.iteratorForAppenders();
        while (iterator.hasNext()) {
            ((Appender)iterator.next()).stop();
        }
    }

    public void log(Request request, Response response) {
        StringBuilder buf = new StringBuilder(256);
        String address = request.getHeader("X-Forwarded-For");
        if (address == null) {
            address = request.getRemoteAddr();
        }
        buf.append(address);
        buf.append(" - ");
        Authentication authentication = request.getAuthentication();
        if (authentication instanceof Authentication.User) {
            buf.append(((Authentication.User)authentication).getUserIdentity().getUserPrincipal().getName());
        } else {
            buf.append('-');
        }
        buf.append(" [");
        buf.append(this.dateCache.get().format(request.getTimeStamp()));
        buf.append("] \"");
        buf.append(request.getMethod());
        buf.append(' ');
        buf.append(request.getUri().toString());
        buf.append(' ');
        buf.append(request.getProtocol());
        buf.append("\" ");
        if (request.getAsyncContinuation().isInitial()) {
            int status = response.getStatus();
            if (status <= 0) {
                status = 404;
            }
            buf.append((char)(48 + status / 100 % 10));
            buf.append((char)(48 + status / 10 % 10));
            buf.append((char)(48 + status % 10));
        } else {
            buf.append("Async");
        }
        long responseLength = response.getContentCount();
        if (responseLength >= 0L) {
            buf.append(' ');
            if (responseLength > 99999L) {
                buf.append(responseLength);
            } else {
                if (responseLength > 9999L) {
                    buf.append((char)(48L + responseLength / 10000L % 10L));
                }
                if (responseLength > 999L) {
                    buf.append((char)(48L + responseLength / 1000L % 10L));
                }
                if (responseLength > 99L) {
                    buf.append((char)(48L + responseLength / 100L % 10L));
                }
                if (responseLength > 9L) {
                    buf.append((char)(48L + responseLength / 10L % 10L));
                }
                buf.append((char)(48L + responseLength % 10L));
            }
        } else {
            buf.append(" -");
        }
        long now = this.clock.time();
        long dispatchTime = request.getDispatchTime();
        buf.append(' ');
        buf.append(now - (dispatchTime == 0L ? request.getTimeStamp() : dispatchTime));
        buf.append(' ');
        buf.append(now - request.getTimeStamp());
        this.queue.add(buf.toString());
    }

    private class Dispatcher
    implements Runnable {
        private volatile boolean running = true;
        private final List<String> statements = new ArrayList<String>(10000);

        private Dispatcher() {
        }

        @Override
        public void run() {
            while (this.running) {
                try {
                    this.statements.add((String)AsyncRequestLog.this.queue.take());
                    AsyncRequestLog.this.queue.drainTo(this.statements, 10000);
                    for (String statement : this.statements) {
                        LoggingEvent event = new LoggingEvent();
                        event.setLevel(Level.INFO);
                        event.setMessage(statement);
                        AsyncRequestLog.this.appenders.appendLoopOnAppenders((Object)event);
                    }
                    this.statements.clear();
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        public void stop() {
            this.running = false;
        }
    }
}

