/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.util;

import com.google.common.base.Preconditions;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class Generics {
    private Generics() {
    }

    public static <T> Class<T> getTypeParameter(Class<?> klass, Class<? super T> bound) {
        Type t = (Type)Preconditions.checkNotNull(klass);
        while (t instanceof Class) {
            t = ((Class)t).getGenericSuperclass();
        }
        if (t instanceof ParameterizedType) {
            for (Type param : ((ParameterizedType)t).getActualTypeArguments()) {
                Class cls;
                if (!(param instanceof Class) || !bound.isAssignableFrom(cls = (Class)param)) continue;
                return cls;
            }
        }
        throw new IllegalStateException("Cannot figure out type parameterization for " + klass.getName());
    }

    public static Class<?> getTypeParameter(Class<?> klass) {
        return Generics.getTypeParameter(klass, Object.class);
    }
}

