/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.assets;

import com.google.common.base.Preconditions;
import com.yammer.dropwizard.Bundle;
import com.yammer.dropwizard.assets.AssetServlet;
import com.yammer.dropwizard.config.Bootstrap;
import com.yammer.dropwizard.config.Environment;
import javax.servlet.Servlet;

public class AssetsBundle
implements Bundle {
    private static final String DEFAULT_INDEX_FILE = "index.htm";
    private static final String DEFAULT_PATH = "/assets";
    private final String resourcePath;
    private final String uriPath;
    private final String indexFile;

    public AssetsBundle() {
        this(DEFAULT_PATH, DEFAULT_PATH, DEFAULT_INDEX_FILE);
    }

    public AssetsBundle(String path) {
        this(path, path, DEFAULT_INDEX_FILE);
    }

    public AssetsBundle(String resourcePath, String uriPath) {
        this(resourcePath, uriPath, DEFAULT_INDEX_FILE);
    }

    public AssetsBundle(String resourcePath, String uriPath, String indexFile) {
        Preconditions.checkArgument((boolean)resourcePath.startsWith("/"), (String)"%s is not an absolute path", (Object[])new Object[]{resourcePath});
        Preconditions.checkArgument((!"/".equals(resourcePath) ? 1 : 0) != 0, (String)"%s is the classpath root", (Object[])new Object[]{resourcePath});
        this.resourcePath = resourcePath.endsWith("/") ? resourcePath : resourcePath + '/';
        this.uriPath = uriPath.endsWith("/") ? uriPath : uriPath + '/';
        this.indexFile = indexFile;
    }

    @Override
    public void initialize(Bootstrap<?> bootstrap) {
    }

    @Override
    public void run(Environment environment) {
        environment.addServlet((Servlet)this.createServlet(), this.uriPath + '*');
    }

    private AssetServlet createServlet() {
        return new AssetServlet(this.resourcePath, this.uriPath, this.indexFile);
    }
}

