/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.cli;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.yammer.dropwizard.Service;
import com.yammer.dropwizard.cli.EnvironmentCommand;
import com.yammer.dropwizard.config.Configuration;
import com.yammer.dropwizard.config.Environment;
import com.yammer.dropwizard.config.ServerFactory;
import com.yammer.dropwizard.lifecycle.ServerLifecycleListener;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import net.sourceforge.argparse4j.inf.Namespace;
import org.eclipse.jetty.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerCommand<T extends Configuration>
extends EnvironmentCommand<T> {
    private final Class<T> configurationClass;

    public ServerCommand(Service<T> service) {
        super(service, "server", "Runs the Dropwizard service as an HTTP server");
        this.configurationClass = service.getConfigurationClass();
    }

    @Override
    protected Class<T> getConfigurationClass() {
        return this.configurationClass;
    }

    @Override
    protected void run(Environment environment, Namespace namespace, T configuration) throws Exception {
        Server server = new ServerFactory(((Configuration)configuration).getHttpConfiguration(), environment.getName()).buildServer(environment);
        Logger logger = LoggerFactory.getLogger(ServerCommand.class);
        this.logBanner(environment.getName(), logger);
        try {
            server.start();
            for (ServerLifecycleListener listener : environment.getServerListeners()) {
                listener.serverStarted(server);
            }
        }
        catch (Exception e) {
            logger.error("Unable to start server, shutting down", (Throwable)e);
            server.stop();
        }
    }

    private void logBanner(String name, Logger logger) {
        try {
            String banner = Resources.toString((URL)Resources.getResource((String)"banner.txt"), (Charset)Charsets.UTF_8);
            logger.info("Starting {}\n{}", (Object)name, (Object)banner);
        }
        catch (IllegalArgumentException ignored) {
            logger.info("Starting {}", (Object)name);
        }
        catch (IOException ignored) {
            logger.info("Starting {}", (Object)name);
        }
    }
}

