/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.config;

import ch.qos.logback.classic.Level;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.yammer.dropwizard.validation.ValidationMethod;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class LoggingConfiguration {
    static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    @NotNull
    @JsonProperty
    private Level level = Level.INFO;
    @NotNull
    @JsonProperty
    private ImmutableMap<String, Level> loggers = ImmutableMap.of();
    @Valid
    @NotNull
    @JsonProperty
    private ConsoleConfiguration console = new ConsoleConfiguration();
    @Valid
    @NotNull
    @JsonProperty
    private FileConfiguration file = new FileConfiguration();
    @Valid
    @NotNull
    @JsonProperty
    private SyslogConfiguration syslog = new SyslogConfiguration();

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public ImmutableMap<String, Level> getLoggers() {
        return this.loggers;
    }

    public void setLoggers(Map<String, Level> loggers) {
        this.loggers = ImmutableMap.copyOf(loggers);
    }

    public ConsoleConfiguration getConsoleConfiguration() {
        return this.console;
    }

    public void setConsoleConfiguration(ConsoleConfiguration config) {
        this.console = config;
    }

    public FileConfiguration getFileConfiguration() {
        return this.file;
    }

    public void setFileConfiguration(FileConfiguration config) {
        this.file = config;
    }

    public SyslogConfiguration getSyslogConfiguration() {
        return this.syslog;
    }

    public void setSyslogConfiguration(SyslogConfiguration config) {
        this.syslog = config;
    }

    public static class SyslogConfiguration {
        @JsonProperty
        private boolean enabled = false;
        @NotNull
        @JsonProperty
        private Level threshold = Level.ALL;
        @NotNull
        @JsonProperty
        private String host = "localhost";
        @NotNull
        @JsonProperty
        private Facility facility = Facility.LOCAL0;
        @NotNull
        @JsonProperty
        private TimeZone timeZone = UTC;
        @JsonProperty
        private String logFormat;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public Level getThreshold() {
            return this.threshold;
        }

        public void setThreshold(Level threshold) {
            this.threshold = threshold;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public Facility getFacility() {
            return this.facility;
        }

        public void setFacility(Facility facility) {
            this.facility = facility;
        }

        public TimeZone getTimeZone() {
            return this.timeZone;
        }

        public void setTimeZone(TimeZone timeZone) {
            this.timeZone = timeZone;
        }

        public Optional<String> getLogFormat() {
            return Optional.fromNullable((Object)this.logFormat);
        }

        public void setLogFormat(String logFormat) {
            this.logFormat = logFormat;
        }

        public static enum Facility {
            AUTH,
            AUTHPRIV,
            DAEMON,
            CRON,
            FTP,
            LPR,
            KERN,
            MAIL,
            NEWS,
            SYSLOG,
            USER,
            UUCP,
            LOCAL0,
            LOCAL1,
            LOCAL2,
            LOCAL3,
            LOCAL4,
            LOCAL5,
            LOCAL6,
            LOCAL7;


            @JsonValue
            public String toString() {
                return super.toString().replace("_", "+").toLowerCase(Locale.ENGLISH);
            }

            @JsonCreator
            public static Facility parse(String facility) {
                return Facility.valueOf(facility.toUpperCase(Locale.ENGLISH).replace('+', '_'));
            }
        }
    }

    public static class FileConfiguration {
        @JsonProperty
        private boolean enabled = false;
        @NotNull
        @JsonProperty
        private Level threshold = Level.ALL;
        @JsonProperty
        private String currentLogFilename;
        @JsonProperty
        private boolean archive = true;
        @JsonProperty
        private String archivedLogFilenamePattern;
        @Min(value=1L)
        @Max(value=50L)
        @JsonProperty
        private int archivedFileCount = 5;
        @NotNull
        @JsonProperty
        private TimeZone timeZone = UTC;
        @JsonProperty
        private String logFormat;

        @ValidationMethod(message="must have logging.file.archivedLogFilenamePattern if logging.file.archive is true")
        public boolean isValidArchiveConfiguration() {
            return !this.enabled || !this.archive || this.archivedLogFilenamePattern != null;
        }

        @ValidationMethod(message="must have logging.file.currentLogFilename if logging.file.enabled is true")
        public boolean isConfigured() {
            return !this.enabled || this.currentLogFilename != null;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public Level getThreshold() {
            return this.threshold;
        }

        public void setThreshold(Level level) {
            this.threshold = level;
        }

        public String getCurrentLogFilename() {
            return this.currentLogFilename;
        }

        public void setCurrentLogFilename(String filename) {
            this.currentLogFilename = filename;
        }

        public boolean isArchive() {
            return this.archive;
        }

        public void setArchive(boolean archive) {
            this.archive = archive;
        }

        public int getArchivedFileCount() {
            return this.archivedFileCount;
        }

        public void setArchivedFileCount(int count) {
            this.archivedFileCount = count;
        }

        public String getArchivedLogFilenamePattern() {
            return this.archivedLogFilenamePattern;
        }

        public void setArchivedLogFilenamePattern(String pattern) {
            this.archivedLogFilenamePattern = pattern;
        }

        public TimeZone getTimeZone() {
            return this.timeZone;
        }

        public void setTimeZone(TimeZone timeZone) {
            this.timeZone = timeZone;
        }

        public Optional<String> getLogFormat() {
            return Optional.fromNullable((Object)this.logFormat);
        }

        public void setLogFormat(String logFormat) {
            this.logFormat = logFormat;
        }
    }

    public static class ConsoleConfiguration {
        @JsonProperty
        private boolean enabled = true;
        @NotNull
        @JsonProperty
        private Level threshold = Level.ALL;
        @NotNull
        @JsonProperty
        private TimeZone timeZone = UTC;
        @JsonProperty
        private String logFormat;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public Level getThreshold() {
            return this.threshold;
        }

        public void setThreshold(Level threshold) {
            this.threshold = threshold;
        }

        public TimeZone getTimeZone() {
            return this.timeZone;
        }

        public void setTimeZone(TimeZone timeZone) {
            this.timeZone = timeZone;
        }

        public Optional<String> getLogFormat() {
            return Optional.fromNullable((Object)this.logFormat);
        }

        public void setLogFormat(String logFormat) {
            this.logFormat = logFormat;
        }
    }
}

